/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.indexer;

import com.ibm.es.nuvo.api.DocumentPipelineExtension;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.ConfigurationManager;
import com.ibm.es.nuvo.configuration.DocumentPipelineExtensionManager;
import com.ibm.es.nuvo.configuration.IndexDescriptor;
import com.ibm.es.nuvo.indexer.DocumentStatus;
import com.ibm.es.nuvo.indexer.IndexWriterContainer;
import com.ibm.es.nuvo.indexer.Indexer;
import com.ibm.es.nuvo.indexer.IndexerException;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.search.cache.CacheSearcher;
import com.ibm.es.nuvo.search.cache.CachedDocument;
import java.io.IOException;
import java.util.logging.Level;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;

public class IndexRebuilder {
    private IndexReader indexReader = null;
    private CacheSearcher cacheReader = null;
    private int markerDocId = -1;
    private int nextDocToProcess = -1;
    private static final String MARKER_URI = "_mark:rebuild";
    private static final Term MARKER_TERM = new Term("uri", "_mark:rebuild");
    private String collectionId = null;

    public void close() {
        IndexerException ie;
        Message msg;
        if (this.indexReader != null) {
            try {
                this.indexReader.close();
            }
            catch (IOException e) {
                msg = new Message("I0013E.CANNOT_CLOSE_INDEX");
                msg.addArgument(this.collectionId);
                ie = new IndexerException(msg);
                ie.initCause(e);
                Loggers.logger.log(Level.SEVERE, ie);
            }
            this.indexReader = null;
        }
        if (this.cacheReader != null) {
            try {
                this.cacheReader.close();
            }
            catch (IOException e) {
                msg = new Message("I0013E.CANNOT_CLOSE_INDEX");
                msg.addArgument(this.collectionId);
                ie = new IndexerException(msg);
                ie.initCause(e);
                Loggers.logger.log(Level.SEVERE, ie);
            }
            this.cacheReader = null;
        }
    }

    public void finalize() {
        this.close();
    }

    private void open(CollectionConfiguration config) throws IndexerException {
        this.collectionId = config.getId();
        try {
            String indexDir = config.getIndexPath(IndexDescriptor.IndexType.Text);
            String cacheDir = config.getIndexPath(IndexDescriptor.IndexType.Cache);
            try {
                this.indexReader = IndexReader.open((String)indexDir);
            }
            catch (IOException e) {
                Message msg = new Message("I0045E.REBUILD_INDEX_OPEN");
                msg.addArgument(this.collectionId);
                IndexerException ie = new IndexerException(msg);
                ie.initCause(e);
                throw ie;
            }
            try {
                this.cacheReader = new CacheSearcher(cacheDir);
            }
            catch (Exception e) {
                Message msg = new Message("I0036E.REBUILD_CACHE_OPEN");
                msg.addArgument(this.collectionId);
                IndexerException ie = new IndexerException(msg);
                ie.initCause(e);
                throw ie;
            }
        }
        catch (IndexerException e) {
            this.close();
            throw e;
        }
    }

    static int findMarker(IndexReader reader) throws IOException {
        int docId = -1;
        TermDocs markerDocs = reader.termDocs(MARKER_TERM);
        while (markerDocs.next()) {
            if (reader.isDeleted(markerDocs.doc())) continue;
            docId = markerDocs.doc();
        }
        return docId;
    }

    void initiateRebuild(CollectionConfiguration config, IndexWriterContainer indexWriter, Analyzer analyzer) throws IndexerException {
        CacheSearcher cacheSearcher;
        String cachePath = config.getIndexPath(IndexDescriptor.IndexType.Cache);
        if (cachePath == null) {
            Message msg = new Message("I0035E.REBUILD_WITHOUT_CACHE");
            msg.addArgument(config.getId());
            throw new IndexerException(msg);
        }
        try {
            cacheSearcher = new CacheSearcher(cachePath);
        }
        catch (IOException e) {
            Message msg = new Message("I0036E.REBUILD_CACHE_OPEN");
            msg.addArgument(config.getId());
            IndexerException ie = new IndexerException(msg);
            ie.initCause(e);
            msg = new Message("I0034E.REBUILD_NOT_INITIATED");
            msg.addArgument(config.getId());
            IndexerException ie2 = new IndexerException(msg);
            ie2.initCause(ie);
            throw ie2;
        }
        boolean cacheAppearsValid = false;
        CachedDocument cachedDoc = null;
        try {
            for (int i = 0; i < cacheSearcher.maxDoc(); ++i) {
                if (cacheSearcher.getIndexReader().isDeleted(i)) continue;
                cachedDoc = new CachedDocument(cacheSearcher.doc(i));
                cacheAppearsValid = cachedDoc.getMetadata() != null;
                break;
            }
        }
        catch (IOException e) {
            Message msg = new Message("I0037E.REBUILD_CACHE_READ");
            msg.addArgument(config.getId());
            IndexerException ie = new IndexerException(msg);
            ie.initCause(e);
            msg = new Message("I0034E.REBUILD_NOT_INITIATED");
            msg.addArgument(config.getId());
            IndexerException ie2 = new IndexerException(msg);
            ie2.initCause(ie);
            throw ie2;
        }
        if (!cacheAppearsValid && cachedDoc != null) {
            Message msg = new Message("I0038E.REBUILD_WITHOUT_METADATA");
            msg.addArgument(cachedDoc.getUri());
            IndexerException ie = new IndexerException(msg);
            msg = new Message("I0034E.REBUILD_NOT_INITIATED");
            msg.addArgument(config.getId());
            IndexerException ie2 = new IndexerException(msg);
            ie2.initCause(ie);
            throw ie2;
        }
        Document doc = new Document();
        Field field = new Field("uri", MARKER_URI, Field.Store.YES, Field.Index.UN_TOKENIZED);
        field.setOmitNorms(true);
        doc.add((Fieldable)field);
        doc.add((Fieldable)DocumentStatus.newStatusField(110));
        try {
            indexWriter.updateDocument(MARKER_TERM, doc, analyzer);
        }
        catch (IOException e) {
            Message msg = new Message("I0039E.REBUILD_INSERT_MARKER");
            IndexerException ie = new IndexerException(msg);
            ie.initCause(e);
            msg = new Message("I0034E.REBUILD_NOT_INITIATED");
            msg.addArgument(config.getId());
            IndexerException ie2 = new IndexerException(msg);
            ie2.initCause(ie);
            throw ie2;
        }
        try {
            ConfigurationManager configManager = ConfigurationManager.getConfigurationManager();
            config = configManager.getCollectionForUpdate(config.getId());
            config.setRebuildState(CollectionConfiguration.RebuildState.InProgress);
            configManager.updateCollection(config);
        }
        catch (ExtendedException e) {
            Message msg = new Message("I0034E.REBUILD_NOT_INITIATED");
            msg.addArgument(config.getId());
            IndexerException ie = new IndexerException(msg);
            ie.initCause(e);
            throw ie;
        }
        DocumentPipelineExtension ext = DocumentPipelineExtensionManager.getInstance().getExtension(config.getId());
        if (ext != null) {
            ext.reset();
        }
    }

    public void endRebuild(CollectionConfiguration config, IndexWriterContainer indexWriter, boolean successful) throws IndexerException {
        this.close();
        try {
            CollectionConfiguration.RebuildState newState = successful ? CollectionConfiguration.RebuildState.Complete : CollectionConfiguration.RebuildState.FinishedWithErrors;
            ConfigurationManager configManager = ConfigurationManager.getConfigurationManager();
            config = configManager.getCollectionForUpdate(config.getId());
            config.setRebuildState(newState);
            configManager.updateCollection(config);
            try {
                indexWriter.deleteDocuments(MARKER_TERM);
            }
            catch (IOException e) {
                Message msg = new Message("I0040E.REBUILD_REMOVE_MARKER");
                IndexerException ie = new IndexerException(msg);
                ie.initCause(e);
                throw ie;
            }
        }
        catch (ExtendedException e) {
            Message msg = new Message("I0041E.REBUILD_NOT_FINISHED");
            msg.addArgument(config.getId());
            IndexerException ie = new IndexerException(msg);
            ie.initCause(e);
            throw ie;
        }
    }

    public void doRebuild(long nanoTimeout, CollectionConfiguration config, Indexer indexer, IndexWriterContainer indexWriter) throws IndexerException {
        try {
            if (this.indexReader == null || this.cacheReader == null) {
                this.close();
                this.open(config);
                this.markerDocId = IndexRebuilder.findMarker(this.indexReader);
                this.nextDocToProcess = 0;
            }
            if (this.markerDocId == -1) {
                this.endRebuild(config, indexWriter, true);
                return;
            }
            while (this.nextDocToProcess < this.markerDocId) {
                if (this.indexReader.isDeleted(this.nextDocToProcess)) {
                    ++this.nextDocToProcess;
                    continue;
                }
                this.doOneDocument(this.nextDocToProcess, indexer);
                ++this.nextDocToProcess;
                if (System.nanoTime() <= nanoTimeout) continue;
                break;
            }
            if (this.nextDocToProcess >= this.markerDocId) {
                this.endRebuild(config, indexWriter, true);
                Message msg = new Message("I0047I.REBUILD_SUCCESS");
                msg.addArgument(config.getId());
                if (Loggers.logger.isLoggable(Level.INFO)) {
                    Loggers.logger.log(Level.INFO, msg);
                }
            }
        }
        catch (Exception e) {
            try {
                this.endRebuild(config, indexWriter, false);
            }
            catch (IndexerException e1) {
                Loggers.logger.log(e1);
            }
            Message msg = new Message("I0046E.REBUILD_FAILED");
            msg.addArgument(config.getId());
            IndexerException ie = new IndexerException(msg);
            ie.initCause(e);
            throw ie;
        }
    }

    private void doOneDocument(int docid, Indexer indexer) throws IndexerException {
        CachedDocument cacheDoc;
        Document doc;
        try {
            doc = this.indexReader.document(docid);
        }
        catch (IOException e) {
            Message msg = new Message("I0042E.REBUILD_INDEX_READ");
            msg.addArgument(docid);
            IndexerException ie = new IndexerException(msg);
            ie.initCause(e);
            throw ie;
        }
        String uri = doc.get("uri");
        if (uri == null) {
            return;
        }
        try {
            cacheDoc = this.cacheReader.getCachedDocument(uri);
        }
        catch (IOException e) {
            Message msg = new Message("I0043E.REBUILD_CACHE_LOAD");
            msg.addArgument(uri);
            IndexerException ie = new IndexerException(msg);
            ie.initCause(e);
            throw ie;
        }
        if (cacheDoc == null) {
            Message msg = new Message("I0044E.REBUILD_NOT_IN_CACHE");
            msg.addArgument(uri);
            IndexerException ie = new IndexerException(msg);
            throw ie;
        }
        if (cacheDoc.getMetadata() == null) {
            Message msg = new Message("I0038E.REBUILD_WITHOUT_METADATA");
            msg.addArgument(uri);
            IndexerException ie = new IndexerException(msg);
            throw ie;
        }
        indexer.processDocument(cacheDoc);
    }

    static int getRebuildProgress(CollectionConfiguration config) throws IndexerException {
        if (!config.isRebuilding()) {
            return -1;
        }
        String indexDir = config.getIndexPath(IndexDescriptor.IndexType.Text);
        IndexReader reader = null;
        try {
            int percentage;
            reader = IndexReader.open((String)indexDir);
            int markerId = IndexRebuilder.findMarker(reader);
            if (markerId == -1) {
                int n = -1;
                return n;
            }
            int remaining = 0;
            for (int i = 0; i < markerId; ++i) {
                if (reader.isDeleted(i)) continue;
                ++remaining;
            }
            int total = reader.numDocs() - 1;
            int done = total - remaining;
            int n = percentage = (int)((long)done * 100L / (long)total);
            return n;
        }
        catch (IOException e) {
            Message msg = new Message("I0045E.REBUILD_INDEX_OPEN");
            msg.addArgument(config.getId());
            IndexerException ie = new IndexerException(msg);
            ie.initCause(e);
            throw ie;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    Message msg = new Message("I0013E.CANNOT_CLOSE_INDEX");
                    IndexerException ie = new IndexerException(msg);
                    ie.initCause(e);
                    Loggers.logger.log(Level.SEVERE, ie);
                }
            }
        }
    }
}

