/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.indexer;

import com.ibm.es.nuvo.GlobalSystem;
import com.ibm.es.nuvo.configuration.ConfigurationManagerException;
import com.ibm.es.nuvo.documentqueue.DeleteDocument;
import com.ibm.es.nuvo.documentqueue.StreamedDocument;
import com.ibm.es.nuvo.documentqueue.UpdateIndexDocument;
import com.ibm.es.nuvo.indexer.DocumentIndexer;
import com.ibm.es.nuvo.indexer.IndexerException;
import com.ibm.es.nuvo.indexer.IndexerMonitor;
import com.ibm.siapi.SiapiException;
import com.ibm.siapi.common.CollectionInfo;
import com.ibm.siapi.index.AutoMaintenancePolicy;
import com.ibm.siapi.index.DocStats;
import com.ibm.siapi.index.Document;
import com.ibm.siapi.index.Index;
import com.ibm.siapi.index.IndexStats;
import com.ibm.siapi.index.WordStats;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;

public class IndexImpl
implements Index {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private DocumentIndexer documentIndexer;
    private String collectionId;

    public IndexImpl(DocumentIndexer documentIndexer, String collectionId) {
        this.documentIndexer = documentIndexer;
        this.collectionId = collectionId;
    }

    public void addDocument(Document arg0) throws SiapiException {
    }

    public void addDocument(Document arg0, HashMap arg1) throws SiapiException {
    }

    public void addOrReplaceDocument(Document document) throws SiapiException {
        if (document instanceof StreamedDocument) {
            this.addOrReplaceDocument((StreamedDocument)document);
        }
    }

    public void addOrReplaceDocument(Document arg0, HashMap arg1) throws SiapiException {
    }

    public void removeDocument(String uri) throws SiapiException {
        DeleteDocument doc = new DeleteDocument(uri);
        try {
            this.documentIndexer.processDocument(this.collectionId, doc);
        }
        catch (ConfigurationManagerException e) {
            throw new SiapiException(1, 24, e.getMessage());
        }
        catch (IndexerException e) {
            throw new SiapiException(1, 22, e.getMessage());
        }
    }

    public void build() throws SiapiException {
        try {
            UpdateIndexDocument document = new UpdateIndexDocument();
            this.documentIndexer.processDocument(this.collectionId, document);
        }
        catch (ConfigurationManagerException e) {
            throw new SiapiException(1, 24, e.getMessage());
        }
        catch (IndexerException e) {
            throw new SiapiException(1, 22, e.getMessage());
        }
    }

    public void reorganize() throws SiapiException {
    }

    public void setProperty(String arg0, String arg1) throws SiapiException {
    }

    public String getProperty(String arg0) {
        return null;
    }

    public Properties getProperties() {
        return null;
    }

    public IndexStats getStatistics() {
        IndexerMonitor indexerMonitor = GlobalSystem.getSingleInstance().getIndexerMonitor();
        return indexerMonitor.getIndexStatistics(this.collectionId);
    }

    public DocStats getDocStatistics(String arg0) {
        return null;
    }

    public Iterator getDocStatistics() {
        return null;
    }

    public WordStats getWordStatistics(String arg0) {
        return null;
    }

    public Iterator getWordStatistics() {
        return null;
    }

    public String getDefaultLanguage() {
        return null;
    }

    public void setDefaultLanguage(String arg0) {
    }

    public String getIndexID() {
        return null;
    }

    public void setSpellCorrectionEnabled(boolean arg0) throws SiapiException {
    }

    public boolean isSpellCorrectionEnabled() {
        return false;
    }

    public AutoMaintenancePolicy getAutoMaintenancePolicy() {
        return null;
    }

    public void setAutoMaintenancePolicy(AutoMaintenancePolicy arg0) throws SiapiException {
    }

    public CollectionInfo getCollectionInfo() {
        return null;
    }

    private void addOrReplaceDocument(StreamedDocument document) throws SiapiException {
        try {
            this.documentIndexer.processDocument(this.collectionId, document, true);
        }
        catch (ConfigurationManagerException e) {
            throw new SiapiException(1, 24, e.getFormattedText());
        }
        catch (IndexerException e) {
            throw new SiapiException(1, 22, e.getFormattedText());
        }
    }
}

