/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.indexer;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexOutput;

public class ExtendedIndexWriter
extends IndexWriter {
    private long maxBufferSize = Long.MAX_VALUE;
    private Lock lock = new ReentrantLock();
    private boolean enforceLocking = true;
    private int inAddDocumentCount = 0;
    private Object waitForAddDocument = new Object();
    private boolean shutdownCalled = false;

    public ExtendedIndexWriter(Directory d, Analyzer a) throws IOException {
        super(d, a);
    }

    public ExtendedIndexWriter(Directory d, Analyzer a, boolean create) throws IOException {
        super(d, a, create);
    }

    public ExtendedIndexWriter(File path, Analyzer a, boolean create) throws IOException {
        super(path, a, create);
    }

    public ExtendedIndexWriter(File path, Analyzer a) throws IOException {
        super(path, a);
    }

    public ExtendedIndexWriter(String path, Analyzer a, boolean create) throws IOException {
        super(path, a, create);
    }

    public ExtendedIndexWriter(String path, Analyzer a) throws IOException {
        super(path, a);
    }

    private void flushIfBufferFull() throws IOException {
        if (super.ramSizeInBytes() > this.maxBufferSize) {
            super.flush();
        }
    }

    public void setMaxBufferSize(long size) {
        this.maxBufferSize = size;
    }

    private void checkShutdownCalled() throws IOException {
        if (this.shutdownCalled) {
            throw new IOException("IndexWriter already closed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAddDocument() throws IOException {
        Object object = this.waitForAddDocument;
        synchronized (object) {
            this.checkShutdownCalled();
            ++this.inAddDocumentCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endAddDocument() {
        Object object = this.waitForAddDocument;
        synchronized (object) {
            --this.inAddDocumentCount;
            this.waitForAddDocument.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForAddDocument() {
        Object object = this.waitForAddDocument;
        synchronized (object) {
            this.shutdownCalled = true;
            while (this.inAddDocumentCount > 0) {
                try {
                    this.waitForAddDocument.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addDocument(Document d) throws IOException {
        try {
            if (this.enforceLocking) {
                this.lock.lock();
            }
            this.startAddDocument();
            try {
                super.addDocument(d);
                this.flushIfBufferFull();
            }
            catch (IndexWriterInterruptException e) {
                this.flushAfterInterrupt();
            }
            finally {
                this.endAddDocument();
            }
        }
        finally {
            if (this.enforceLocking) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDocument(Document d, Analyzer a) throws IOException {
        try {
            if (this.enforceLocking) {
                this.lock.lock();
            }
            this.startAddDocument();
            try {
                super.addDocument(d, a);
                this.flushIfBufferFull();
            }
            catch (IndexWriterInterruptException e) {
                this.flushAfterInterrupt();
            }
            finally {
                this.endAddDocument();
            }
        }
        finally {
            if (this.enforceLocking) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDocument(Term t, Document d) throws IOException {
        try {
            if (this.enforceLocking) {
                this.lock.lock();
            }
            this.startAddDocument();
            try {
                super.updateDocument(t, d);
                this.flushIfBufferFull();
            }
            catch (IndexWriterInterruptException e) {
                this.flushAfterInterrupt();
            }
            finally {
                this.endAddDocument();
            }
        }
        finally {
            if (this.enforceLocking) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDocument(Term t, Document d, Analyzer a) throws IOException {
        try {
            if (this.enforceLocking) {
                this.lock.lock();
            }
            this.startAddDocument();
            try {
                super.updateDocument(t, d, a);
                this.flushIfBufferFull();
            }
            catch (IndexWriterInterruptException e) {
                this.flushAfterInterrupt();
            }
            finally {
                this.endAddDocument();
            }
        }
        finally {
            if (this.enforceLocking) {
                this.lock.unlock();
            }
        }
    }

    public synchronized void deleteDocuments(Term term) throws IOException {
        this.checkShutdownCalled();
        try {
            super.deleteDocuments(term);
            this.flushIfBufferFull();
        }
        catch (IndexWriterInterruptException e) {
            this.flushAfterInterrupt();
        }
    }

    public synchronized void deleteDocuments(Term[] terms) throws IOException {
        this.checkShutdownCalled();
        try {
            super.deleteDocuments(terms);
            this.flushIfBufferFull();
        }
        catch (IndexWriterInterruptException e) {
            this.flushAfterInterrupt();
        }
    }

    private void flushAfterInterrupt() throws IOException {
        ((ExtendedFSDirectory)this.getDirectory()).clearInterrupt();
        super.flushRamSegments(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws IOException {
        Directory d = this.getDirectory();
        try {
            if (d instanceof ExtendedFSDirectory) {
                ((ExtendedFSDirectory)d).interrupt();
            }
            this.waitForAddDocument();
            try {
                super.flushRamSegments(false);
            }
            catch (IndexWriterInterruptException e) {
                this.flushAfterInterrupt();
            }
            this.close();
        }
        finally {
            if (d instanceof ExtendedFSDirectory) {
                ((ExtendedFSDirectory)d).clearInterrupt();
            }
        }
    }

    static final class IndexWriterInterruptException
    extends IOException {
        private static final long serialVersionUID = 1L;

        IndexWriterInterruptException() {
        }
    }

    public static class ExtendedFSDirectory
    extends FSDirectory {
        private boolean interrupted = false;

        public void interrupt() {
            this.interrupted = true;
        }

        public void clearInterrupt() {
            this.interrupted = false;
        }

        public IndexOutput createOutput(String name) throws IOException {
            File file = new File(this.getFile(), name);
            if (file.exists() && !file.delete()) {
                throw new IOException("Cannot overwrite: " + file);
            }
            return new FSDirectory.FSIndexOutput(file){

                public void flushBuffer(byte[] b, int offset, int size) throws IOException {
                    if (ExtendedFSDirectory.this.interrupted) {
                        throw new IndexWriterInterruptException();
                    }
                    super.flushBuffer(b, offset, size);
                }
            };
        }
    }
}

