/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.indexer;

import com.ibm.es.nuvo.tokenizer.ListedTokenStream;
import com.ibm.es.nuvo.util.StringUtils;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.Term;

public class DocumentStatus {
    public static final int SC_OK = 200;
    public static final int SC_TRUNCATED = 206;
    public static final int SC_ERROR = 404;
    public static final int SC_UNSUPPORTED_TYPE = 415;
    public static final int SC_MALFORMED_ENCODING = 421;
    public static final int SC_MALFORMED_FORMAT = 422;
    public static final int SC_REBUILD_MARKER = 110;
    private static final String STR_OK = Integer.toString(200);
    private static final String STR_TRUNCATED = Integer.toString(206);
    public static final String SUCCESS_STRING = "ok";
    public static final Term SUCCESS_TERM = new Term("_code", "ok");

    public static final boolean isSuccess(String code) {
        return STR_OK.equals(code) || STR_TRUNCATED.equals(code);
    }

    public static final Field newStatusField(int status) {
        Field field = new Field("_code", Integer.toString(status), Field.Store.YES, Field.Index.TOKENIZED);
        field.setOmitNorms(true);
        return field;
    }

    public static final TokenStream tokenStream(Reader reader) {
        ArrayList<String> terms = new ArrayList<String>();
        try {
            String value = StringUtils.readerToString(reader);
            terms.add(value);
            if (DocumentStatus.isSuccess(value)) {
                terms.add(SUCCESS_STRING);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new ListedTokenStream(terms);
    }
}

