/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.indexer;

import com.ibm.es.nuvo.GlobalSystem;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.ConfigurationManager;
import com.ibm.es.nuvo.configuration.ConfigurationManagerException;
import com.ibm.es.nuvo.documentqueue.BaseDocument;
import com.ibm.es.nuvo.documentqueue.StreamedDocument;
import com.ibm.es.nuvo.indexer.DocumentIndexerListenerInterface;
import com.ibm.es.nuvo.indexer.Indexer;
import com.ibm.es.nuvo.indexer.IndexerException;
import com.ibm.es.nuvo.indexer.IndexerStateFSM;
import com.ibm.es.nuvo.indexer.ShutdownPendingException;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.manager.IndexThrottler;
import com.ibm.es.nuvo.util.XMLTagger;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentIndexer {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String StatusIndexerPoolElement = "indexer_pool";
    private static final String StatusIndexerElement = "indexer";
    private static final String StatusCollectionElement = "collection";
    private static final String StatusDocElement = "doc";
    private Hashtable<String, Indexer> indexers;
    private LinkedList<DocumentIndexerListenerInterface> listeners;
    private Object semaphore = new Object();
    private int limit;
    private volatile boolean shutdownPending;
    private boolean isConcurrent = false;

    public DocumentIndexer(int numberOfIndexers, boolean concurrent) {
        this.indexers = new Hashtable(numberOfIndexers);
        this.limit = numberOfIndexers;
        this.listeners = new LinkedList();
        this.shutdownPending = false;
        this.isConcurrent = concurrent;
    }

    public void setConcurrent(boolean concurrent) {
        this.isConcurrent = concurrent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<String> getActiveCollections() {
        Vector<String> activeCollections = new Vector<String>();
        Object object = this.semaphore;
        synchronized (object) {
            Enumeration<String> keyEnumerator = this.indexers.keys();
            while (keyEnumerator.hasMoreElements()) {
                activeCollections.add(keyEnumerator.nextElement());
            }
        }
        return activeCollections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAnchorText(String collectionId, int time, TimeUnit timeUnit) throws ConfigurationManagerException, IndexerException, ShutdownPendingException {
        if (this.shutdownPending) {
            throw new ShutdownPendingException(new Message("I0011E.CANNOT_PROCESS_DOCUMENT_SHUTDOWN_PENDING"), null);
        }
        Indexer indexer = null;
        Object object = this.semaphore;
        synchronized (object) {
            indexer = this.findAvailableIndexer(collectionId, IndexerStateFSM.IndexerState.AnchorText);
        }
        try {
            indexer.doAnchorTextUpdates(time, timeUnit);
        }
        finally {
            object = this.semaphore;
            synchronized (object) {
                this.makeAvailableIndexer(indexer);
                this.semaphore.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processIndexRebuild(String collectionId, int time, TimeUnit timeUnit) throws ConfigurationManagerException, IndexerException, ShutdownPendingException {
        if (this.shutdownPending) {
            throw new ShutdownPendingException(new Message("I0011E.CANNOT_PROCESS_DOCUMENT_SHUTDOWN_PENDING"), null);
        }
        Indexer indexer = null;
        Object object = this.semaphore;
        synchronized (object) {
            indexer = this.findAvailableIndexer(collectionId, IndexerStateFSM.IndexerState.Rebuild);
        }
        try {
            indexer.doIndexRebuild(time, timeUnit);
        }
        finally {
            object = this.semaphore;
            synchronized (object) {
                this.makeAvailableIndexer(indexer);
                this.semaphore.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initiateIndexRebuild(String collectionId) throws ShutdownPendingException, ConfigurationManagerException, IndexerException {
        if (this.shutdownPending) {
            throw new ShutdownPendingException(new Message("I0011E.CANNOT_PROCESS_DOCUMENT_SHUTDOWN_PENDING"), null);
        }
        Indexer indexer = null;
        Object object = this.semaphore;
        synchronized (object) {
            indexer = this.findAvailableIndexer(collectionId, IndexerStateFSM.IndexerState.Rebuild);
        }
        try {
            indexer.initiateIndexRebuild();
        }
        finally {
            object = this.semaphore;
            synchronized (object) {
                this.makeAvailableIndexer(indexer);
                this.semaphore.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDocuments(String collectionId, LinkedList<BaseDocument> documentList) throws ConfigurationManagerException, IndexerException, ShutdownPendingException {
        if (this.shutdownPending) {
            throw new ShutdownPendingException(new Message("I0011E.CANNOT_PROCESS_DOCUMENT_SHUTDOWN_PENDING"), null);
        }
        long batchStartTime = System.currentTimeMillis();
        Indexer indexer = null;
        CollectionConfiguration config = null;
        Object object = this.semaphore;
        synchronized (object) {
            try {
                indexer = this.findAvailableIndexer(collectionId, IndexerStateFSM.IndexerState.Text);
                config = ConfigurationManager.getConfigurationManager().getCollection(collectionId);
            }
            catch (ConfigurationManagerException e) {
                this.semaphore.notify();
                throw e;
            }
            catch (IndexerException e) {
                this.semaphore.notify();
                throw e;
            }
        }
        long throttle = 0L;
        long sleepTime = 0L;
        IndexThrottler throttler = GlobalSystem.getSingleInstance().getIndexThrottler();
        long multiplier = config.getIndexThrottleMultiplier();
        if (throttler != null && multiplier != 0L) {
            throttle = throttler.getThrottle();
            sleepTime = multiplier * throttle;
        }
        ListIterator<BaseDocument> iterator = documentList.listIterator(0);
        try {
            while (iterator.hasNext()) {
                indexer.processDocument(iterator.next());
                if (sleepTime == 0L) continue;
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e) {}
            }
        }
        finally {
            Object document;
            while (iterator.hasNext()) {
                document = iterator.next();
                if (!(document instanceof StreamedDocument)) continue;
                ((StreamedDocument)document).dispose();
            }
            document = this.semaphore;
            synchronized (document) {
                this.makeAvailableIndexer(indexer);
                this.semaphore.notify();
            }
        }
        long batchEndTime = System.currentTimeMillis();
        if (System.getProperty("debugIndexTime") != null) {
            System.out.println("Document batch of " + documentList.size() + " took " + (batchEndTime - batchStartTime) / 1000L + " seconds");
        }
    }

    public void processDocument(String collectionId, BaseDocument document) throws ConfigurationManagerException, IndexerException {
        this.processDocument(collectionId, document, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDocument(String collectionId, BaseDocument document, boolean throwException) throws ConfigurationManagerException, IndexerException {
        Indexer indexer = null;
        Object object = this.semaphore;
        synchronized (object) {
            indexer = this.findAvailableIndexer(collectionId, IndexerStateFSM.IndexerState.Text);
        }
        try {
            indexer.processDocument(document, throwException);
        }
        finally {
            object = this.semaphore;
            synchronized (object) {
                this.makeAvailableIndexer(indexer);
                this.semaphore.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sweepIndex(int sweepCount) {
        Object object = this.semaphore;
        synchronized (object) {
            Enumeration<String> keyEnumerator = this.indexers.keys();
            while (keyEnumerator.hasMoreElements()) {
                String collectionKey = keyEnumerator.nextElement();
                Indexer indexer = this.indexers.get(collectionKey);
                if (sweepCount == 0 && indexer.getUseCount() == 0) {
                    this.freeIndexer(indexer);
                    continue;
                }
                if (indexer.incrementSweepCount() <= sweepCount) continue;
                this.quiesceIndexer(indexer);
            }
        }
    }

    public synchronized void shutdown() throws InterruptedException {
        this.shutdown(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown(boolean force) throws InterruptedException {
        this.shutdownPending = true;
        boolean terminate = false;
        if (!force) {
            do {
                this.sweepIndex(0);
                Object object = this.semaphore;
                synchronized (object) {
                    if (this.indexers.size() > 0) {
                        this.semaphore.wait();
                    }
                    terminate = this.indexers.size() <= 0;
                }
            } while (!terminate);
        } else {
            this.sweepIndex(0);
            Object object = this.semaphore;
            synchronized (object) {
                Enumeration<String> keyEnumerator = this.indexers.keys();
                while (keyEnumerator.hasMoreElements()) {
                    String collectionKey = keyEnumerator.nextElement();
                    Indexer indexer = this.indexers.get(collectionKey);
                    try {
                        indexer.shutdown();
                    }
                    catch (IOException e) {}
                }
            }
        }
        this.indexers = new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quiesceCollection(String collectionId) {
        Object object = this.semaphore;
        synchronized (object) {
            Indexer indexer = this.indexers.get(collectionId);
            if (indexer != null) {
                this.quiesceIndexer(indexer);
            } else {
                this.notifyListenerIndexQuiesced(collectionId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeIndexer(String collectionId) {
        Object object = this.semaphore;
        synchronized (object) {
            Indexer indexer = this.indexers.get(collectionId);
            if (indexer != null) {
                if (indexer.getUseCount() == 0) {
                    this.freeIndexer(indexer);
                    return true;
                }
                return false;
            }
            this.notifyListenerIndexClosed(collectionId);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(DocumentIndexerListenerInterface listener) {
        LinkedList<DocumentIndexerListenerInterface> linkedList = this.listeners;
        synchronized (linkedList) {
            this.listeners.add(listener);
            Enumeration<String> keyEnumerator = this.indexers.keys();
            while (keyEnumerator.hasMoreElements()) {
                String collectionKey = keyEnumerator.nextElement();
                Indexer indexer = this.indexers.get(collectionKey);
                indexer.addListener(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(DocumentIndexerListenerInterface listener) {
        Cloneable cloneable = this.listeners;
        synchronized (cloneable) {
            this.listeners.remove(listener);
        }
        cloneable = this.indexers;
        synchronized (cloneable) {
            Enumeration<String> keyEnumerator = this.indexers.keys();
            while (keyEnumerator.hasMoreElements()) {
                String collectionKey = keyEnumerator.nextElement();
                Indexer indexer = this.indexers.get(collectionKey);
                indexer.removeListener(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getStatus(XMLTagger tagger) {
        tagger.startElement(StatusIndexerPoolElement);
        Object object = this.semaphore;
        synchronized (object) {
            Enumeration<String> keyEnumerator = this.indexers.keys();
            while (keyEnumerator.hasMoreElements()) {
                StringBuilder buf = new StringBuilder(300);
                String collectionId = keyEnumerator.nextElement();
                this.indexers.get(collectionId).getStatus(buf);
                tagger.startElement(StatusIndexerElement);
                tagger.startElement(StatusCollectionElement);
                tagger.writeText(collectionId);
                tagger.endElement(StatusCollectionElement);
                tagger.startElement(StatusDocElement);
                tagger.writeText(buf.toString());
                tagger.endElement(StatusDocElement);
                tagger.endElement(StatusIndexerElement);
            }
        }
        tagger.endElement(StatusIndexerPoolElement);
    }

    private void makeAvailableIndexer(Indexer indexer) {
        indexer.decUseCount();
        if (indexer.getUseCount() == 0) {
            indexer.setState(IndexerStateFSM.IndexerState.Idle);
            if (indexer.getQuiesceOnClose()) {
                this.freeIndexer(indexer);
            }
        }
    }

    private void reserveIndexer(Indexer indexer) {
        indexer.incUseCount();
    }

    private void quiesceIndexer(Indexer indexer) {
        if (indexer.getUseCount() == 0) {
            this.freeIndexer(indexer);
            this.notifyListenerIndexQuiesced(indexer.getCollectionConfiguration().getId());
        } else {
            indexer.setQuiesceOnClose();
            this.notifyListenerIndexQuiesced(indexer.getCollectionConfiguration().getId());
        }
    }

    private void freeIndexer(Indexer indexer) {
        block2: {
            String collectionId = null;
            try {
                collectionId = indexer.getCollectionConfiguration().getId();
                indexer.close();
                this.indexers.remove(indexer.getCollectionConfiguration().getId());
                this.notifyListenerIndexClosed(collectionId);
            }
            catch (IndexerException e) {
                if (!Loggers.logger.isLoggable(Level.SEVERE)) break block2;
                IndexerException indexerException = new IndexerException(new Message("I0013E.CANNOT_CLOSE_INDEX", indexer.getCollectionConfiguration().getId()), (Throwable)e);
                Loggers.logger.log(indexerException);
            }
        }
    }

    private Indexer findAvailableIndexer(String collectionId, IndexerStateFSM.IndexerState state) throws ConfigurationManagerException, IndexerException {
        Indexer indexer = null;
        do {
            if ((indexer = this.findAvailableIndexerHelper(collectionId, state)) != null) continue;
            try {
                this.semaphore.wait();
            }
            catch (InterruptedException e) {
                IndexerException indexerException = new IndexerException(new Message("I0014E.CANNOT_PROCESSS_DOCUMENTS", collectionId), (Throwable)e);
                throw indexerException;
            }
        } while (indexer == null);
        return indexer;
    }

    private Indexer findAvailableIndexerHelper(String collectionId, IndexerStateFSM.IndexerState state) throws ConfigurationManagerException, IndexerException {
        Indexer indexer = this.indexers.get(collectionId);
        if (indexer != null) {
            if (!this.isConcurrent) {
                if (indexer.getUseCount() == 0) {
                    if (indexer.setState(state)) {
                        indexer.incUseCount();
                        return indexer;
                    }
                    return null;
                }
                return null;
            }
            if (indexer.setState(state)) {
                indexer.incUseCount();
                return indexer;
            }
            return null;
        }
        Enumeration<String> keyEnumerator = this.indexers.keys();
        while (keyEnumerator.hasMoreElements()) {
            String collectionKey = keyEnumerator.nextElement();
            indexer = this.indexers.get(collectionKey);
            if (indexer.getUseCount() != 0) continue;
            return this.replaceIndexer(collectionKey, collectionId);
        }
        if (this.indexers.size() < this.limit) {
            return this.getNewIndexer(collectionId);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Indexer getNewIndexer(String collectionId) throws ConfigurationManagerException, IndexerException {
        Indexer indexer = null;
        indexer = Indexer.getIndexer(collectionId);
        this.indexers.put(collectionId, indexer);
        this.reserveIndexer(indexer);
        LinkedList<DocumentIndexerListenerInterface> linkedList = this.listeners;
        synchronized (linkedList) {
            ListIterator iterator = this.listeners.listIterator();
            while (iterator.hasNext()) {
                indexer.addListener((DocumentIndexerListenerInterface)iterator.next());
            }
        }
        this.notifyListenerIndexOpened(indexer.getCollectionConfiguration().getId());
        return indexer;
    }

    private Indexer replaceIndexer(String oldCollectionId, String newCollectionId) throws IndexerException, ConfigurationManagerException {
        this.freeIndexer(this.indexers.get(oldCollectionId));
        return this.getNewIndexer(newCollectionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenerIndexOpened(String collectionId) {
        LinkedList<DocumentIndexerListenerInterface> linkedList = this.listeners;
        synchronized (linkedList) {
            ListIterator iterator = this.listeners.listIterator();
            while (iterator.hasNext()) {
                ((DocumentIndexerListenerInterface)iterator.next()).indexOpened(collectionId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenerIndexClosed(String collectionId) {
        LinkedList<DocumentIndexerListenerInterface> linkedList = this.listeners;
        synchronized (linkedList) {
            ListIterator iterator = this.listeners.listIterator();
            while (iterator.hasNext()) {
                ((DocumentIndexerListenerInterface)iterator.next()).indexClosed(collectionId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenerIndexQuiesced(String collectionId) {
        LinkedList<DocumentIndexerListenerInterface> linkedList = this.listeners;
        synchronized (linkedList) {
            ListIterator iterator = this.listeners.listIterator();
            while (iterator.hasNext()) {
                ((DocumentIndexerListenerInterface)iterator.next()).indexQuiesced(collectionId);
            }
        }
    }
}

