/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.httplistener;

import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.util.parser.ParseException;
import com.ibm.es.nuvo.util.stream.StreamGobbler;
import java.io.File;
import java.io.IOException;
import java.util.Vector;

public class KeystoreManager {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String KeytoolWindows = "keytool.exe";
    private static final String KeytoolUnix = "keytool";

    public static boolean generateKeystoreFile(File keystoreFile, String hostname, String httpsKeyPassword, String httpsKeystorePassword) throws IOException {
        if (keystoreFile.isFile()) {
            return false;
        }
        GlobalConfiguration config = GlobalConfiguration.getConfiguration();
        String javaHome = GlobalConfiguration.getConfiguration().getJavaHome();
        String keytoolExecutable = config.isWindows() ? KeytoolWindows : KeytoolUnix;
        String keytoolPath = javaHome + File.separator + "bin" + File.separator + keytoolExecutable;
        Vector<String> execAndParam = new Vector<String>();
        execAndParam.add(keytoolPath);
        execAndParam.add("-genkey");
        execAndParam.add("-keystore");
        execAndParam.add(keystoreFile.getAbsolutePath());
        execAndParam.add("-alias");
        execAndParam.add("jetty");
        execAndParam.add("-keyalg");
        execAndParam.add("RSA");
        execAndParam.add("-dname");
        hostname = hostname.replaceAll(",", "\\,");
        execAndParam.add("CN=" + hostname);
        execAndParam.add("-keypass");
        execAndParam.add(httpsKeyPassword);
        execAndParam.add("-storepass");
        execAndParam.add(httpsKeystorePassword);
        String[] execAndParamArray = new String[execAndParam.size()];
        execAndParamArray = execAndParam.toArray(execAndParamArray);
        Runtime.getRuntime().exec(execAndParamArray);
        Process proc = Runtime.getRuntime().exec(execAndParamArray);
        StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), "ERROR", System.err);
        StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), "OUTPUT");
        errorGobbler.start();
        outputGobbler.start();
        int exitValue = 0;
        try {
            exitValue = proc.waitFor();
        }
        catch (InterruptedException e) {
            exitValue = 0;
        }
        if (0 != exitValue) {
            return false;
        }
        return keystoreFile.isFile();
    }

    public static void main(String[] args) {
        if (args.length < 5) {
            System.out.println("KeystoreManager config.xml keystorePath hostname key.password keystore.password");
            return;
        }
        try {
            GlobalConfiguration.initialize(args[0]);
            File keystoreFile = new File(args[1]);
            String hostname = args[2];
            String httpsKeyPassword = args[3];
            String httpsKeystorePassword = args[4];
            boolean generated = KeystoreManager.generateKeystoreFile(keystoreFile, hostname, httpsKeyPassword, httpsKeystorePassword);
            if (!generated) {
                System.err.println("Failed to generate keystore, make sure file does not exist already");
                return;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }
}

