/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.httplistener;

import com.ibm.es.nuvo.httplistener.ContextType;
import java.io.File;
import java.io.IOException;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpListener;
import org.mortbay.http.SocketListener;
import org.mortbay.http.ibmjsse.IbmJsseListener;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.WebApplicationContext;

public class HttpListenerServer {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final long serialVersionUID = -8906226645629144410L;
    Server adminServer = null;
    Server searchServer = null;

    public HttpListenerServer(String adminJettyFileName, String searchJettyFileName) throws IOException {
        this.createConfigureServers(adminJettyFileName, searchJettyFileName);
    }

    private void createConfigureServers(String adminJettyFileName, String searchJettyFileName) throws IOException {
        File jettyXml = new File(adminJettyFileName);
        this.adminServer = new Server(jettyXml.getAbsolutePath());
        File jettySearchXml = new File(searchJettyFileName);
        if (jettySearchXml.isFile()) {
            this.searchServer = new Server(jettySearchXml.getAbsolutePath());
        }
        this.initializeContextPaths(this.adminServer);
        this.initializeContextPaths(this.searchServer);
    }

    private void initializeContextPaths(Server server) {
        HttpContext[] contexts;
        if (null == server) {
            return;
        }
        for (HttpContext context : contexts = server.getContexts()) {
            String resourcePath = null;
            if (context instanceof WebApplicationContext) {
                WebApplicationContext webAppContext = (WebApplicationContext)context;
                resourcePath = webAppContext.getWAR();
            } else {
                resourcePath = context.getResourceBase();
            }
            ContextType.initContextPaths(resourcePath, context.getContextPath());
        }
    }

    public int getAdminHttpPort() {
        return this.getPortFrom(this.adminServer, false);
    }

    public int getAdminHttpsPort() {
        return this.getPortFrom(this.adminServer, true);
    }

    public int getSearchHttpPort() {
        Server s = this.searchServer;
        if (s == null) {
            s = this.adminServer;
        }
        return this.getPortFrom(s, false);
    }

    public int getSearchHttpsPort() {
        Server s = this.searchServer;
        if (s == null) {
            s = this.adminServer;
        }
        return this.getPortFrom(s, true);
    }

    public void start() throws Exception {
        this.adminServer.start();
        if (null != this.searchServer) {
            this.searchServer.start();
        }
    }

    public void stop() throws Exception {
        this.adminServer.stop();
        if (null != this.searchServer) {
            this.searchServer.stop();
        }
    }

    public String getHostName() {
        String hostname = null;
        HttpListener[] listeners = this.adminServer.getListeners();
        for (int i = 0; i < listeners.length && hostname == null; ++i) {
            if (!(listeners[i] instanceof SocketListener) || (hostname = listeners[i].getHost()) == null || hostname.length() <= 0 || !hostname.equals("0.0.0.0")) continue;
            hostname = null;
        }
        if (hostname == null) {
            hostname = "localhost";
        }
        return hostname;
    }

    public String getSearchAppURL() {
        return this.getSearchAppURL(this.getHostName());
    }

    public String getSearchAppURL(String hostName) {
        if (hostName == null) {
            hostName = this.getHostName();
        }
        StringBuilder builder = new StringBuilder();
        builder.append("http");
        int port = this.getSearchHttpPort();
        if (port == 0) {
            port = this.getSearchHttpsPort();
            if (0 == port) {
                return "";
            }
            builder.append('s');
        }
        builder.append("://");
        builder.append(hostName);
        builder.append(':');
        builder.append(port);
        return builder.toString();
    }

    public String getAdminAppURL() {
        String hostName = this.getHostName();
        StringBuilder builder = new StringBuilder();
        builder.append("http");
        int port = this.getAdminHttpPort();
        if (port == 0) {
            port = this.getAdminHttpsPort();
            builder.append('s');
        }
        builder.append("://");
        builder.append(hostName);
        builder.append(':');
        builder.append(port);
        return builder.toString();
    }

    private int getPortFrom(Server s, boolean httpsPort) {
        int port = 0;
        if (s != null) {
            HttpListener[] listeners;
            for (HttpListener listener : listeners = s.getListeners()) {
                if (httpsPort && listener instanceof IbmJsseListener) {
                    port = listener.getPort();
                    break;
                }
                if (httpsPort || !(listener instanceof SocketListener) || listener instanceof IbmJsseListener) continue;
                port = listener.getPort();
                break;
            }
        }
        return port;
    }
}

