/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.httplistener;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.httplistener.HttpListenerFactory;
import com.ibm.es.nuvo.httplistener.HttpListenerServer;
import com.ibm.es.nuvo.logging.Loggers;
import java.net.BindException;
import java.util.List;
import java.util.logging.Level;
import org.mortbay.util.MultiException;

public class HttpListenerManager {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static HttpListenerServer httpListenerServer = null;

    public static HttpListenerServer getSingleInstanceListenerServer() {
        return httpListenerServer;
    }

    public static void startupHttpListener() throws ExtendedException {
        try {
            Message msg;
            if (Loggers.tracer.isLoggable(Level.FINE)) {
                msg = new Message("G0002I.TRACE_MESSAGE");
                msg.addArgument("Attempting to start HTTP server");
                Loggers.tracer.log(Level.FINE, msg);
            }
            httpListenerServer = HttpListenerFactory.createAndConfigureListenerServer();
            httpListenerServer.start();
            if (Loggers.tracer.isLoggable(Level.FINE)) {
                msg = new Message("G0002I.TRACE_MESSAGE");
                msg.addArgument("HTTP Server started on ports (admin http/s, search http/s): " + httpListenerServer.getAdminHttpPort() + " " + httpListenerServer.getAdminHttpsPort() + " " + httpListenerServer.getSearchHttpPort() + " " + httpListenerServer.getSearchHttpsPort());
                Loggers.tracer.log(Level.FINE, msg);
            }
        }
        catch (MultiException e2) {
            Message msg = null;
            List nestedExceptions = e2.getExceptions();
            BindException bindError = null;
            for (int i = 0; i < nestedExceptions.size() && bindError == null; ++i) {
                Exception e = (Exception)nestedExceptions.get(i);
                if (e == null || !(e instanceof BindException)) continue;
                bindError = (BindException)e;
            }
            if (bindError != null) {
                String jettyConfigFile = GlobalConfiguration.getConfiguration().getJettyConfigFilePath();
                msg = new Message("G0115E.JETTY_PORT_USED", httpListenerServer.getAdminHttpPort(), jettyConfigFile);
            } else {
                msg = new Message("G0018E.HTTP_START_ERROR");
            }
            ExtendedException ee = new ExtendedException(msg, (Throwable)e2);
            Loggers.logger.log(ee);
            throw ee;
        }
        catch (Exception e) {
            Message msg = new Message("G0018E.HTTP_START_ERROR");
            ExtendedException ee = new ExtendedException(msg, (Throwable)e);
            Loggers.logger.log(ee);
            throw ee;
        }
    }

    public static void stopHttpListener() {
        block5: {
            try {
                Message msg;
                if (Loggers.tracer.isLoggable(Level.FINE)) {
                    msg = new Message("G0002I.TRACE_MESSAGE");
                    msg.addArgument("Attempting to stop HTTP listener");
                    Loggers.tracer.log(Level.FINE, msg);
                }
                if (httpListenerServer != null) {
                    httpListenerServer.stop();
                    httpListenerServer = null;
                    msg = new Message("G0021I.HTTP_SERVER_STOPPED");
                    System.out.println(msg.getFormattedTextWithDisplayKey());
                    if (Loggers.logger.isLoggable(Level.INFO)) {
                        Loggers.logger.log(Level.INFO, msg.getKey());
                    }
                }
            }
            catch (Exception e) {
                if (!Loggers.logger.isLoggable(Level.INFO)) break block5;
                Message msg = new Message("G0022I.HTTP_STOP_ERROR");
                ExtendedException ee = new ExtendedException(msg, (Throwable)e);
                Loggers.logger.log(Level.INFO, ee);
            }
        }
    }
}

