/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.httplistener;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.common.ReleaseInfo;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.httplistener.KeystoreManager;
import com.ibm.es.nuvo.util.CommandLineArguments;
import com.ibm.es.nuvo.util.Encryption;
import com.ibm.es.nuvo.util.FileUtils;
import com.ibm.es.nuvo.util.HostNameUtils;
import com.ibm.es.nuvo.util.XMLDOMUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.SocketException;
import java.util.Locale;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HttpListenerConfigurationTool {
    private static final String HttpListenerConfigToolRequiredParams = "HttpListenerConfigToolRequiredParams";
    private static final String HttpListenerConfigToolUsageKey = "HttpListenerConfigToolUsageKey";
    private static final String[] TargetJettyFiles = new String[]{"jetty.xml", "jetty_search.xml"};

    public static void main(String[] args) {
        String[] jettyFiles;
        Integer searchHttpsPort;
        Integer searchHttpPort;
        String missingParam;
        CommandLineArguments cmdArgs = new CommandLineArguments(args);
        String configXMLPath = cmdArgs.getParam(Params.globalConfig.toString());
        if (null == configXMLPath) {
            Message msg = new Message("G0008E.MISSING_ARGUMENT", Params.globalConfig.toString());
            System.err.println(msg.getFormattedTextWithDisplayKey());
            HttpListenerConfigurationTool.printUsage(System.err);
            System.exit(-1);
        }
        File globalConfigFile = new File(configXMLPath);
        HttpListenerConfigurationTool.initialize(globalConfigFile);
        String configPath = GlobalConfiguration.getConfiguration().getConfigPath();
        ReleaseInfo releaseInfo = ReleaseInfo.getReleaseInfo();
        String releaseRequiredParam = releaseInfo.getValue("System", HttpListenerConfigToolRequiredParams);
        String[] requiredParams = releaseRequiredParam.split("/");
        boolean errorFound = false;
        if (cmdArgs.getParamsCount() != requiredParams.length) {
            Message msg = new Message("G0011E.ARGUMENT_COUNT_DOES_NOT_MATCH", cmdArgs.getParamsCount(), requiredParams.length);
            System.err.println(msg.getFormattedTextWithDisplayKey());
            errorFound = true;
        }
        if ((missingParam = cmdArgs.getMissingRequiredParam(requiredParams)) != null) {
            Message msg = new Message("G0008E.MISSING_ARGUMENT", missingParam);
            System.err.println(msg.getFormattedTextWithDisplayKey());
            errorFound = true;
        }
        if (errorFound) {
            HttpListenerConfigurationTool.printUsage(System.err);
            System.exit(-1);
        }
        String hostName = cmdArgs.getParam(Params.hostName.toString()).trim();
        Integer adminHttpPort = HttpListenerConfigurationTool.getIntParam(Params.adminHttp.toString(), cmdArgs);
        Integer adminHttpsPort = HttpListenerConfigurationTool.getIntParam(Params.adminHttps.toString(), cmdArgs);
        if (null == adminHttpsPort) {
            adminHttpsPort = 0;
        }
        if (null == (searchHttpPort = HttpListenerConfigurationTool.getIntParam(Params.searchHttp.toString(), cmdArgs))) {
            searchHttpPort = adminHttpPort;
        }
        if (null == (searchHttpsPort = HttpListenerConfigurationTool.getIntParam(Params.searchHttps.toString(), cmdArgs))) {
            searchHttpsPort = 0;
        }
        if (null == (jettyFiles = HttpListenerConfigurationTool.getJettyFilesForPorts(adminHttpPort, adminHttpsPort, searchHttpPort, searchHttpsPort)) || jettyFiles.length == 0) {
            Message msg = new Message("G0014E.HTTP_LISTENER_CONFIG_INVALID_PORT_CONFIGURATION", adminHttpPort, adminHttpsPort, searchHttpPort, searchHttpsPort);
            System.err.println(msg.getFormattedTextWithDisplayKey());
            System.exit(-1);
        }
        String password = null;
        if (adminHttpsPort != 0 || searchHttpsPort != 0) {
            String certificateHostName = hostName;
            if (hostName.equals("0.0.0.0")) {
                try {
                    certificateHostName = HostNameUtils.getLocalHostFQDN();
                }
                catch (SocketException e) {
                    certificateHostName = "localhost";
                }
            }
            password = HttpListenerConfigurationTool.generateKeyStore(configPath, certificateHostName);
        }
        HttpListenerConfigurationTool.getJettyXmlAndCopyIntoConfig(configPath, jettyFiles);
        HttpListenerConfigurationTool.overrideHostNamePort(new File(configPath, "jetty.xml"), hostName, adminHttpPort, adminHttpsPort, password);
        HttpListenerConfigurationTool.overrideHostNamePort(new File(configPath, "jetty_search.xml"), hostName, searchHttpPort, searchHttpsPort, password);
    }

    private static Integer getIntParam(String parameter, CommandLineArguments cmdArgs) {
        if (cmdArgs.doesParamExist(parameter)) {
            return Integer.parseInt(cmdArgs.getParam(parameter));
        }
        return null;
    }

    private static void initialize(File globalConfigFile) {
        try {
            GlobalConfiguration.initialize(globalConfigFile.getAbsolutePath());
        }
        catch (Exception e) {
            Message msg = new Message("G0026E.CONFIG_FILE_ERROR");
            msg.addArgument(globalConfigFile.getAbsolutePath());
            ExtendedException ee = new ExtendedException(msg, (Throwable)e);
            System.err.println(ee.getFormattedText(Locale.getDefault(), true));
            System.exit(-2);
        }
        try {
            ReleaseInfo.initialize(null);
        }
        catch (ExtendedException e) {
            String configPath = GlobalConfiguration.getConfiguration().getConfigPath();
            File releaseFile = new File(configPath + File.separator + "releaseinfo", "release.properties");
            Message msg = new Message("G0026E.CONFIG_FILE_ERROR");
            msg.addArgument(releaseFile.getAbsolutePath());
            ExtendedException ee = new ExtendedException(msg, (Throwable)e);
            System.err.println(ee.getFormattedText(Locale.getDefault(), true));
            System.exit(-2);
        }
    }

    private static void overrideHostNamePort(File file, String hostNameToOverwrite, int httpPort, int httpsPort, String keystorePassword) {
        if (!file.isFile()) {
            return;
        }
        File replacedFile = new File(file.getAbsolutePath() + ".replaced.xml");
        if (null != hostNameToOverwrite) {
            // empty if block
        }
        String elementToOverwrite = null;
        try {
            Document doc = XMLDOMUtils.readAsNonValidatingDOM(new FileInputStream(file));
            if (httpsPort != 0) {
                elementToOverwrite = "/Configure/Call/Arg/New@class=org.mortbay.http.ibmjsse.IbmJsseListener/Set@name=Host";
                HttpListenerConfigurationTool.overwrite(doc, elementToOverwrite, hostNameToOverwrite);
                elementToOverwrite = "/Configure/Call/Arg/New@class=org.mortbay.http.ibmjsse.IbmJsseListener/Set@name=Port";
                HttpListenerConfigurationTool.overwrite(doc, elementToOverwrite, String.valueOf(httpsPort));
                elementToOverwrite = "/Configure/Call/Arg/New@class=org.mortbay.http.ibmjsse.IbmJsseListener/Set@name=Password";
                HttpListenerConfigurationTool.overwrite(doc, elementToOverwrite, keystorePassword);
                elementToOverwrite = "/Configure/Call/Arg/New@class=org.mortbay.http.ibmjsse.IbmJsseListener/Set@name=KeyPassword";
                HttpListenerConfigurationTool.overwrite(doc, elementToOverwrite, keystorePassword);
            }
            if (httpPort != 0) {
                elementToOverwrite = "/Configure/Call/Arg/New@class=org.mortbay.http.SocketListener/Set@name=Host";
                HttpListenerConfigurationTool.overwrite(doc, elementToOverwrite, hostNameToOverwrite);
                elementToOverwrite = "/Configure/Call/Arg/New@class=org.mortbay.http.SocketListener/Set@name=Port";
                HttpListenerConfigurationTool.overwrite(doc, elementToOverwrite, String.valueOf(httpPort));
                if (httpsPort != 0) {
                    elementToOverwrite = "/Configure/Call/Arg/New@class=org.mortbay.http.SocketListener/Set@name=ConfidentialPort";
                    HttpListenerConfigurationTool.overwrite(doc, elementToOverwrite, String.valueOf(httpsPort));
                }
            }
            XMLDOMUtils.writeDOM(doc, replacedFile);
            file.delete();
            replacedFile.renameTo(file);
        }
        catch (Exception e) {
            Message msg = new Message("G0012E.HTTP_LISTENER_CONFIG_TOOL_OVERWRITE_FAILED", elementToOverwrite, hostNameToOverwrite, file.getAbsolutePath());
            ExtendedException ee = new ExtendedException(msg, (Throwable)e);
            System.err.println(ee.getFormattedText(Locale.getDefault(), true));
            System.exit(-2);
        }
    }

    private static void overwrite(Document doc, String elementToOverwrite, String elementTextContentValue) {
        if (null == elementTextContentValue) {
            return;
        }
        Element matchedElement = XMLDOMUtils.getElement(elementToOverwrite, doc);
        if (null != matchedElement) {
            matchedElement.setTextContent(elementTextContentValue);
        }
    }

    private static void getJettyXmlAndCopyIntoConfig(String configPath, String[] jettyBaseNames) {
        HttpListenerConfigurationTool.backupExisting(configPath);
        int i = 0;
        for (String jettyBaseName : jettyBaseNames) {
            String jettyTargetFileName = TargetJettyFiles[i];
            String templateFilePath = GlobalConfiguration.getConfiguration().getConfigFileName("defaults" + File.separator + "jetty_templates", jettyBaseName);
            File templateFile = new File(templateFilePath);
            File jettyXmlFile = new File(configPath, jettyTargetFileName);
            if (jettyXmlFile.isFile()) {
                jettyXmlFile.delete();
            }
            try {
                FileUtils.copyFile(templateFile, jettyXmlFile);
            }
            catch (ExtendedException e) {
                Message msg = new Message("G0033E.FILE_COPY_ERROR", templateFile, jettyXmlFile);
                ExtendedException ee = new ExtendedException(msg, (Throwable)e);
                System.err.println(ee.getFormattedText());
                System.exit(-2);
            }
            ++i;
        }
    }

    private static void backupExisting(String configPath) {
        File backupJetty = new File(configPath, TargetJettyFiles[0] + ".bk");
        File backupJettySearch = new File(configPath, TargetJettyFiles[1] + ".bk");
        if (backupJettySearch.isFile()) {
            backupJettySearch.delete();
        }
        if (backupJetty.isFile()) {
            backupJetty.delete();
        }
        File originalJetty = new File(configPath, TargetJettyFiles[0]);
        File originalJettySearch = new File(configPath, TargetJettyFiles[1]);
        if (originalJetty.isFile()) {
            originalJetty.renameTo(backupJetty);
        }
        if (originalJettySearch.isFile()) {
            originalJettySearch.renameTo(backupJettySearch);
        }
    }

    private static String generateKeyStore(String configPath, String hostname) {
        String keyFile = configPath + File.separator + "key.txt";
        try {
            Encryption.loadDefaultKey(keyFile);
        }
        catch (Exception e2) {
            Message msg = new Message("G0107E.ENCRYPTION_KEY_LOAD_FAILED", keyFile);
            ExtendedException ee = new ExtendedException(msg, (Throwable)e2);
            System.err.println(ee.getFormattedText());
            System.exit(-2);
        }
        File keystoreFile = new File(configPath, "keystore");
        String httpsKeyPassword = null;
        try {
            boolean generated;
            String httpsKeystorePassword = httpsKeyPassword = Encryption.readKeyAsStringFromFile(keyFile);
            if (keystoreFile.isFile()) {
                keystoreFile.delete();
            }
            if (!(generated = KeystoreManager.generateKeystoreFile(keystoreFile, hostname, httpsKeyPassword, httpsKeystorePassword))) {
                Message msg = new Message("G0013E.KEYSTORE_GENERATION_FAILED", keyFile);
                System.err.println(msg.getFormattedTextWithDisplayKey());
                System.exit(-2);
            }
        }
        catch (IOException e) {
            Message msg = new Message("G0013E.KEYSTORE_GENERATION_FAILED", keyFile);
            ExtendedException ee = new ExtendedException(msg, (Throwable)e);
            System.err.println(ee.getFormattedText(Locale.getDefault(), true));
            System.exit(-2);
        }
        return httpsKeyPassword;
    }

    private static void printUsage(PrintStream printStream) {
        ReleaseInfo releaseInfo = ReleaseInfo.getReleaseInfo();
        String usageKey = releaseInfo.getValue("System", HttpListenerConfigToolUsageKey);
        Message msg = new Message(usageKey);
        printStream.println(msg.getFormattedText());
    }

    private static void overwriteHostname(String configPath, String hostName) {
        File configXmlFile = new File(configPath, "config.xml");
        File replacedFile = new File(configXmlFile.getAbsolutePath() + ".replaced.xml");
        String elementToOverwrite = "/config/hostName";
        try {
            Document doc = XMLDOMUtils.readAsNonValidatingDOM(configXmlFile);
            Element matchedElement = XMLDOMUtils.getElement("/config/hostName", doc);
            matchedElement.setTextContent(hostName);
            XMLDOMUtils.writeDOM(doc, replacedFile);
            configXmlFile.delete();
            boolean renamed = replacedFile.renameTo(configXmlFile);
            if (!renamed) {
                System.err.println("renamed failed");
                System.exit(-2);
            }
        }
        catch (Exception e) {
            Message msg = new Message("G0012E.HTTP_LISTENER_CONFIG_TOOL_OVERWRITE_FAILED", "/config/hostName", hostName, configXmlFile.getAbsolutePath());
            ExtendedException ee = new ExtendedException(msg, (Throwable)e);
            System.err.println(ee.getFormattedText(Locale.getDefault(), true));
            System.exit(-2);
        }
    }

    private static String[] getJettyFilesForPorts(int adminHttp, int adminHttps, int searchHttp, int searchHttps) {
        String[] retFiles = null;
        if (adminHttp == searchHttps || adminHttp == adminHttps || searchHttp == searchHttps || searchHttp == adminHttps) {
            return null;
        }
        if (0 == searchHttps && 0 == adminHttps) {
            if (adminHttp == searchHttp) {
                retFiles = new String[]{"jetty.xml"};
                return retFiles;
            }
            retFiles = new String[]{"jetty_admin.xml", "jetty_search.xml"};
            return retFiles;
        }
        if (0 == searchHttp && 0 == adminHttp) {
            if (adminHttp == searchHttp) {
                retFiles = new String[]{"jetty.ssl.xml"};
                return retFiles;
            }
            retFiles = new String[]{"jetty_admin.ssl.xml", "jetty_search.ssl.xml"};
            return retFiles;
        }
        if (0 != searchHttp && 0 != adminHttp && 0 != searchHttps && 0 != adminHttps) {
            if (adminHttps == searchHttps && adminHttp == searchHttp) {
                retFiles = new String[]{"jetty.both.xml"};
                return retFiles;
            }
            if (adminHttps != searchHttps && adminHttp != searchHttp) {
                retFiles = new String[]{"jetty_admin.both.xml", "jetty_search.both.xml"};
                return retFiles;
            }
        }
        return retFiles;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Params {
        globalConfig,
        adminHttp,
        adminHttps,
        searchHttp,
        searchHttps,
        hostName;

    }
}

