/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.httplistener;

import com.ibm.es.nuvo.configuration.GlobalConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ContextType {
    Supa("lib/whitney_supa.war", "/supa"),
    Search("lib/whitney_search.war", "/search"),
    SearchCustomizationImages("config/customization/images/", "/customization/images/*"),
    SearchCustomizationCss("config/customization/css", "/customization/css/"),
    Api("lib/whitney_api.war", "/api"),
    ApiSearch("lib/whitney_apisearch.war", "/api/search"),
    Admin("lib/whitney_admin.war", "/admin"),
    Inyo("lib/whitney_inyo.war", "/whitney/inyo"),
    ResourceDoc("resource/doc/", "/doc"),
    ResourceDojo("resource/dojo/", "/dojo"),
    ResourceStylesheets("resource/stylesheets/", "/stylesheet"),
    P2P_Communication("lib/whitney_p2p.war", "/p2p");

    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private final String resourcePath;
    private String contextPath = null;
    private boolean inited = false;

    private ContextType(String resourcePath, String contextPath) {
        this.resourcePath = resourcePath;
        this.contextPath = contextPath;
    }

    public String getInstallRelativeResourcePath() {
        return this.resourcePath;
    }

    public String getResourcePath(String installPath) {
        return installPath.replace('\\', '/') + "/" + this.resourcePath;
    }

    public String getResourcePath() {
        return GlobalConfiguration.getConfiguration().getInstallPath().replace('\\', '/') + "/" + this.resourcePath;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    private void setContextPath(String contextPath) {
        if (this.inited) {
            return;
        }
        this.inited = true;
        this.contextPath = contextPath;
    }

    public static synchronized boolean initContextPaths(String resourcePathIn, String contextPathIn) {
        if (null == resourcePathIn) {
            return false;
        }
        for (ContextType type : ContextType.values()) {
            if (type.inited || !resourcePathIn.endsWith(type.resourcePath)) continue;
            type.setContextPath(contextPathIn);
            return true;
        }
        return false;
    }
}

