/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.facet.taxi;

import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.facet.taxi.CategoryInfoTable;
import com.ibm.es.nuvo.facet.taxi.LabelToOrdinal;
import com.ibm.es.nuvo.facet.taxi.TaxonomyIndexerException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class Utils {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void updateMetaData(File taxonomyRoot, int nextGeneration) throws IOException {
        File metaInfo = new File(taxonomyRoot, "metainfo.ini");
        FileOutputStream fos = null;
        try {
            Properties meta = new Properties();
            meta.put("currentGen", Integer.toString(nextGeneration));
            fos = new FileOutputStream(metaInfo);
            meta.store(fos, "Generated file, do not edit. ");
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    static int readMetaDataFile(File taxonomyRoot) throws TaxonomyIndexerException {
        int curGen = 0;
        File metaInfo = new File(taxonomyRoot, "metainfo.ini");
        if (!metaInfo.exists()) {
            return curGen;
        }
        Properties meta = null;
        FileInputStream fis = null;
        try {
            meta = new Properties();
            fis = new FileInputStream(metaInfo);
            meta.load(fis);
        }
        catch (IOException ioe) {
            Message msg = new Message("I0024E.TAXONOMY_FILE_MISSING");
            msg.addArgument(metaInfo.getAbsolutePath());
            throw new TaxonomyIndexerException(msg);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
        String gen = meta.getProperty("currentGen");
        try {
            curGen = Integer.parseInt(gen);
        }
        catch (NumberFormatException nfe) {
            Message msg = new Message("I0027E.TAXONOMY_INTERNAL_ERROR");
            msg.addArgument("metaInfo file " + metaInfo.getAbsolutePath() + " contains invalid number for property: " + "currentGen" + ": " + nfe.toString());
            throw new TaxonomyIndexerException(msg);
        }
        return curGen;
    }

    static int addRootIfNeeded(CategoryInfoTable cit, LabelToOrdinal l2o, String taxonomyId) throws TaxonomyIndexerException {
        try {
            int root = 0;
            if (l2o.getOrdinal(taxonomyId) == -2) {
                if (l2o.getNextOrdinal() != 0) {
                    Message msg = new Message("I0025E.TAXONOMY_INDEX_META_CORRUPT");
                    msg.addArgument(l2o.getFileName());
                    msg.addArgument(l2o.getNextOrdinal());
                    msg.addArgument(0L);
                    throw new TaxonomyIndexerException(msg);
                }
                l2o.addLabel(taxonomyId, root);
                cit.writeEntry(root, -2, -1L);
            }
            return root;
        }
        catch (IOException ioe) {
            Message msg = new Message("I0027E.TAXONOMY_INTERNAL_ERROR");
            msg.addArgument("I/O error reading LabelToOrdinal: ");
            throw new TaxonomyIndexerException(msg, (Throwable)ioe);
        }
    }

    public static void copyFile(File fromDir, File toDir, String fileName, byte[] buf) throws TaxonomyIndexerException {
        File to = null;
        byte[] mybuf = buf;
        try {
            int len;
            File from;
            if (mybuf == null) {
                mybuf = new byte[4096];
            }
            if (!(from = new File(fromDir, fileName)).exists()) {
                Message msg = new Message("I0031E.TAXONOMY_COPY_FILE_MISSING");
                msg.addArgument(from.getAbsolutePath());
                throw new TaxonomyIndexerException(msg);
            }
            to = new File(toDir, fileName);
            FileInputStream fis = new FileInputStream(from);
            FileOutputStream fos = new FileOutputStream(to);
            while ((len = fis.read(mybuf)) > 0) {
                fos.write(mybuf, 0, len);
            }
            fos.close();
            fis.close();
        }
        catch (IOException ioe) {
            Message msg = new Message("I0030E.TAXONOMY_NEW_GENERATION");
            if (to != null) {
                msg.addArgument(to.getAbsolutePath());
            } else {
                msg.addArgument(fileName);
            }
            throw new TaxonomyIndexerException(msg, (Throwable)ioe);
        }
    }
}

