/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.facet.taxi;

import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.IndexDescriptor;
import com.ibm.es.nuvo.facet.CatId;
import com.ibm.es.nuvo.facet.CategoryAncestry;
import com.ibm.es.nuvo.facet.CategoryInfoImpl;
import com.ibm.es.nuvo.facet.OrdinalPath;
import com.ibm.es.nuvo.facet.taxi.CategoryInfoTable;
import com.ibm.es.nuvo.facet.taxi.Deleteable;
import com.ibm.es.nuvo.facet.taxi.FatherSonMapWriter;
import com.ibm.es.nuvo.facet.taxi.LabelToOrdinal;
import com.ibm.es.nuvo.facet.taxi.StringRepository;
import com.ibm.es.nuvo.facet.taxi.TaxonomyDebug;
import com.ibm.es.nuvo.facet.taxi.TaxonomyIndexerException;
import com.ibm.es.nuvo.facet.taxi.Utils;
import com.ibm.es.nuvo.indexer.IndexerException;
import com.ibm.es.nuvo.logging.Loggers;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.logging.Level;
import org.apache.lucene.store.FSDirectory;

public class TaxonomyIndexWriter {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final int DEFAULT_FLUSH_SIZE = 50000;
    private String delimiter = "\uf749";
    private File taxonomyRoot;
    private File taxonomyDir;
    private File newTaxonomyDir;
    private CategoryInfoTable cit;
    private LabelToOrdinal l2o;
    private StringRepository lr;
    private FatherSonMapWriter fsmWriter;
    private int flushNewCategories;
    private Object addLock;
    protected int root_ordinal;
    protected long root_id;
    private boolean fsmFlushed = false;
    protected long accumAddCategoryTime;
    private long internGetOrdTime;
    private int currentGeneration;
    private int nextGeneration = 0;
    private Thread deletableThread;
    long totalL2OTime;
    protected long startTime;
    private int totalAlreadyInIndex;
    private int totalAddCategoryCalls;
    private CollectionConfiguration configuration;
    private int debugLevel = 0;

    protected TaxonomyIndexWriter() {
    }

    public TaxonomyIndexWriter(CollectionConfiguration configuration) throws TaxonomyIndexerException {
        this(configuration, "\uf749");
    }

    public TaxonomyIndexWriter(CollectionConfiguration configuration, String delimiter) throws TaxonomyIndexerException {
        this.startTime = System.currentTimeMillis();
        IndexDescriptor taxiDescriptor = configuration.getIndexDescriptorFor(IndexDescriptor.IndexType.Facet);
        String debugStr = taxiDescriptor.getProperty("DebugLevel");
        if (debugStr != null) {
            try {
                this.debugLevel = Integer.parseInt(debugStr);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        String flushEveryNNewFacets = taxiDescriptor.getProperty("FlushTaxonomy");
        this.flushNewCategories = 50000;
        if (flushEveryNNewFacets != null) {
            this.flushNewCategories = Integer.parseInt(flushEveryNNewFacets);
        }
        try {
            String indexPath = configuration.getIndexPath(IndexDescriptor.IndexType.Facet);
            FSDirectory directory = FSDirectory.getDirectory((String)indexPath);
            this.taxonomyRoot = directory.getFile();
            this.delimiter = delimiter;
            this.configuration = configuration;
            this.addLock = new Object();
            this.openIndex();
        }
        catch (IOException ioe) {
            Message msg = new Message("I0004E.CANNOT_CREATE_INDEX");
            msg.addArgument(configuration.getId());
            throw new TaxonomyIndexerException(msg, (Throwable)ioe);
        }
    }

    private void openIndex() throws TaxonomyIndexerException {
        File metaInfo;
        boolean newTaxonomyIndex = true;
        if (this.taxonomyRoot.exists() && this.taxonomyRoot.isDirectory() && (metaInfo = new File(this.taxonomyRoot, "metainfo.ini")).exists()) {
            this.currentGeneration = Utils.readMetaDataFile(this.taxonomyRoot);
            newTaxonomyIndex = false;
        }
        this.newTaxonomyDir = new File(this.taxonomyRoot, Integer.toString(this.currentGeneration));
        if (newTaxonomyIndex) {
            this.newTaxonomyDir.mkdirs();
            this.taxonomyDir = null;
        } else {
            this.createNextGeneration();
        }
        this.cit = new CategoryInfoTable(this.newTaxonomyDir, false);
        this.l2o = new LabelToOrdinal(this.newTaxonomyDir, this.delimiter);
        this.lr = new StringRepository(this.newTaxonomyDir, false);
        this.fsmWriter = new FatherSonMapWriter(this.taxonomyDir, this.newTaxonomyDir, this.debugLevel);
        this.fsmFlushed = false;
        this.root_id = LabelToOrdinal.hash("facets");
        this.root_ordinal = Utils.addRootIfNeeded(this.cit, this.l2o, "facets");
        Deleteable del = new Deleteable(this.configuration, false);
        this.deletableThread = new Thread((Runnable)del, "Taxonomy Deletable Thread");
        this.deletableThread.start();
    }

    private void createNextGeneration() throws TaxonomyIndexerException {
        this.taxonomyDir = new File(this.taxonomyRoot, Integer.toString(this.currentGeneration));
        this.nextGeneration = this.currentGeneration + 1;
        this.newTaxonomyDir = new File(this.taxonomyRoot, Integer.toString(this.nextGeneration));
        if (this.newTaxonomyDir.exists() && this.newTaxonomyDir.isDirectory()) {
            File[] files = this.newTaxonomyDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                files[i].delete();
            }
        }
        this.newTaxonomyDir.mkdirs();
        this.copyAppendOnlyfiles();
    }

    private void copyAppendOnlyfiles() throws TaxonomyIndexerException {
        long start = System.currentTimeMillis();
        byte[] buf = new byte[4096];
        Utils.copyFile(this.taxonomyDir, this.newTaxonomyDir, "LabelToOrdinal", buf);
        Utils.copyFile(this.taxonomyDir, this.newTaxonomyDir, "LabelRepository", buf);
        Utils.copyFile(this.taxonomyDir, this.newTaxonomyDir, "CategoryInfoTable", buf);
    }

    public CatId getID(String label) throws IOException {
        System.out.println("getID label=" + label);
        long myHash = LabelToOrdinal.hash(label);
        int catOrdinal = this.l2o.getOrdinal(myHash);
        if (catOrdinal == -2) {
            throw new IOException("no category with label " + label + " in taxonomy");
        }
        return new CatId(myHash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addCategory(String categoryLabel) throws TaxonomyIndexerException {
        if (this.fsmFlushed) {
            Message msg = new Message("I0020E.CANNOT_ADD_CATEGORY");
            msg.addArgument("Index Closed");
            throw new TaxonomyIndexerException(msg);
        }
        if (categoryLabel == null) {
            Message msg = new Message("I0020E.CANNOT_ADD_CATEGORY");
            msg.addArgument("NULL category");
            throw new TaxonomyIndexerException(msg);
        }
        if (this.totalAddCategoryCalls - this.totalAlreadyInIndex > this.flushNewCategories) {
            Object msg = this.addLock;
            synchronized (msg) {
                System.out.println("close/openIndex ");
                this.close();
                this.totalAlreadyInIndex = 0;
                this.totalAddCategoryCalls = 0;
                this.openIndex();
            }
        }
        try {
            CategoryAncestry ca = this.internalAddCategory(categoryLabel);
            return ca.getOrdinal();
        }
        catch (TaxonomyIndexerException ioe) {
            ioe.printStackTrace();
            Message msg = new Message("I0020E.CANNOT_ADD_CATEGORY");
            msg.addArgument(categoryLabel);
            throw new TaxonomyIndexerException(msg, (Throwable)ioe);
        }
    }

    public CategoryAncestry addCategoryCA(String categoryLabel) throws TaxonomyIndexerException {
        if (categoryLabel == null) {
            Message msg = new Message("I0020E.CANNOT_ADD_CATEGORY");
            msg.addArgument("NULL category");
            throw new TaxonomyIndexerException(msg);
        }
        try {
            CategoryAncestry ca = this.internalAddCategory(categoryLabel);
            return ca;
        }
        catch (TaxonomyIndexerException ioe) {
            ioe.printStackTrace();
            Message msg = new Message("I0020E.CANNOT_ADD_CATEGORY");
            msg.addArgument(categoryLabel);
            throw new TaxonomyIndexerException(msg, (Throwable)ioe);
        }
    }

    public OrdinalPath getOrdinalPath(CategoryAncestry ca) throws TaxonomyIndexerException {
        return this.internalGetOrdinalPath(ca.getOrdinal(), ca.getAllAncestorsOrds());
    }

    private OrdinalPath internalGetOrdinalPath(int myOrdinal, int[] ancOrdinals) throws TaxonomyIndexerException, TaxonomyIndexerException {
        long start = System.currentTimeMillis();
        int len = 0;
        if (ancOrdinals != null) {
            len = ancOrdinals.length;
        }
        int[] allOrds = new int[len + 1];
        for (int i = 0; i < len; ++i) {
            allOrds[len - i - 1] = ancOrdinals[i];
        }
        allOrds[len] = myOrdinal;
        OrdinalPath ret = new OrdinalPath(allOrds);
        this.internGetOrdTime += System.currentTimeMillis() - start;
        return ret;
    }

    public void flush() throws TaxonomyIndexerException {
        if (this.fsmFlushed) {
            return;
        }
        try {
            this.fsmWriter.merge();
            this.l2o.flush();
            Utils.updateMetaData(this.taxonomyRoot, this.nextGeneration);
            this.fsmFlushed = true;
        }
        catch (IOException ioe) {
            Message msg = new Message("I0033E.TAXONOMY_CLOSE");
            msg.addArgument(ioe.toString());
            throw new TaxonomyIndexerException(msg, (Throwable)ioe);
        }
    }

    public void dumpStatistics(PrintStream ps) {
        ps.println("addCategory calls " + this.totalAddCategoryCalls);
        ps.println("Already in Index addCategory calls " + this.totalAlreadyInIndex);
        ps.println("Actual Adds to Taxonomy " + (this.totalAddCategoryCalls - this.totalAlreadyInIndex));
        if (this.accumAddCategoryTime > 0L) {
            ps.println("TaxonomyIndexWriter: Accumlated addCategory time " + this.accumAddCategoryTime + " millis");
        }
        if (this.internGetOrdTime > 0L) {
            ps.println("TaxonomyIndexWriter: Accumlated getOrdinalPath time  " + this.internGetOrdTime + " millis");
        }
        ps.println("L2O stats");
        ps.println("\tgetFileTime millis " + this.l2o.getFileTime());
        ps.println("\tgetOrdinalTime millis " + this.l2o.getOrdinalTime());
        ps.println("\tgetAddLabelTime millis " + this.l2o.getAddLabelTime());
        this.totalL2OTime = this.l2o.getOrdinalTime() + this.l2o.getAddLabelTime() + this.l2o.getFileTime();
        ps.println("\tTOTAL millis " + this.totalL2OTime);
        long end = System.currentTimeMillis();
        ps.println("FIXME Time to Merge FatherSonMap " + this.fsmWriter.getMergeTime() + " millis");
        end = System.currentTimeMillis();
        long elapsedTime = end - this.startTime;
        ps.println("Elapsed millis " + elapsedTime);
        long l2oTime = this.totalL2OTime;
        int percentL2O = (int)((double)l2oTime / (double)elapsedTime * 100.0);
        ps.println("percent Total Time in Label To Ordinal " + percentL2O + "%");
        int percentAddCategory = (int)((double)this.accumAddCategoryTime / (double)elapsedTime * 100.0);
        ps.println("percent Total Time in AddCategory " + percentAddCategory + "%");
        long mergeTime = this.fsmWriter.getMergeTime();
        int percentMerge = (int)((double)mergeTime / (double)elapsedTime * 100.0);
        ps.println("percent Total Time Merging FSM, update CIT " + percentMerge + "%");
    }

    public void close() throws TaxonomyIndexerException {
        try {
            if (!this.fsmFlushed) {
                this.flush();
            }
            this.cit.close();
            this.lr.close();
            this.fsmWriter.close();
        }
        catch (IOException ioe) {
            Message msg = new Message("I0033E.TAXONOMY_CLOSE");
            msg.addArgument(ioe.toString());
            throw new TaxonomyIndexerException(msg, (Throwable)ioe);
        }
        try {
            this.deletableThread.join();
        }
        catch (InterruptedException e) {
            System.out.println("deleteable thread failed to join " + e.toString());
            e.printStackTrace();
        }
        IndexDescriptor taxiDescriptor = this.configuration.getIndexDescriptorFor(IndexDescriptor.IndexType.Facet);
        String dumpTaxonomy = taxiDescriptor.getProperty("DumpTaxonomiesPerGeneration");
        if (dumpTaxonomy != null && Boolean.parseBoolean(dumpTaxonomy)) {
            TaxonomyDebug taxiDebug = new TaxonomyDebug(this.newTaxonomyDir, this.newTaxonomyDir.getAbsolutePath());
            taxiDebug.dump();
        }
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public CategoryInfoImpl getCategoryInfo(CatId ID) throws IOException {
        int ordinal = this.l2o.getOrdinal(ID.toLong());
        return this.getCategoryInfoByOrdinal(ordinal);
    }

    public OrdinalPath getOrdinalPath(CatId catId) throws TaxonomyIndexerException {
        boolean debug = false;
        if (debug) {
            System.out.println("getOrdinalPath catId=" + catId);
        }
        try {
            int catOrdinal = this.l2o.getOrdinal(catId.toLong());
            if (catOrdinal == 0) {
                return new OrdinalPath(0);
            }
            CategoryInfoImpl[] ancestors = this.internalGetAncestors(catOrdinal);
            int[] ancOrdinals = new int[ancestors.length];
            for (int i = 0; i < ancestors.length; ++i) {
                ancOrdinals[i] = this.l2o.getOrdinal(ancestors[i].getLabel());
            }
            return this.internalGetOrdinalPath(catOrdinal, ancOrdinals);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            Message msg = new Message("I0021E.CANNOT_GET_ORDINAL_PATH");
            msg.addArgument(catId.toString());
            throw new TaxonomyIndexerException(msg, (Throwable)ioe);
        }
    }

    public CategoryInfoImpl getCategoryInfoByOrdinal(int ordinal) throws IOException {
        long Id;
        String label;
        System.out.println("getCategoryInfoByOrdinal ordinal=" + ordinal);
        if (ordinal == 0) {
            label = new String("Facet Taxonomy Virtual Root");
            Id = this.root_id;
        } else {
            long pLabel = this.cit.getLabelLocation(ordinal);
            if (pLabel == -2L) {
                return null;
            }
            label = this.lr.getString(pLabel);
            if (label == null) {
                return null;
            }
            Id = LabelToOrdinal.hash(label);
        }
        CategoryInfoImpl ret = new CategoryInfoImpl(new CatId(Id), label);
        return ret;
    }

    private CategoryInfoImpl[] internalGetAncestors(int ordinal) throws IOException {
        String label;
        String currLabel = label = ordinal == 0 ? "facets" : this.lr.getString(this.cit.getLabelLocation(ordinal));
        ArrayList<CategoryInfoImpl> ancestors = new ArrayList<CategoryInfoImpl>();
        while ((currLabel = this.stripSon(currLabel)) != null) {
            CategoryInfoImpl ci = new CategoryInfoImpl(new CatId(LabelToOrdinal.hash(currLabel)), currLabel);
            ancestors.add(ci);
        }
        CategoryInfoImpl[] ancestorArray = new CategoryInfoImpl[ancestors.size()];
        for (int i = 0; i < ancestors.size(); ++i) {
            ancestorArray[i] = (CategoryInfoImpl)ancestors.get(i);
        }
        return ancestorArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CategoryAncestry internalAddCategory(String categoryLabel) throws TaxonomyIndexerException {
        if (this.debugLevel > 0) {
            System.out.println("internalAddCategory " + categoryLabel);
        }
        long start = System.currentTimeMillis();
        int catOrdinal = -2;
        if (categoryLabel == null) {
            return new CategoryAncestry(new CatId[0], new int[0], new CatId(this.root_id), this.root_ordinal);
        }
        ++this.totalAddCategoryCalls;
        catOrdinal = this.l2o.getOrdinal(categoryLabel);
        if (catOrdinal != -2) {
            CategoryAncestry ca = this.internalGetCategoryAncestry(catOrdinal, categoryLabel);
            this.accumAddCategoryTime += System.currentTimeMillis() - start;
            ++this.totalAlreadyInIndex;
            return ca;
        }
        CategoryAncestry me = null;
        CategoryAncestry myFather = null;
        String fatherLabel = this.stripSon(categoryLabel);
        myFather = this.internalAddCategory(fatherLabel);
        Object object = this.addLock;
        synchronized (object) {
            catOrdinal = this.l2o.getOrdinal(categoryLabel);
            if (catOrdinal != -2) {
                me = this.internalGetCategoryAncestry(catOrdinal, categoryLabel);
            } else {
                int myOrdinal = this.l2o.getNextOrdinal();
                try {
                    long pLabel = this.lr.addString(categoryLabel);
                    this.fsmWriter.add(myFather.getOrdinal(), myOrdinal, pLabel);
                    this.cit.writeEntry(myOrdinal, myFather.getOrdinal(), pLabel);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    Message msg = new Message("I0032E.TAXONOMY_ADDCATEGORY_IOERROR");
                    msg.addArgument(categoryLabel);
                    msg.addArgument(ioe.toString());
                    Loggers.logger.log(Level.SEVERE, new IndexerException(msg, (Throwable)ioe));
                    throw new TaxonomyIndexerException(msg, (Throwable)ioe);
                }
                long myID = LabelToOrdinal.hash(categoryLabel);
                me = new CategoryAncestry(myFather, new CatId(myID), myOrdinal);
                this.l2o.addLabel(categoryLabel, myOrdinal);
                if (this.debugLevel > 10) {
                    System.out.println("father=" + myFather.getOrdinal() + " catId=" + myOrdinal + " label=" + categoryLabel);
                }
            }
        }
        this.accumAddCategoryTime += System.currentTimeMillis() - start;
        return me;
    }

    public CategoryAncestry internalGetCategoryAncestry(int ordinal, String label) throws TaxonomyIndexerException {
        long ID = LabelToOrdinal.hash(label);
        ArrayList<Number> ancestors = new ArrayList<Number>();
        String localLabel = label;
        while ((localLabel = this.stripSon(localLabel)) != null) {
            long id = LabelToOrdinal.hash(localLabel);
            int currOrdinal = this.l2o.getOrdinal(localLabel);
            ancestors.add(new Long(id));
            ancestors.add(new Integer(currOrdinal));
        }
        int len = ancestors.size() / 2;
        if (2 * len != ancestors.size()) {
            throw new TaxonomyIndexerException("confusion in internalGetCategoryAncestry");
        }
        CatId[] ancestorArray = new CatId[len];
        int[] ancestorOrdinals = new int[len];
        for (int i = 0; i < len; ++i) {
            ancestorArray[i] = new CatId((Long)ancestors.get(2 * i));
            ancestorOrdinals[i] = (Integer)ancestors.get(2 * i + 1);
        }
        return new CategoryAncestry(ancestorArray, ancestorOrdinals, new CatId(ID), ordinal);
    }

    protected String stripSon(String label) {
        int index = label.lastIndexOf(this.delimiter);
        if (index <= 0) {
            return null;
        }
        return label.substring(0, index);
    }
}

