/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.facet.taxi;

import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.IndexDescriptor;
import com.ibm.es.nuvo.facet.CatId;
import com.ibm.es.nuvo.facet.CategoryAncestry;
import com.ibm.es.nuvo.facet.CategoryInfo;
import com.ibm.es.nuvo.facet.CategoryInfoImpl;
import com.ibm.es.nuvo.facet.OrdinalPath;
import com.ibm.es.nuvo.facet.SonFatherMap;
import com.ibm.es.nuvo.facet.taxi.CategoryInfoTable;
import com.ibm.es.nuvo.facet.taxi.FatherSonMapReader;
import com.ibm.es.nuvo.facet.taxi.LabelToOrdinal;
import com.ibm.es.nuvo.facet.taxi.StringRepository;
import com.ibm.es.nuvo.facet.taxi.TaxonomyIndexerException;
import com.ibm.es.nuvo.facet.taxi.Utils;
import com.ibm.es.nuvo.logging.Loggers;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.logging.Level;
import org.apache.lucene.store.FSDirectory;

public class TaxonomyIndexReader {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    protected SonFatherMap sfm;
    private int debugLevel;
    private String delimiter;
    private File taxonomyRoot;
    File taxonomyDir;
    CategoryInfoTable cit;
    LabelToOrdinal l2o;
    StringRepository lr;
    FatherSonMapReader fsmReader;
    int root_ordinal;
    private long root_id;
    private int currentGeneration;
    private long totalL2OTime;
    private long internGetCatTime;
    private long internGetOrdTime;
    private long startTime;

    protected TaxonomyIndexReader() {
    }

    public TaxonomyIndexReader(CollectionConfiguration configuration) throws TaxonomyIndexerException {
        this(configuration, "\uf749");
    }

    public TaxonomyIndexReader(CollectionConfiguration configuration, String delimiter) throws TaxonomyIndexerException {
        IndexDescriptor taxiDescriptor = configuration.getIndexDescriptorFor(IndexDescriptor.IndexType.Facet);
        String debugStr = taxiDescriptor.getProperty("DebugLevel");
        if (debugStr != null) {
            try {
                this.debugLevel = Integer.parseInt(debugStr);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        try {
            String indexPath = configuration.getIndexPath(IndexDescriptor.IndexType.Facet);
            FSDirectory directory = FSDirectory.getDirectory((String)indexPath);
            this.taxonomyRoot = directory.getFile();
            this.delimiter = delimiter;
            this.openIndex(Path_Type.FIGURE_IT_OUT);
        }
        catch (IOException ioe) {
            Message msg = new Message("I0004E.CANNOT_CREATE_INDEX");
            msg.addArgument(configuration.getId());
            throw new TaxonomyIndexerException(msg, (Throwable)ioe);
        }
    }

    public TaxonomyIndexReader(String facetPath) throws TaxonomyIndexerException {
        File facetDir = new File(facetPath);
        if (!facetDir.exists() || !facetDir.isDirectory()) {
            Message msg = new Message("I0026E.TAXONOMY_INDEX_DIR_MISSING");
            msg.addArgument(facetDir);
            throw new TaxonomyIndexerException(msg);
        }
        this.currentGeneration = 0;
        this.taxonomyRoot = this.taxonomyDir = facetDir;
        this.openIndex(Path_Type.ABSOLUTE);
    }

    public void openIndex(Path_Type pathType) throws TaxonomyIndexerException {
        this.startTime = System.currentTimeMillis();
        if (pathType != Path_Type.ABSOLUTE) {
            if (this.taxonomyRoot.exists() && this.taxonomyRoot.isDirectory()) {
                this.currentGeneration = Utils.readMetaDataFile(this.taxonomyRoot);
            }
            this.taxonomyDir = new File(this.taxonomyRoot, Integer.toString(this.currentGeneration));
        }
        this.cit = new CategoryInfoTable(this.taxonomyDir, true);
        this.l2o = new LabelToOrdinal(this.taxonomyDir, null);
        this.lr = new StringRepository(this.taxonomyDir, true);
        this.fsmReader = new FatherSonMapReader(this.taxonomyDir, FatherSonMapReader.ReadMode.SEQUENTIAL);
        this.delimiter = this.l2o.getDelimiter();
        this.root_id = LabelToOrdinal.hash("facets");
        this.root_ordinal = Utils.addRootIfNeeded(this.cit, this.l2o, "facets");
        this.getSonFatherMap();
    }

    public String getTaxonomyIndexDirectory() {
        if (this.taxonomyDir == null) {
            return null;
        }
        return this.taxonomyDir.getAbsolutePath();
    }

    public String getLabel(int catId) throws IOException {
        long lrOffset = this.cit.getLabelLocation(catId);
        if (lrOffset < 0L) {
            return "No Label @ file offset " + lrOffset;
        }
        return this.lr.getString(lrOffset);
    }

    public CatId getID(String label) throws IOException {
        long myHash;
        int catOrdinal;
        if (this.debugLevel > 0) {
            System.out.println("getID label=" + label);
        }
        if ((catOrdinal = this.l2o.getOrdinal(myHash = LabelToOrdinal.hash(label))) == -2) {
            throw new IOException("no category with label " + label + " in taxonomy");
        }
        return new CatId(myHash);
    }

    public OrdinalPath getOrdinalPath(CategoryAncestry ca) throws TaxonomyIndexerException {
        return this.internalGetOrdinalPath(ca.getOrdinal(), ca.getAllAncestorsOrds());
    }

    private OrdinalPath internalGetOrdinalPath(int myOrdinal, int[] ancOrdinals) throws TaxonomyIndexerException {
        long start = System.currentTimeMillis();
        int len = 0;
        if (ancOrdinals != null) {
            len = ancOrdinals.length;
        }
        int[] allOrds = new int[len + 1];
        for (int i = 0; i < len; ++i) {
            allOrds[len - i - 1] = ancOrdinals[i];
        }
        allOrds[len] = myOrdinal;
        OrdinalPath ret = new OrdinalPath(allOrds);
        this.internGetOrdTime += System.currentTimeMillis() - start;
        return ret;
    }

    public CategoryInfo[] getPathFromRoot(CatId id) throws TaxonomyIndexerException {
        CategoryInfo[] ancestors = null;
        try {
            if (this.debugLevel > 0) {
                System.out.println("getPathFromRoot id=" + id);
            }
            int ordinal = this.l2o.getOrdinal(id.toLong());
            ancestors = this.internalGetAncestors(ordinal);
        }
        catch (IOException ioe) {
            Message msg = new Message("I0027E.TAXONOMY_INTERNAL_ERROR");
            throw new TaxonomyIndexerException(msg, (Throwable)ioe);
        }
        return ancestors;
    }

    void dumpStatistics(PrintStream ps) {
        if (this.internGetCatTime > 0L) {
            ps.println("TaxonomyIndexReader: Accumlated internalGetCategory time " + this.internGetCatTime + " millis");
        }
        if (this.internGetOrdTime > 0L) {
            ps.println("TaxonomyIndexReader: Accumlated getOrdinalPath time  " + this.internGetOrdTime + " millis");
        }
        ps.println("L2O stats");
        ps.println("\tgetFileTime millis " + this.l2o.getFileTime());
        ps.println("\tgetOrdinalTime millis " + this.l2o.getOrdinalTime());
        this.totalL2OTime = this.l2o.getOrdinalTime() + this.l2o.getFileTime();
        ps.println("\tTOTAL millis " + this.totalL2OTime);
        long end = System.currentTimeMillis();
        long elapsedTime = end - this.startTime;
        ps.println("Elapsed millis " + elapsedTime);
        long l2oTime = this.totalL2OTime;
        int percentL2O = (int)((double)l2oTime / (double)elapsedTime * 100.0);
        ps.println("percent Total Time in Label To Ordinal " + percentL2O + "%");
    }

    public void close() throws TaxonomyIndexerException {
        try {
            this.cit.close();
            this.lr.close();
            this.fsmReader.close();
        }
        catch (IOException ioe) {
            Message msg = new Message("I0033E.TAXONOMY_CLOSE");
            throw new TaxonomyIndexerException(msg, (Throwable)ioe);
        }
    }

    public int getOrdinal(String label) {
        return this.l2o.getOrdinal(label);
    }

    public CategoryInfo getCategoryInfo(OrdinalPath path) throws IOException {
        int catOrdinal;
        CategoryInfo ret = null;
        int n = catOrdinal = path.getNumOfComponents() > 0 ? path.get(path.getNumOfComponents() - 1) : this.root_ordinal;
        if (catOrdinal != -2) {
            ret = this.getCategoryInfoByOrdinal(catOrdinal);
        }
        return ret;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public CategoryInfo getCategoryInfo(CatId ID) throws IOException {
        int ordinal = this.l2o.getOrdinal(ID.toLong());
        return this.getCategoryInfoByOrdinal(ordinal);
    }

    public OrdinalPath getOrdinalPath(CatId catId) throws TaxonomyIndexerException {
        if (this.debugLevel > 0) {
            System.out.println("getOrdinalPath catId=" + catId);
        }
        try {
            int catOrdinal = this.l2o.getOrdinal(catId.toLong());
            if (catOrdinal == 0) {
                return new OrdinalPath(0);
            }
            CategoryInfoImpl[] ancestors = this.internalGetAncestors(catOrdinal);
            int[] ancOrdinals = new int[ancestors.length];
            for (int i = 0; i < ancestors.length; ++i) {
                ancOrdinals[i] = this.l2o.getOrdinal(ancestors[i].getLabel());
            }
            return this.internalGetOrdinalPath(catOrdinal, ancOrdinals);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            Message msg = new Message("I0021E.CANNOT_GET_ORDINAL_PATH");
            msg.addArgument(catId.toString());
            throw new TaxonomyIndexerException(msg, (Throwable)ioe);
        }
    }

    public CategoryInfo getCategoryInfoByOrdinal(int ordinal) throws IOException {
        long Id;
        String label;
        if (this.debugLevel > 0) {
            System.out.println("getCategoryInfoByOrdinal ordinal=" + ordinal);
        }
        if (ordinal == 0) {
            label = new String("Facet Taxonomy Virtual Root");
            Id = this.root_id;
        } else {
            long pLabel = this.cit.getLabelLocation(ordinal);
            if (pLabel == -2L) {
                return null;
            }
            label = this.lr.getString(pLabel);
            if (label == null) {
                return null;
            }
            Id = LabelToOrdinal.hash(label);
        }
        CategoryInfoImpl ret = new CategoryInfoImpl(new CatId(Id), label);
        return ret;
    }

    CategoryInfoImpl[] internalGetAncestors(int ordinal) throws IOException {
        String label;
        String currLabel = label = ordinal == 0 ? "facets" : this.lr.getString(this.cit.getLabelLocation(ordinal));
        ArrayList<CategoryInfoImpl> ancestors = new ArrayList<CategoryInfoImpl>();
        while ((currLabel = this.stripSon(currLabel)) != null) {
            CategoryInfoImpl ci = new CategoryInfoImpl(new CatId(LabelToOrdinal.hash(currLabel)), currLabel);
            ancestors.add(ci);
        }
        CategoryInfoImpl[] ancestorArray = new CategoryInfoImpl[ancestors.size()];
        for (int i = 0; i < ancestors.size(); ++i) {
            ancestorArray[i] = (CategoryInfoImpl)ancestors.get(i);
        }
        return ancestorArray;
    }

    CategoryAncestry internalGetCategoryAncestry(int ordinal, String label) throws IOException {
        long ID = LabelToOrdinal.hash(label);
        ArrayList<Number> ancestors = new ArrayList<Number>();
        String tempLabel = label;
        while ((tempLabel = this.stripSon(tempLabel)) != null) {
            long id = LabelToOrdinal.hash(tempLabel);
            int currOrdinal = this.l2o.getOrdinal(tempLabel);
            ancestors.add(new Long(id));
            ancestors.add(new Integer(currOrdinal));
        }
        int len = ancestors.size() / 2;
        if (2 * len != ancestors.size()) {
            throw new IOException("confusion in internalGetCategoryAncestry");
        }
        CatId[] ancestorArray = new CatId[len];
        int[] ancestorOrdinals = new int[len];
        for (int i = 0; i < len; ++i) {
            ancestorArray[i] = new CatId((Long)ancestors.get(2 * i));
            ancestorOrdinals[i] = (Integer)ancestors.get(2 * i + 1);
        }
        return new CategoryAncestry(ancestorArray, ancestorOrdinals, new CatId(ID), ordinal);
    }

    private String stripSon(String label) {
        int index = label.lastIndexOf(this.delimiter);
        if (index <= 0) {
            return null;
        }
        return label.substring(0, index);
    }

    public SonFatherMap getSonFatherMap() throws TaxonomyIndexerException {
        if (this.sfm != null) {
            return this.sfm;
        }
        try {
            this.sfm = this.fsmReader.getSonFatherMap();
            if (this.debugLevel > 0) {
                while (this.sfm.hasNext()) {
                    Integer badIndex = this.sfm.next();
                    System.out.println("Unset father " + this.getLabel(badIndex));
                    Message msg = new Message("I0022E.CANNOT_LOAD_TAXINDEX");
                    msg.addArgument(this.getLabel(badIndex));
                    Loggers.logger.log(Level.SEVERE, new TaxonomyIndexerException(msg));
                }
            }
            return this.sfm;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            Message msg = new Message("I0022E.CANNOT_LOAD_TAXINDEX");
            msg.addArgument(this.taxonomyDir.getAbsolutePath());
            throw new TaxonomyIndexerException(msg, (Throwable)ioe);
        }
    }

    public int getMaxOrdinal() {
        return this.l2o.getMaxOrdinal();
    }

    public boolean debug() {
        return this.debugLevel > 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Path_Type {
        ABSOLUTE,
        FIGURE_IT_OUT;

    }
}

