/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.facet.taxi;

import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.facet.taxi.TaxonomyIndexReader;
import com.ibm.es.nuvo.facet.taxi.TaxonomyIndexWriter;
import com.ibm.es.nuvo.facet.taxi.TaxonomyIndexerException;
import java.util.Enumeration;
import java.util.Hashtable;

public class TaxonomyIndexFactory {
    private static TaxonomyIndexFactory _instance = null;
    private Hashtable<String, TaxonomyIndexReader> taxindTable = new Hashtable();

    public static TaxonomyIndexFactory getInstance() {
        return _instance;
    }

    public synchronized TaxonomyIndexReader getTaxonomyIndexReader(CollectionConfiguration config) throws TaxonomyIndexerException {
        return this.getTaxonomyIndexReader(config, "\uf749");
    }

    public synchronized TaxonomyIndexReader getTaxonomyIndexReader(CollectionConfiguration config, String delimiter) throws TaxonomyIndexerException {
        TaxonomyIndexReader o = this.taxindTable.get("facets");
        if (o != null) {
            return o;
        }
        TaxonomyIndexReader newTax = null;
        newTax = new TaxonomyIndexReader(config, delimiter);
        this.taxindTable.put("facets", newTax);
        return newTax;
    }

    public synchronized TaxonomyIndexWriter getTaxonomyIndexWriter(CollectionConfiguration config) throws TaxonomyIndexerException {
        return this.getTaxonomyIndexWriter(config, "\uf749");
    }

    public synchronized TaxonomyIndexWriter getTaxonomyIndexWriter(CollectionConfiguration config, String delimiter) throws TaxonomyIndexerException {
        TaxonomyIndexWriter taxi = null;
        taxi = new TaxonomyIndexWriter(config, delimiter);
        return taxi;
    }

    public synchronized void closeTaxonomyIndex() throws TaxonomyIndexerException {
        TaxonomyIndexReader o = this.taxindTable.get("facets");
        if (o != null) {
            o.close();
        }
        this.taxindTable.remove("facets");
    }

    private TaxonomyIndexFactory() {
    }

    protected void finalize() throws TaxonomyIndexerException {
        Enumeration<TaxonomyIndexReader> taxIndices = this.taxindTable.elements();
        TaxonomyIndexReader curr = null;
        while ((curr = taxIndices.nextElement()) != null) {
            curr.close();
        }
    }

    static {
        _instance = new TaxonomyIndexFactory();
    }
}

