/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.facet.taxi;

import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.ConfigurationManager;
import com.ibm.es.nuvo.configuration.ConfigurationManagerException;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.configuration.GlobalConfigurationException;
import com.ibm.es.nuvo.facet.SonFatherMap;
import com.ibm.es.nuvo.facet.taxi.CategoryInfoEntry;
import com.ibm.es.nuvo.facet.taxi.CategoryInfoTable;
import com.ibm.es.nuvo.facet.taxi.FatherSonEntry;
import com.ibm.es.nuvo.facet.taxi.FatherSonMapReader;
import com.ibm.es.nuvo.facet.taxi.LabelToOrdinal;
import com.ibm.es.nuvo.facet.taxi.StringRepository;
import com.ibm.es.nuvo.facet.taxi.TaxonomyIndexReader;
import com.ibm.es.nuvo.facet.taxi.TaxonomyIndexerException;
import com.ibm.es.nuvo.logging.Loggers;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaxonomyDebug {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    TaxonomyIndexReader ti;
    SonFatherMap sfm;
    File indexDir;
    private CategoryInfoTable cit;
    private LabelToOrdinal l2o;
    private StringRepository lr;
    private FatherSonMapReader fsmReader;
    private PrintStream ps;
    private CollectionConfiguration config;
    private String outputPath;
    private boolean interactive = true;
    private String timeStamp;
    private static final String FACET_HEADER = "Ordinal\tFather\tSonLabel";
    private static final String PROMPT = "Commands: \n\tson <cid_num>           -- dump CategoryInfoTable in vicinity of son CID\n\tfather                  -- dump CIT for father + son, FSM entries for same, in vicinity of son's father's CID\n\tlabel <categoryName>    -- return Son Category ID of categoryName, if found\n\tcit [start] [end]       -- dump CIT table only between start and end\n\tfsm [start] [end]       -- dump FatherSonMap between start and end\n\tlr                      -- dump Label Repository String table\n\twin\t-- number of rows of context +/- around son/father CID\n\tquit\n";
    private static final String USAGE = "java com.ibm.search.facet.taxind.TaxonomyDebug [--index <directory>] [--dump] [--clp]\n\t--index is the facets subdirectory, e.g. Default/data/facets/9\n\t--dump just dump the whole taxonomy index\n\t--clp Command Line Processor to interactively dump parts of the Taxonomy";

    public TaxonomyDebug(CollectionConfiguration configuration) throws TaxonomyIndexerException {
        this.config = configuration;
        this.ti = new TaxonomyIndexReader(this.config);
        this.init();
    }

    public TaxonomyDebug(String colId) throws TaxonomyIndexerException {
        CollectionConfiguration configuration;
        if (!TaxonomyDebug.initGlobalConfig()) {
            throw new TaxonomyIndexerException("Failed to get configuration");
        }
        try {
            configuration = ConfigurationManager.getConfigurationManager().getCollection(colId);
        }
        catch (ConfigurationManagerException e) {
            e.printStackTrace();
            throw new TaxonomyIndexerException("Failed to get configuration " + e.toString());
        }
        this.ti = new TaxonomyIndexReader(configuration);
        this.init();
    }

    public TaxonomyDebug(File indexDir, String outputPath) throws TaxonomyIndexerException {
        this.indexDir = indexDir;
        if (!TaxonomyDebug.initGlobalConfig()) {
            throw new TaxonomyIndexerException("Failed to get configuration");
        }
        this.ti = new TaxonomyIndexReader(indexDir.getAbsolutePath());
        this.outputPath = outputPath == null ? indexDir.getAbsolutePath() : outputPath;
        this.init();
    }

    private void init() {
        this.cit = this.ti.cit;
        this.l2o = this.ti.l2o;
        this.lr = this.ti.lr;
        this.fsmReader = this.ti.fsmReader;
        this.ps = System.out;
        this.outputPath = this.ti.getTaxonomyIndexDirectory();
    }

    public void close() throws TaxonomyIndexerException {
        if (this.ti != null) {
            this.ti.close();
        }
    }

    public static void main(String[] args) {
        boolean dump = false;
        String indexDir = null;
        String colId = null;
        for (int a = 0; a < args.length; ++a) {
            if (args[a].equals("--dump")) {
                dump = true;
                continue;
            }
            if (args[a].equals("--index")) {
                if (++a >= args.length) {
                    TaxonomyDebug.usage("Not enough args to --index");
                    return;
                }
                indexDir = args[a];
                continue;
            }
            if (args[a].equals("--colid")) {
                if (++a >= args.length) {
                    TaxonomyDebug.usage("Not enough args to --colid");
                    return;
                }
                colId = args[a];
                continue;
            }
            if (!args[a].equals("--help")) continue;
            TaxonomyDebug.usage("");
            return;
        }
        try {
            TaxonomyDebug td = null;
            td = indexDir != null ? new TaxonomyDebug(new File(indexDir), null) : new TaxonomyDebug(colId);
            if (dump) {
                td.dump();
            } else {
                td.commandLineTaxI();
            }
        }
        catch (TaxonomyIndexerException e) {
            System.out.println("Failed to open Taxonomy Index: " + e.toString());
            e.printStackTrace();
            return;
        }
    }

    private static boolean initGlobalConfig() {
        String globalConfigPath = "config/config.xml";
        GlobalConfiguration globalConfig = null;
        try {
            GlobalConfiguration.initialize(globalConfigPath);
            globalConfig = GlobalConfiguration.getConfiguration();
            File configFile = new File(globalConfigPath);
            File fullPath = configFile.getCanonicalFile();
            if (!fullPath.exists()) {
                throw new GlobalConfigurationException("Bad config path " + fullPath.getAbsolutePath());
            }
            System.out.println("Config file path " + fullPath.getAbsolutePath());
            File globalConfigDirectoryObj = new File(fullPath.getParent());
            String globalConfigFileParentDir = globalConfigDirectoryObj.getParent();
            globalConfig.setConfigPath(globalConfigDirectoryObj.getAbsolutePath());
            globalConfig.setInstallPath(globalConfigFileParentDir);
            globalConfig.validate();
            String installDirectory = globalConfig.getInstallPath();
            System.setProperty("whitney.home", installDirectory);
            String jaasConfig = globalConfig.getConfigPath() + File.separator + "authentication" + File.separator + "jaas.config";
            System.setProperty("java.security.auth.login.config", jaasConfig);
        }
        catch (Exception e) {
            System.out.println("Failed to load config " + e.toString());
            e.printStackTrace();
            Message msg = new Message("G0026E.CONFIG_FILE_ERROR");
            msg.addArgument(globalConfigPath);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commandLineTaxI() {
        CommandInfo cmd = new CommandInfo(System.out);
        try {
            boolean more = true;
            System.out.println(PROMPT);
            while (more) {
                TaxonomyDebug.parseCommand(cmd);
                more = this.executeCommand(cmd);
            }
        }
        catch (IOException e) {
            System.err.println("Failed to open Taxonomy Index");
            e.printStackTrace();
        }
        finally {
            try {
                if (this.ti != null) {
                    this.ti.close();
                }
            }
            catch (TaxonomyIndexerException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean executeCommand(CommandInfo cmdInfo) throws IOException {
        StringTokenizer toks = cmdInfo.getTokens();
        if (!toks.hasMoreElements()) {
            return true;
        }
        String cmdStr = toks.nextToken();
        Command cmd = Command.NONE;
        if (cmdStr.equalsIgnoreCase("exit") || cmdStr.equalsIgnoreCase("quit")) {
            return false;
        }
        if (cmdStr.equalsIgnoreCase("son")) {
            cmd = Command.SON_CID;
        } else if (cmdStr.equalsIgnoreCase("father")) {
            cmd = Command.FATHER_CID;
        } else if (cmdStr.equalsIgnoreCase("label")) {
            cmd = Command.LABEL;
        } else if (cmdStr.equalsIgnoreCase("cit")) {
            cmd = Command.DUMP_CIT;
        } else if (cmdStr.equalsIgnoreCase("fsm")) {
            cmd = Command.DUMP_FSM;
        } else if (cmdStr.equalsIgnoreCase("lr")) {
            cmd = Command.DUMP_LABELREPOSITORY;
        } else if (cmdStr.equalsIgnoreCase("tree")) {
            cmd = Command.DUMP_HIERARCHY;
        } else {
            if (cmdStr.equalsIgnoreCase("help")) {
                System.out.println(PROMPT);
                return true;
            }
            if (cmdStr.equalsIgnoreCase("win")) {
                cmdInfo.setWindowSize();
                return true;
            }
        }
        switch (cmd) {
            case LABEL: {
                String label = cmdInfo.parseLabel();
                if (label == null) break;
                int cid = this.l2o.getOrdinal(label);
                this.ps.println("label's cid: " + cid);
                cmdInfo.setCid(cid);
                break;
            }
            case SON_CID: {
                cmdInfo.parseCid();
                int startCid = cmdInfo.getStartCid();
                int endCid = cmdInfo.getEndCid();
                this.dumpFacetRange(startCid, endCid);
                try {
                    this.sfm = this.ti.getSonFatherMap();
                }
                catch (TaxonomyIndexerException e) {
                    e.printStackTrace();
                }
                break;
            }
            case FATHER_CID: {
                this.printFatherInfo(cmdInfo);
                break;
            }
            case DUMP_CIT: {
                int start = cmdInfo.parseStart(0);
                int end = cmdInfo.parseEnd(this.l2o.getMaxOrdinal());
                this.dumpFacetRange(start, end);
                break;
            }
            case DUMP_FSM: {
                int start = cmdInfo.parseStart(1);
                int end = cmdInfo.parseEnd(this.l2o.getMaxOrdinal());
                this.dumpFSMRange(start, end);
                break;
            }
            case DUMP_LABELREPOSITORY: {
                this.dumpLabelRepository();
                break;
            }
            case DUMP_HIERARCHY: {
                this.dumpByHierarchy();
                break;
            }
            default: {
                System.out.println("Command not understood: " + cmdStr);
            }
        }
        return true;
    }

    private void printFatherInfo(CommandInfo cmdInfo) throws IOException {
        int cid = cmdInfo.getSonCid();
        CategoryInfoEntry cie = this.cit.getEntry(cid);
        int fatherCid = cie.getFatherOrdinal();
        if (fatherCid < 0) {
            System.out.println("set son id before trying to get father");
            return;
        }
        CategoryInfoEntry fatherCie = this.cit.getEntry(fatherCid);
        this.printCIT(fatherCid, fatherCie, true);
        this.printCIT(cid, cie, false);
    }

    private static void parseCommand(CommandInfo cmd) {
        System.out.print("\n\n > ");
        try {
            System.in.read(cmd.getBuffer());
            TaxonomyDebug.tokenize(cmd);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void dumpFacetRange(int firstOrdinal, int endCid) throws IOException {
        FileOutputStream fos = null;
        if (!this.interactive) {
            fos = new FileOutputStream(this.outputPath + File.separator + "facetdump_" + this.timeStamp + ".txt");
            this.ps = new PrintStream(fos);
        }
        this.ps.println("# Facets " + endCid);
        this.ps.println(FACET_HEADER);
        int tempCid = endCid;
        int maxOrdinal = this.l2o.getMaxOrdinal();
        if (endCid > maxOrdinal) {
            tempCid = maxOrdinal;
        }
        for (int cid = firstOrdinal; cid < tempCid; ++cid) {
            CategoryInfoEntry cie = this.cit.getEntry(cid);
            this.printCIT(cid, cie, false);
        }
        if (!this.interactive && fos != null) {
            this.ps.close();
            this.ps = System.out;
        }
    }

    public Vector<String> getFacets() throws IOException {
        try {
            return this.getFacetRange(0, 20);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw ioe;
        }
    }

    private Vector<String> getFacetRange(int firstOrdinal, int endCid) throws IOException {
        this.ps.println("# Facets " + endCid);
        this.ps.println(FACET_HEADER);
        int tempCid = endCid;
        int maxOrdinal = this.l2o.getMaxOrdinal();
        if (endCid > maxOrdinal) {
            tempCid = maxOrdinal;
        }
        Vector<String> results = new Vector<String>(tempCid);
        for (int cid = firstOrdinal; cid < tempCid; ++cid) {
            CategoryInfoEntry cie = this.cit.getEntry(cid);
            String res = this.getCIT(cid, cie, false);
            results.addElement(res);
        }
        return results;
    }

    private void dumpLabelRepository() throws IOException {
        String label;
        System.out.println("Virtual 'facets' label = facets , l2o cid = " + this.l2o.getOrdinal("facets"));
        this.lr.seek(8);
        while ((label = this.lr.getNext()) != null) {
            int cid = this.l2o.getOrdinal(label);
            System.out.println("label = " + label + ", l2o cid = " + cid);
        }
    }

    private void printCIT(int cid, CategoryInfoEntry cie, boolean printHeader) throws IOException {
        if (printHeader) {
            this.ps.println(FACET_HEADER);
        }
        String label = "Facet Taxonomy Virtual Root";
        if (cie.getLabelLocation() >= 0L) {
            label = this.lr.getString(cie.getLabelLocation());
        }
        this.ps.println(cid + "\t" + cie.getFatherOrdinal() + "\t" + label);
    }

    private String getCIT(int cid, CategoryInfoEntry cie, boolean printHeader) throws IOException {
        if (printHeader) {
            this.ps.println(FACET_HEADER);
        }
        String label = "Facet Taxonomy Virtual Root";
        if (cie.getLabelLocation() >= 0L) {
            label = this.lr.getString(cie.getLabelLocation());
            return cid + "\t" + cie.getFatherOrdinal() + "\t" + label;
        }
        return cid + "\t" + cie.getFatherOrdinal() + "\t" + label;
    }

    public void checkFSMSorted() throws TaxonomyIndexerException {
        int curFather;
        FatherSonEntry fse;
        int maxOrdinal = this.l2o.getMaxOrdinal();
        this.ps.println("checkFSMSorted # facets =" + maxOrdinal);
        Iterator<FatherSonEntry> iter = this.fsmReader.iterator();
        int prevFather = -1;
        int prevSon = -1;
        int i = 1;
        while (iter.hasNext() && (fse = iter.next()) != null && (curFather = fse.fatherOrdinal) >= 0) {
            int curSon = fse.sonOrdinal;
            if (curFather < prevFather) {
                throw new TaxonomyIndexerException("Father out of order " + i + " preFather=" + prevFather + " curFather=" + curFather);
            }
            if (curFather == prevFather && curSon < prevSon) {
                throw new TaxonomyIndexerException("Son out of order " + i + " preFather=" + prevFather + " curFather=" + curFather + " prevSon=" + prevSon + " curSon=" + curSon);
            }
            prevFather = curFather;
            prevSon = curSon;
            ++i;
        }
        try {
            this.fsmReader.close();
        }
        catch (IOException ioe) {
            throw new TaxonomyIndexerException("FatherSonReader close failed");
        }
    }

    private void dumpFatherSonMap() throws IOException {
        int numFSMs = this.fsmReader.getFatherSonMapSize();
        FileOutputStream fos = null;
        if (!this.interactive) {
            fos = new FileOutputStream(this.outputPath + File.separator + "fsmdump_" + this.timeStamp + ".txt");
            this.ps = new PrintStream(fos);
        }
        this.ps.println("dumpFatherSonMap # facets =" + numFSMs);
        this.dumpFSMRange(1, numFSMs);
        if (!this.interactive) {
            this.ps.close();
            this.ps = System.out;
        }
    }

    private void dumpFSMRange(int start, int end) throws IOException {
        this.ps.println("i\tfather\tson\tsonLabelLoc");
        if (start < 0) {
            start = 1;
        }
        if (end > this.fsmReader.getFatherSonMapSize()) {
            end = this.fsmReader.getFatherSonMapSize();
        }
        for (int recNo = start; recNo < end; ++recNo) {
            FatherSonEntry fse = this.fsmReader.getEntry(recNo);
            this.printFSM(recNo, fse, false);
        }
    }

    private void printFSM(int recNo, FatherSonEntry fse, boolean printHeader) throws IOException {
        if (printHeader) {
            this.ps.println("\nIndex\tfather\tson\tsonLabelLoc\tsonLabel");
        }
        int father = fse.fatherOrdinal;
        int son = fse.sonOrdinal;
        String label = "Facet Taxonomy Virtual Root";
        if (fse.sonLabel >= 0L) {
            label = this.lr.getString(fse.sonLabel);
        }
        this.ps.println(recNo + "\t" + father + "\t" + son + "\t" + label);
    }

    public void dumpTaxonomyIndex() throws IOException, TaxonomyIndexerException {
        this.timeStamp = TaxonomyDebug.getTimeStamp();
        try {
            this.dumpFatherSonMap();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw ioe;
        }
        this.fsmReader = new FatherSonMapReader(this.ti.taxonomyDir, FatherSonMapReader.ReadMode.SEQUENTIAL);
        this.checkFSMSorted();
        this.fsmReader = new FatherSonMapReader(this.ti.taxonomyDir, FatherSonMapReader.ReadMode.SEQUENTIAL);
        this.checkSonsHaveFather();
        int maxOrdinal = this.l2o.getMaxOrdinal();
        try {
            this.dumpFacetRange(0, maxOrdinal);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw ioe;
        }
    }

    private void checkSonsHaveFather() throws TaxonomyIndexerException {
        try {
            SonFatherMap localSfm = this.fsmReader.getSonFatherMap();
            while (localSfm.hasNext()) {
                Integer badIndex = localSfm.next();
                System.out.println("Unset father @" + badIndex + " " + this.ti.getLabel(badIndex));
                Message msg = new Message("I0022E.CANNOT_LOAD_TAXINDEX");
                msg.addArgument(this.ti.getLabel(badIndex));
                Loggers.logger.log(Level.SEVERE, new TaxonomyIndexerException(msg));
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            Message msg = new Message("I0022E.CANNOT_LOAD_TAXINDEX");
            msg.addArgument(this.ti.taxonomyDir.getAbsolutePath());
            throw new TaxonomyIndexerException(msg, (Throwable)ioe);
        }
    }

    public void dumpByHierarchy() throws IOException {
        System.err.println("Ordinal\tFather\tLabel");
        this.dumpByHierarchy(this.ti.root_ordinal, "");
    }

    public void dumpByHierarchy(int catOrdinal, String indent) throws IOException {
        CategoryInfoEntry cie = this.cit.getEntry(catOrdinal);
        long loc = cie.getLabelLocation();
        String label = "Facet Taxonomy Virtual Root";
        if (loc >= 0L) {
            label = this.lr.getString(loc);
        }
        System.err.println(indent + label + "  " + catOrdinal + "  " + cie.getFatherOrdinal());
    }

    private static StringTokenizer tokenize(CommandInfo cmd) {
        byte[] b = cmd.getBuffer();
        String buf = new String(b).trim();
        StringTokenizer tokens = new StringTokenizer(buf, " \t\r\n");
        cmd.setTokens(tokens);
        return tokens;
    }

    private static String getTimeStamp() {
        SimpleDateFormat sd = new SimpleDateFormat("yyyyMMdd_HHmm");
        Date currTime = new Date();
        return sd.format(currTime);
    }

    public void dump() {
        this.interactive = false;
        try {
            this.dumpTaxonomyIndex();
        }
        catch (IOException e) {
            this.ps.println("TaxI read failed " + e.toString());
            e.printStackTrace();
        }
        catch (TaxonomyIndexerException e) {
            this.ps.println("TaxI read failed " + e.toString());
            e.printStackTrace();
        }
    }

    private static void usage(String msg) {
        System.err.println(msg);
        System.err.println(USAGE);
    }

    private class CommandInfo {
        int cid;
        int fatherCid;
        private String label;
        private PrintStream ps1;
        int windowSize = 3;
        private byte[] cmdBuffer = new byte[1024];
        private StringTokenizer tokens;

        CommandInfo(PrintStream _ps) {
            this.ps1 = _ps;
        }

        public void setCid(int cid) {
            this.cid = cid;
        }

        public int getSonCid() {
            return this.cid;
        }

        public void setWindowSize() {
            if (!this.tokens.hasMoreTokens()) {
                this.ps1.println("Missing window size numeric value");
                return;
            }
            String size = this.tokens.nextToken();
            this.windowSize = Integer.parseInt(size);
        }

        public int getStartCid() {
            int startCid = this.cid - this.windowSize;
            if (startCid < 0 && this.windowSize > 0) {
                startCid = 1;
            }
            return startCid;
        }

        public int getEndCid() {
            int endCid = this.cid + this.windowSize + 1;
            return endCid;
        }

        public StringTokenizer getTokens() {
            return this.tokens;
        }

        public void setTokens(StringTokenizer tokens) {
            this.tokens = tokens;
        }

        public byte[] getBuffer() {
            return this.cmdBuffer;
        }

        public int getWindowSize() {
            return this.windowSize;
        }

        public int parseCid() throws NumberFormatException {
            if (!this.tokens.hasMoreTokens()) {
                this.ps1.println("Missing son/father CID numeric value");
                return -1;
            }
            String id = this.tokens.nextToken();
            this.cid = Integer.parseInt(id);
            return this.cid;
        }

        public int parseStart(int start) {
            if (!this.tokens.hasMoreTokens()) {
                return start;
            }
            String val = this.tokens.nextToken();
            return Integer.parseInt(val);
        }

        public int parseEnd(int maxOrdinal) {
            if (!this.tokens.hasMoreTokens()) {
                return maxOrdinal;
            }
            String val = this.tokens.nextToken();
            return Integer.parseInt(val);
        }

        public String parseLabel() {
            if (!this.tokens.hasMoreTokens()) {
                this.ps1.println("Missing label argument");
                return null;
            }
            this.label = null;
            while (this.tokens.hasMoreTokens()) {
                if (this.label != null) {
                    this.label = this.label + "\uf749";
                    this.label = this.label + this.tokens.nextToken();
                    continue;
                }
                this.label = this.tokens.nextToken();
            }
            return this.label;
        }

        public int getFatherCid() throws NumberFormatException {
            if (!this.tokens.hasMoreTokens()) {
                this.ps1.println("Missing son/father CID numeric value");
                return -1;
            }
            String id = this.tokens.nextToken();
            this.fatherCid = Integer.parseInt(id);
            return this.fatherCid;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Command {
        NONE,
        QUIT,
        SON_CID,
        FATHER_CID,
        LABEL,
        DUMP_LABELREPOSITORY,
        DUMP_CIT,
        DUMP_FSM,
        DUMP_HIERARCHY;

    }
}

