/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.facet.taxi;

import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.facet.taxi.TaxonomyIndexerException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class StringRepository {
    public static final int INVALID_LOCATION = -1;
    public static final String fileName = "LabelRepository";
    private final File indexDir;
    private RandomAccessFile stringFileAccessor;
    private long stringFileSize;

    public StringRepository(File _indexDir, boolean connectOnly) throws TaxonomyIndexerException {
        this.indexDir = _indexDir;
        this.connectToFile(connectOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long addString(String str) throws IOException {
        long retVal = this.stringFileSize;
        StringRepository stringRepository = this;
        synchronized (stringRepository) {
            this.stringFileAccessor.seek(retVal);
            this.stringFileAccessor.writeUTF(str);
            this.stringFileSize = this.stringFileAccessor.getFilePointer();
            this.stringFileAccessor.seek(0L);
            this.stringFileAccessor.writeLong(this.stringFileSize);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(long location) throws IOException {
        String ret = null;
        StringRepository stringRepository = this;
        synchronized (stringRepository) {
            this.stringFileAccessor.seek(location);
            ret = this.stringFileAccessor.readUTF();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNext() {
        String ret = null;
        StringRepository stringRepository = this;
        synchronized (stringRepository) {
            try {
                ret = this.stringFileAccessor.readUTF();
            }
            catch (IOException e) {
                return null;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void seek(int location) throws IOException {
        StringRepository stringRepository = this;
        synchronized (stringRepository) {
            this.stringFileAccessor.seek(location);
        }
    }

    private void connectToFile(boolean mustExist) throws TaxonomyIndexerException {
        File target = new File(this.indexDir, fileName);
        try {
            if (target.exists()) {
                this.stringFileAccessor = new RandomAccessFile(target, "rw");
                this.stringFileAccessor.seek(0L);
                this.stringFileSize = this.stringFileAccessor.readLong();
                if (this.stringFileSize < 8L) {
                    Message msg = new Message("I0029E.TAXONOMY_INDEX_META_CORRUPT");
                    msg.addArgument(target);
                    msg.addArgument(this.stringFileSize);
                    msg.addArgument("< 8");
                    throw new TaxonomyIndexerException(msg);
                }
            } else {
                if (mustExist) {
                    Message msg = new Message("I0024E.TAXONOMY_FILE_MISSING");
                    msg.addArgument(target.getAbsolutePath());
                    throw new TaxonomyIndexerException(msg);
                }
                this.createNewFile();
            }
        }
        catch (IOException ioe) {
            Message msg = new Message("I0028E.TAXONOMY_FILE_OPEN");
            msg.addArgument(target.getAbsolutePath());
            throw new TaxonomyIndexerException(msg, (Throwable)ioe);
        }
    }

    private void createNewFile() throws IOException {
        File target = new File(this.indexDir, fileName);
        target.createNewFile();
        this.stringFileAccessor = new RandomAccessFile(target, "rw");
        this.stringFileAccessor.seek(0L);
        this.stringFileSize = 8L;
        this.stringFileAccessor.writeLong(this.stringFileSize);
    }

    long getFileLength() {
        return this.stringFileSize;
    }

    public void close() throws IOException {
        this.stringFileAccessor.close();
    }
}

