/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.facet.taxi;

import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.facet.taxi.TaxonomyIndexerException;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class LabelToOrdinal {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private Hashtable<Long, Integer> ht;
    private final File indexDir;
    private int occupancy;
    private String delimiter;
    public static final int FIRST_ORDINAL = 0;
    public static final int INITIAL_TABLE_SIZE = 1200000;
    public static final String fileName = "LabelToOrdinal";
    private long accumGetOrdTime;
    private long accumAddLabelTime;
    private long accumFileTime;

    public LabelToOrdinal(File _indexDir, String _delimiter) throws TaxonomyIndexerException {
        this.delimiter = _delimiter;
        this.occupancy = 0;
        this.indexDir = _indexDir;
        this.connectToFile();
    }

    private boolean connectToFile() throws TaxonomyIndexerException {
        long start = System.currentTimeMillis();
        File l2o = new File(this.indexDir, fileName);
        if (!l2o.exists()) {
            this.ht = new Hashtable(1200000);
            return false;
        }
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        FilterInputStream din = null;
        try {
            fis = new FileInputStream(l2o);
        }
        catch (IOException ioe) {
            Message msg = new Message("I0028E.TAXONOMY_FILE_OPEN");
            msg.addArgument(l2o.getAbsolutePath());
            throw new TaxonomyIndexerException(msg, (Throwable)ioe);
        }
        try {
            bis = new BufferedInputStream(fis, 0x400000);
            din = new DataInputStream(bis);
            try {
                this.occupancy = (int)((DataInputStream)din).readLong();
                this.delimiter = ((DataInputStream)din).readUTF();
            }
            catch (IOException ioe) {
                Message msg = new Message("I0029E.TAXONOMY_READ_DELIMITER");
                throw new TaxonomyIndexerException(msg, (Throwable)ioe);
            }
            this.ht = new Hashtable(this.occupancy);
            for (int i = 0; i < this.occupancy; ++i) {
                int ord;
                long labelHash = ((DataInputStream)din).readLong();
                Integer prev = this.ht.put(new Long(labelHash), new Integer(ord = ((DataInputStream)din).readInt()));
                if (prev == null) continue;
                throw new IOException("connectToFile: Hash collision reading record " + i + " adding hash " + labelHash + " prevHash " + prev);
            }
        }
        catch (IOException ioe) {
            Message msg = new Message("I0027E.TAXONOMY_INTERNAL_ERROR");
            msg.addArgument("Reading hash entries from " + l2o.getAbsolutePath());
            throw new TaxonomyIndexerException(msg, (Throwable)ioe);
        }
        finally {
            try {
                if (din != null) {
                    din.close();
                }
            }
            catch (IOException ioe) {}
            this.accumFileTime += System.currentTimeMillis() - start;
        }
        return true;
    }

    public int getNextOrdinal() {
        return this.occupancy++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLabel(String label, int ordinal) throws TaxonomyIndexerException {
        long start = System.currentTimeMillis();
        try {
            LabelToOrdinal labelToOrdinal = this;
            synchronized (labelToOrdinal) {
                long myHash = LabelToOrdinal.hash(label);
                Integer prevVal = this.ht.put(new Long(myHash), new Integer(ordinal));
                if (prevVal != null) {
                    Message msg = new Message("I0027E.TAXONOMY_INTERNAL_ERROR");
                    msg.addArgument("Label already exists: " + label + " prev ordinal " + prevVal);
                    throw new TaxonomyIndexerException(msg);
                }
            }
        }
        finally {
            this.accumAddLabelTime += System.currentTimeMillis() - start;
        }
    }

    public int getOrdinal(String label) {
        long start = System.currentTimeMillis();
        long myHash = LabelToOrdinal.hash(label);
        int ord = this.getOrdinal(myHash);
        this.accumGetOrdTime += System.currentTimeMillis() - start;
        return ord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOrdinal(long labelHash) {
        LabelToOrdinal labelToOrdinal = this;
        synchronized (labelToOrdinal) {
            Integer ord = this.ht.get(new Long(labelHash));
            if (ord == null) {
                return -2;
            }
            return ord;
        }
    }

    public int getMaxOrdinal() {
        return this.occupancy;
    }

    public static long hash(String str) {
        String lower = str.toLowerCase();
        long first = lower.hashCode();
        long second = (lower + "y#%x").hashCode();
        long rval = (first << 32) + second;
        return rval;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        if (this.ht == null) {
            return;
        }
        long start = System.currentTimeMillis();
        File l2o = new File(this.indexDir, fileName);
        if (l2o.exists() && !l2o.delete()) {
            throw new IOException("Cannot write to " + l2o.getAbsolutePath());
        }
        int count = 0;
        FileOutputStream fos = new FileOutputStream(l2o);
        DataOutputStream dout = new DataOutputStream(fos);
        try {
            int tableSize = this.ht.size();
            dout.writeLong(tableSize);
            dout.writeUTF(this.delimiter);
            Enumeration<Long> e = this.ht.keys();
            while (e.hasMoreElements()) {
                Long labelHash = e.nextElement();
                Integer ord = this.ht.get(labelHash);
                dout.writeLong(labelHash);
                dout.writeInt(ord);
                ++count;
            }
        }
        finally {
            if (dout != null) {
                dout.close();
            }
            this.accumFileTime += System.currentTimeMillis() - start;
        }
    }

    public String getFileName() {
        return fileName;
    }

    long getOrdinalTime() {
        return this.accumGetOrdTime;
    }

    long getAddLabelTime() {
        return this.accumAddLabelTime;
    }

    long getFileTime() {
        return this.accumFileTime;
    }
}

