/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.facet.taxi;

import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.facet.taxi.FatherSonEntry;
import com.ibm.es.nuvo.facet.taxi.FatherSonMapReader;
import com.ibm.es.nuvo.facet.taxi.TaxonomyIndexerException;
import com.ibm.es.nuvo.facet.taxi.Utils;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;

public class FatherSonMapWriter {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final String fileName = "FatherSon";
    private DataInputStream din;
    private DataOutputStream dout;
    private final File indexDir;
    private final File newIndexDir;
    private TreeSet<FatherSonEntry> cache;
    private static final long VALID_METADATA = 0x40000000L;
    private int fatherSonSize;
    private static final int FSM_IS_SORTED = 1;
    private long mergeTime;
    private int fileRecords;
    private int debugLevel = 0;

    public static int compare(Object e1, Object e2) {
        FatherSonEntry a = (FatherSonEntry)e1;
        FatherSonEntry b = (FatherSonEntry)e2;
        if (a.fatherOrdinal < b.fatherOrdinal) {
            return -1;
        }
        if (a.fatherOrdinal > b.fatherOrdinal) {
            return 1;
        }
        if (a.sonOrdinal < b.sonOrdinal) {
            return -1;
        }
        if (a.sonOrdinal > b.sonOrdinal) {
            return 1;
        }
        return 0;
    }

    public FatherSonMapWriter(File _prevIndexDir, File _toIndexDir, int debugLevel) throws TaxonomyIndexerException {
        this.indexDir = _prevIndexDir;
        this.newIndexDir = _toIndexDir;
        this.debugLevel = debugLevel;
        this.openFiles();
        FatherSonMapComparator comp = new FatherSonMapComparator();
        this.cache = new TreeSet<FatherSonEntry>(comp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int add(int fatherOrdinal, int sonOrdinal, long sonLabel) {
        FatherSonEntry fse = new FatherSonEntry(fatherOrdinal, sonOrdinal, sonLabel);
        int retVal = -2;
        FatherSonMapWriter fatherSonMapWriter = this;
        synchronized (fatherSonMapWriter) {
            retVal = this.fatherSonSize;
            this.cache.add(fse);
        }
        return retVal;
    }

    public void merge() throws TaxonomyIndexerException, IOException {
        long start = System.currentTimeMillis();
        long accumCitFSLocTime = 0L;
        if (this.indexDir != null && (this.cache == null || this.cache.isEmpty())) {
            Utils.copyFile(this.indexDir, this.newIndexDir, fileName, null);
            if (this.debugLevel > 0) {
                System.out.println("empty cache, copy files from " + this.indexDir.getName() + " to " + this.newIndexDir.getName());
            }
            return;
        }
        int mergedSize = this.fileRecords + this.cache.size() + 1;
        if (this.debugLevel > 0) {
            System.out.println("mergedSize " + mergedSize + " fileRecords " + this.fileRecords + " cachesize " + this.cache.size());
        }
        this.writeMeta(mergedSize);
        long accumNewFSM = 0L;
        if (this.debugLevel > 0) {
            System.out.println(" Create Map");
        }
        FatherSonMapReader oldFsm = null;
        Iterator<FatherSonEntry> fileIter = null;
        if (this.indexDir != null) {
            oldFsm = new FatherSonMapReader(this.indexDir, FatherSonMapReader.ReadMode.SEQUENTIAL);
            fileIter = oldFsm.iterator();
        } else {
            fileIter = new EmptyIterator();
        }
        long accumCacheAccess = System.currentTimeMillis();
        Iterator<FatherSonEntry> cacheIter = this.cache.iterator();
        accumCacheAccess = System.currentTimeMillis() - accumCacheAccess;
        int currFather = -2;
        FatherSonEntry fileElem = null;
        FatherSonEntry cacheElem = null;
        int recordNo = 1;
        while (cacheIter.hasNext() || cacheElem != null || fileIter.hasNext() || fileIter != null) {
            int newFather;
            long temp;
            if (cacheElem == null && cacheIter.hasNext()) {
                cacheElem = cacheIter.next();
            }
            if (fileElem == null && fileIter.hasNext()) {
                fileElem = fileIter.next();
            }
            if (fileElem == null && cacheElem == null) {
                if (this.debugLevel <= 0) break;
                System.out.println("Out of cache and file elements, break out");
                break;
            }
            int diff = fileElem != null && cacheElem != null ? FatherSonMapWriter.compare(fileElem, cacheElem) : (fileElem == null ? 1 : -1);
            if (diff > 0) {
                temp = System.currentTimeMillis();
                newFather = cacheElem.fatherOrdinal;
                cacheElem.write(this.dout);
                accumNewFSM += System.currentTimeMillis() - temp;
                if (this.debugLevel > 20) {
                    System.out.println("cache: " + cacheElem.toString());
                }
                cacheElem = null;
            } else {
                temp = System.currentTimeMillis();
                newFather = fileElem.fatherOrdinal;
                fileElem.write(this.dout);
                accumNewFSM += System.currentTimeMillis() - temp;
                if (this.debugLevel > 20) {
                    System.out.println("file: " + fileElem.toString());
                }
                fileElem = null;
            }
            if (newFather != currFather) {
                long startCit = System.currentTimeMillis();
                int fsmRecNo = recordNo;
                if (this.debugLevel > 10) {
                    System.out.println("Update CIT father " + newFather + " recNo=" + fsmRecNo);
                }
                accumCitFSLocTime += System.currentTimeMillis() - startCit;
                currFather = newFather;
            }
            ++recordNo;
        }
        if (this.debugLevel > 0) {
            long temp2 = System.currentTimeMillis();
            this.mergeTime = temp2 - start;
            System.out.println("merge " + this.mergeTime + " millis, CIT updates " + accumCitFSLocTime + ".\nPercent time updating CIT " + (int)((double)accumCitFSLocTime / (double)this.mergeTime * 100.0) + "%");
            System.out.println("\tnewFSM write time " + accumNewFSM + " millis");
            System.out.println("\tWrote " + recordNo + " records");
        }
        this.close();
        if (oldFsm != null) {
            oldFsm.close();
        }
    }

    long getMergeTime() {
        return this.mergeTime;
    }

    private void writeMeta(int mergedSize) throws IOException {
        FatherSonEntry fse = new FatherSonEntry(mergedSize, 1, 0x40000000L);
        fse.write(this.dout);
    }

    private void openFiles() throws TaxonomyIndexerException {
        this.openInputFile();
        this.openOutputFile();
    }

    private void openInputFile() throws TaxonomyIndexerException {
        File target = new File(this.indexDir, fileName);
        if (!target.exists()) {
            this.din = null;
            return;
        }
        FatherSonEntry fse = null;
        try {
            this.din = new DataInputStream(new FileInputStream(target));
            fse = new FatherSonEntry();
            fse.loadEntry(this.din);
        }
        catch (IOException ioe) {
            Message msg = new Message("I0028E.TAXONOMY_FILE_OPEN");
            msg.addArgument(target.getAbsolutePath());
            throw new TaxonomyIndexerException(msg, (Throwable)ioe);
        }
        if (fse.sonLabel != 0x40000000L) {
            Message msg = new Message("I0025E.TAXONOMY_INDEX_META_CORRUPT");
            msg.addArgument(target.getAbsolutePath());
            msg.addArgument(fse.sonLabel);
            msg.addArgument(0x40000000L);
            throw new TaxonomyIndexerException(msg);
        }
        this.fileRecords = fse.fatherOrdinal - 1;
    }

    private void openOutputFile() throws TaxonomyIndexerException {
        File target = new File(this.newIndexDir, fileName);
        try {
            FileOutputStream fos = new FileOutputStream(target);
            BufferedOutputStream bos = new BufferedOutputStream(fos, 0x200000);
            this.dout = new DataOutputStream(bos);
        }
        catch (IOException ioe) {
            Message msg = new Message("I0028E.TAXONOMY_FILE_OPEN");
            msg.addArgument(target.getAbsolutePath());
            throw new TaxonomyIndexerException(msg, (Throwable)ioe);
        }
    }

    public void close() throws IOException {
        if (this.din != null) {
            this.din.close();
        }
        if (this.dout != null) {
            this.dout.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EmptyIterator
    implements Iterator<FatherSonEntry> {
        EmptyIterator() {
        }

        Iterator<FatherSonEntry> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public FatherSonEntry next() {
            return null;
        }

        @Override
        public void remove() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FatherSonMapComparator
    implements Comparator<FatherSonEntry> {
        FatherSonMapComparator() {
        }

        @Override
        public int compare(FatherSonEntry e1, FatherSonEntry e2) {
            FatherSonEntry a = e1;
            FatherSonEntry b = e2;
            if (a.fatherOrdinal < b.fatherOrdinal) {
                return -1;
            }
            if (a.fatherOrdinal > b.fatherOrdinal) {
                return 1;
            }
            if (a.sonOrdinal < b.sonOrdinal) {
                return -1;
            }
            if (a.sonOrdinal > b.sonOrdinal) {
                return 1;
            }
            return 0;
        }
    }
}

