/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.facet.taxi;

import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.facet.SonFatherMap;
import com.ibm.es.nuvo.facet.taxi.FatherSonEntry;
import com.ibm.es.nuvo.facet.taxi.TaxonomyIndexerException;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FatherSonMapReader
implements Iterator<FatherSonEntry> {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private SonFatherMap sonFatherMap;
    public static final String fileName = "FatherSon";
    private RandomAccessFile fatherSonAccessor;
    private DataInputStream din;
    private FatherSonEntry fse = null;
    private final File indexDir;
    static final int reserved = 1;
    private static final long VALID_METADATA = 0x40000000L;
    private int fatherSonSize;
    private int iterRecordsEnd;
    private int iterRecordsStart;

    public FatherSonMapReader(File _indexDir, ReadMode mode) throws TaxonomyIndexerException {
        this.indexDir = _indexDir;
        File target = new File(this.indexDir, fileName);
        try {
            if (mode == ReadMode.SEQUENTIAL) {
                if (!target.exists()) {
                    this.din = null;
                    this.fatherSonSize = 0;
                    return;
                }
                FileInputStream fis = new FileInputStream(target);
                BufferedInputStream bis = new BufferedInputStream(fis, 0x200000);
                this.din = new DataInputStream(bis);
                this.fse = new FatherSonEntry(this.din);
            } else {
                if (!target.exists()) {
                    Message msg = new Message("I0024E.TAXONOMY_FILE_MISSING");
                    msg.addArgument(target.getAbsolutePath());
                    throw new TaxonomyIndexerException(msg);
                }
                this.fatherSonAccessor = new RandomAccessFile(target, "rw");
                this.fse = new FatherSonEntry(this.fatherSonAccessor, 0);
            }
        }
        catch (IOException ioe) {
            Message msg = new Message("I0028E.TAXONOMY_FILE_OPEN");
            msg.addArgument(target.getAbsolutePath());
            throw new TaxonomyIndexerException(msg);
        }
        if (this.fse.sonLabel != 0x40000000L) {
            Message msg = new Message("I0025E.TAXONOMY_INDEX_META_CORRUPT");
            msg.addArgument(target.getAbsolutePath());
            msg.addArgument(this.fse.sonLabel);
            msg.addArgument(0x40000000L);
            throw new TaxonomyIndexerException(msg);
        }
        this.fatherSonSize = this.fse.fatherOrdinal;
    }

    int getFatherOrdinal(int location) throws IOException {
        FatherSonEntry fse1 = this.getEntry(location);
        if (fse1.fatherOrdinal != -1) {
            return fse1.fatherOrdinal;
        }
        return -2;
    }

    int getSonOrdinal(int location) throws IOException {
        FatherSonEntry fse1 = this.getEntry(location);
        if (fse1.fatherOrdinal != -1) {
            return fse1.sonOrdinal;
        }
        return -2;
    }

    long getSonLabelLocation(int location) throws IOException {
        FatherSonEntry fse1 = this.getEntry(location);
        if (fse1.sonOrdinal != -1) {
            return fse1.sonLabel;
        }
        return -2L;
    }

    public long[] getAllChildren(int fatherLocation) throws IOException {
        FatherSonEntry fse1 = this.getEntry(fatherLocation);
        if (fse1.sonOrdinal == -1) {
            return null;
        }
        ArrayList<Long> children = new ArrayList<Long>();
        int ourFather = fse1.fatherOrdinal;
        int local = fatherLocation;
        while (fse1.fatherOrdinal == ourFather) {
            children.add(new Long(fse1.sonOrdinal));
            children.add(new Long(fse1.sonLabel));
            fse1 = this.getEntry(++local);
        }
        long[] ret = new long[children.size()];
        for (int i = 0; i < children.size(); ++i) {
            ret[i] = (Long)children.get(i);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FatherSonEntry getEntry(int location) throws IOException {
        FatherSonMapReader fatherSonMapReader = this;
        synchronized (fatherSonMapReader) {
            this.fse.loadEntry(this.fatherSonAccessor, location);
        }
        return this.fse;
    }

    public void close() throws IOException {
        if (this.fatherSonAccessor != null) {
            this.fatherSonAccessor.close();
        }
        if (this.din != null) {
            this.din.close();
        }
    }

    public SonFatherMap getSonFatherMap() throws IOException {
        if (this.sonFatherMap == null) {
            this.initiateSonFatherMap();
        }
        return this.sonFatherMap;
    }

    public int getFatherSonMapSize() {
        return this.fatherSonSize;
    }

    private void initiateSonFatherMap() throws IOException {
        int mapSize = this.fatherSonSize;
        this.sonFatherMap = new SonFatherMap(mapSize);
        System.out.println("SonFatherMap " + mapSize);
        long start = System.nanoTime();
        for (int i = 1; i < mapSize; ++i) {
            this.fse.loadEntry(this.din);
            if (this.fse.sonOrdinal < 0 || this.fse.fatherOrdinal < 0) {
                System.out.println("Negative son @" + i + " " + this.fse.sonOrdinal + " father " + this.fse.fatherOrdinal);
                throw new IOException("Negative son @" + i + " " + this.fse.sonOrdinal + " father " + this.fse.fatherOrdinal);
            }
            this.sonFatherMap.put(this.fse.sonOrdinal, this.fse.fatherOrdinal);
        }
        this.sonFatherMap.setCategoryDimension();
        long end = System.nanoTime();
        System.out.println("Load Son Father in " + (end - start) / 1000000L + " millis");
        this.din.close();
        this.din = null;
        File target = new File(this.indexDir, fileName);
        this.fatherSonAccessor = new RandomAccessFile(target, "rw");
        this.fse = new FatherSonEntry(this.fatherSonAccessor, 0);
    }

    Iterator<FatherSonEntry> iterator() {
        this.iterRecordsStart = 1;
        this.iterRecordsEnd = this.fatherSonSize + 1;
        return this;
    }

    @Override
    public boolean hasNext() {
        return (this.din != null || this.fatherSonAccessor != null) && this.iterRecordsStart < this.iterRecordsEnd;
    }

    @Override
    public FatherSonEntry next() {
        try {
            ++this.iterRecordsStart;
            if (this.din != null) {
                this.fse.loadEntry(this.din);
            } else {
                this.fse.loadEntry(this.fatherSonAccessor, this.iterRecordsStart);
            }
            return this.fse;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    @Override
    public void remove() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReadMode {
        RANDOM_ACCESS,
        SEQUENTIAL;

    }
}

