/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.facet.taxi;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FatherSonEntry
implements Comparable<FatherSonEntry> {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    int fatherOrdinal;
    int sonOrdinal;
    long sonLabel;
    DataInputStream din;
    public static final int ENTRY_SIZE = 16;
    public static final int EMPTY = -1;

    FatherSonEntry() {
    }

    FatherSonEntry(DataInputStream din) throws IOException {
        this.din = din;
        this.loadEntry(din);
    }

    FatherSonEntry(int _fatherOrdinal, int _sonOrdinal, long _sonLabel) {
        this.fatherOrdinal = _fatherOrdinal;
        this.sonOrdinal = _sonOrdinal;
        this.sonLabel = _sonLabel;
    }

    FatherSonEntry(RandomAccessFile raf, int index) throws IOException {
        this.loadEntry(raf, index);
    }

    public void loadEntry(RandomAccessFile raf, int index) throws IOException {
        int location = index * 16;
        if ((long)(location + 16) > raf.length()) {
            this.setMembers(-1, -1, -1L);
        } else {
            this.seek(raf, location);
            this.setMembers(raf.readInt(), raf.readInt(), raf.readLong());
        }
    }

    public void loadEntrySequential(RandomAccessFile raf, int index) throws IOException {
        int location = index * 16;
        if ((long)(location + 16) > raf.length()) {
            this.setMembers(-1, -1, -1L);
        } else {
            this.setMembers(raf.readInt(), raf.readInt(), raf.readLong());
        }
    }

    public void loadEntry(DataInputStream din1) throws IOException {
        this.setMembers(din1.readInt(), din1.readInt(), din1.readLong());
    }

    void seekStart(RandomAccessFile raf) throws IOException {
        int location = 16;
        this.seek(raf, location);
    }

    private void seek(RandomAccessFile raf, int where) throws IOException {
        raf.seek(where);
    }

    private void setMembers(int _fatherOrdinal, int _sonOrdinal, long _sonLabel) {
        this.fatherOrdinal = _fatherOrdinal;
        this.sonOrdinal = _sonOrdinal;
        this.sonLabel = _sonLabel;
    }

    public long key() {
        return ((long)this.fatherOrdinal << 32) + (long)this.sonOrdinal;
    }

    public void write(RandomAccessFile raf) throws IOException {
        raf.writeInt(this.fatherOrdinal);
        raf.writeInt(this.sonOrdinal);
        raf.writeLong(this.sonLabel);
    }

    @Override
    public int compareTo(FatherSonEntry other) {
        if (this.key() > other.key()) {
            return 1;
        }
        if (this.key() < other.key()) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return "father=" + this.fatherOrdinal + " son=" + this.sonOrdinal + " sonLabel=" + this.sonLabel;
    }

    public void write(DataOutputStream dout) throws IOException {
        dout.writeInt(this.fatherOrdinal);
        dout.writeInt(this.sonOrdinal);
        dout.writeLong(this.sonLabel);
    }
}

