/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.facet.taxi;

import com.ibm.es.nuvo.facet.taxi.TaxonomyIndexWriter;
import com.ibm.es.nuvo.util.StringUtils;
import com.ibm.es.nuvo.util.Vint8;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.Payload;

public class FacetAnalyzer
extends Analyzer {
    private TaxonomyIndexWriter taxiWriter;
    private FacetFieldTokenStream tokenStream = new FacetFieldTokenStream();
    private String facet_separator;
    private ByteArrayOutputStream baOut = new ByteArrayOutputStream(50);
    private static final int VINT8_BYTES_PER_FACET = 5;
    private static final int MINIMUM_FACETS = 10;

    public FacetAnalyzer(TaxonomyIndexWriter taxiWriter, String facet_separator) {
        this.taxiWriter = taxiWriter;
        this.facet_separator = facet_separator;
    }

    public FacetAnalyzer(TaxonomyIndexWriter taxiWriter) {
        this(taxiWriter, "\uf748");
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        int index;
        String value = null;
        try {
            value = StringUtils.readerToString(reader);
        }
        catch (IOException e) {
            return null;
        }
        String curFacet = value;
        this.baOut.reset();
        do {
            index = curFacet.indexOf(this.facet_separator);
            String path = curFacet;
            if (index >= 0) {
                path = curFacet.substring(0, index);
                curFacet = curFacet.substring(index + 1);
            }
            if (path.length() == 0) continue;
            try {
                int cid = this.taxiWriter.addCategory(path);
                Vint8.encode(cid, this.baOut);
                if (index >= 0) continue;
                break;
            }
            catch (Exception e) {
                System.err.println("addCategory failed " + e.toString());
                e.printStackTrace();
                RuntimeException re = new RuntimeException("FacetAnalyzer.tokenStream(): Cannot addCategory");
                re.setStackTrace(e.getStackTrace());
                re.initCause(e);
                throw re;
            }
        } while (index > 0);
        byte[] payloadData = this.baOut.toByteArray();
        Token token = new Token("fulltree", 0, 0);
        token.setPayload(new Payload(payloadData));
        this.tokenStream.setToken(token);
        return this.tokenStream;
    }

    class FacetFieldTokenStream
    extends TokenStream {
        private Token token;

        FacetFieldTokenStream() {
        }

        private void setToken(Token token) {
            this.token = token;
        }

        public Token next() throws IOException {
            if (this.token == null) {
                return null;
            }
            Token t = this.token;
            this.token = null;
            return t;
        }
    }
}

