/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.facet.taxi;

import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.IndexDescriptor;
import com.ibm.es.nuvo.facet.taxi.TaxonomyConstants;
import com.ibm.es.nuvo.facet.taxi.TaxonomyIndexerException;
import com.ibm.es.nuvo.facet.taxi.Utils;
import java.io.File;

public class Deleteable
implements Runnable {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private CollectionConfiguration configuration;
    private boolean verbose = true;

    public Deleteable(CollectionConfiguration cc, boolean verboSe) {
        this.configuration = cc;
        this.verbose = verboSe;
    }

    public void run() {
        String facetDir = this.configuration.getIndexPath(IndexDescriptor.IndexType.Facet);
        IndexDescriptor taxiDescriptor = this.configuration.getIndexDescriptorFor(IndexDescriptor.IndexType.Facet);
        String deleteOldDirs = taxiDescriptor.getProperty("DeleteOldFacetDirectories");
        if (deleteOldDirs != null && !Boolean.parseBoolean(deleteOldDirs)) {
            if (this.verbose) {
                System.out.println("Skipping Delete old directories");
            }
            return;
        }
        File taxonomyRoot = new File(facetDir);
        try {
            int currentGen = Utils.readMetaDataFile(taxonomyRoot);
            if (this.verbose) {
                System.out.println("deleteOldDirectories: " + facetDir + " currentGen is " + currentGen);
            }
            this.deleteOldDirectories(taxonomyRoot, currentGen);
        }
        catch (TaxonomyIndexerException e) {
            if (this.verbose) {
                System.out.println("Failed to read MetaDataFile");
                e.printStackTrace();
            }
            RuntimeException re = new RuntimeException(e.toString());
            re.setStackTrace(e.getStackTrace());
            throw re;
        }
    }

    private void deleteOldDirectories(File startDir, int currentGen) {
        if (!startDir.exists()) {
            System.out.println("No directory: " + startDir.getAbsolutePath());
            return;
        }
        String genDirName = Integer.toString(currentGen);
        File[] contents = startDir.listFiles();
        for (int f = 0; f < contents.length; ++f) {
            File curFile = contents[f];
            String fileName = curFile.getName();
            if (curFile.isDirectory()) {
                if (fileName.equals(genDirName)) {
                    if (!this.verbose) continue;
                    System.out.println("Skipping current gen " + fileName);
                    continue;
                }
                if (!this.numericName(fileName)) continue;
                try {
                    int dirNumber = Integer.parseInt(fileName);
                    if (dirNumber > currentGen) {
                        if (!this.verbose) continue;
                        System.out.println("Skip Next Gen " + dirNumber);
                    }
                }
                catch (NumberFormatException nfe) {}
                continue;
                this.deleteOldFiles(curFile);
                boolean deleted = curFile.delete();
                if (deleted || !this.verbose) continue;
                System.out.println("Failed to delete file " + fileName);
                continue;
            }
            if (!this.verbose) continue;
            System.out.println("Skipping file " + fileName);
        }
        if (this.verbose) {
            System.out.println("Finished deleting old facet dirs");
        }
    }

    private boolean numericName(String fileName) {
        for (int i = 0; i < fileName.length(); ++i) {
            if (Character.isDigit(fileName.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private void deleteOldFiles(File curDir) {
        File[] contents;
        if (this.verbose) {
            System.out.println("DeleteOldFiles " + curDir.toString());
        }
        if ((contents = curDir.listFiles()).length == 0) {
            return;
        }
        String[] taxonomyFiles = TaxonomyConstants.TAXONOMY_FILE_NAME_LIST;
        block0: for (int f = 0; f < contents.length; ++f) {
            File curFile = contents[f];
            if (curFile.isDirectory()) continue;
            String curFileName = curFile.getName();
            for (int taxiFile = 0; taxiFile < taxonomyFiles.length; ++taxiFile) {
                if (!curFileName.equals(taxonomyFiles[taxiFile])) continue;
                boolean deleted = curFile.delete();
                if (deleted || !this.verbose) continue block0;
                System.out.println("Failed to delete file " + curFileName);
                continue block0;
            }
        }
    }
}

