/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.facet.taxi;

import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.facet.taxi.CategoryInfoEntry;
import com.ibm.es.nuvo.facet.taxi.TaxonomyIndexerException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class CategoryInfoTable {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final String fileName = "CategoryInfoTable";
    private static final long VALID_METADATA = 0x40000000L;
    private RandomAccessFile randomAccessFile;
    private final File indexDir;
    private static final int reserved = 1;
    private int categoryInfoSize;
    private CategoryInfoEntryImpl writerCie = new CategoryInfoEntryImpl();
    private CategoryInfoEntryImpl readerCie = new CategoryInfoEntryImpl();
    private int readerOrdinal = -2;

    public CategoryInfoTable(File _indexDir, boolean connectOnly) throws TaxonomyIndexerException {
        this.indexDir = _indexDir;
        this.connectToFile(connectOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeEntry(int Ordinal, int fatherOrdinal, long labelLocation) throws IOException {
        this.writerCie.setCategoryInfoEntry(fatherOrdinal, labelLocation);
        CategoryInfoTable categoryInfoTable = this;
        synchronized (categoryInfoTable) {
            this.writerCie.writeCategoryInfoEntry(this.randomAccessFile, this.location(Ordinal));
        }
    }

    public int getFatherOrdinal(int Ordinal) throws IOException {
        CategoryInfoEntry cie = this.getEntry(Ordinal);
        if (cie == null) {
            return -2;
        }
        return cie.getFatherOrdinal();
    }

    public long getLabelLocation(int Ordinal) throws IOException {
        CategoryInfoEntry cie = this.getEntry(Ordinal);
        if (cie == null) {
            return -2L;
        }
        return cie.getLabelLocation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CategoryInfoEntry getEntry(int Ordinal) throws IOException {
        CategoryInfoTable categoryInfoTable = this;
        synchronized (categoryInfoTable) {
            if (this.readerOrdinal == Ordinal) {
                return this.readerCie;
            }
            this.readerCie.getCategoryInfoEntry(this.randomAccessFile, this.location(Ordinal));
            this.readerOrdinal = Ordinal;
        }
        if (this.readerCie.fatherOrdinal == -1) {
            this.readerOrdinal = -2;
            return null;
        }
        return this.readerCie;
    }

    int location(int Ordinal) {
        return Ordinal - 0 + 1;
    }

    private void connectToFile(boolean mustExist) throws TaxonomyIndexerException {
        File target = new File(this.indexDir, fileName);
        try {
            if (target.exists()) {
                this.randomAccessFile = new RandomAccessFile(target, "rw");
                this.readerCie.getCategoryInfoEntry(this.randomAccessFile, 0);
                if (this.readerCie.labelLocation != 0x40000000L) {
                    Message msg = new Message("I0025E.TAXONOMY_INDEX_META_CORRUPT");
                    msg.addArgument(target);
                    msg.addArgument(this.readerCie.labelLocation);
                    msg.addArgument(0x40000000L);
                    throw new TaxonomyIndexerException(msg);
                }
                this.categoryInfoSize = this.readerCie.fatherOrdinal;
            } else {
                if (mustExist) {
                    Message msg = new Message("I0024E.TAXONOMY_FILE_MISSING");
                    msg.addArgument(target.getAbsolutePath());
                    throw new TaxonomyIndexerException(msg);
                }
                this.createNewFile();
            }
        }
        catch (IOException ioe) {
            Message msg = new Message("I0028E.TAXONOMY_FILE_OPEN");
            msg.addArgument(target.getAbsolutePath());
            throw new TaxonomyIndexerException(msg, (Throwable)ioe);
        }
    }

    private void createNewFile() throws IOException {
        File target = new File(this.indexDir, fileName);
        target.createNewFile();
        this.randomAccessFile = new RandomAccessFile(target, "rw");
        this.categoryInfoSize = 1;
        CategoryInfoEntryImpl cie = new CategoryInfoEntryImpl(this.categoryInfoSize, 0x40000000L);
        cie.writeCategoryInfoEntry(this.randomAccessFile, 0);
    }

    public void close() throws IOException {
        this.randomAccessFile.close();
    }

    class CategoryInfoEntryImpl
    implements CategoryInfoEntry {
        int fatherOrdinal;
        long labelLocation;
        public static final int ENTRY_SIZE = 12;
        public static final int EMPTY = -1;
        static final int fatherOffset = 0;
        static final int labelLocationOffset = 4;

        CategoryInfoEntryImpl() {
        }

        CategoryInfoEntryImpl(int _fatherOrdinal, long _labelLocation) {
            this.setCategoryInfoEntry(_fatherOrdinal, _labelLocation);
        }

        void setCategoryInfoEntry(int _fatherOrdinal, long _labelLocation) {
            this.fatherOrdinal = _fatherOrdinal;
            this.labelLocation = _labelLocation;
        }

        CategoryInfoEntryImpl(RandomAccessFile raf, int index) throws IOException {
            this.getCategoryInfoEntry(raf, index);
        }

        private void getCategoryInfoEntry(RandomAccessFile raf, int index) throws IOException {
            int location = index * 12;
            if ((long)(location + 12) > raf.length()) {
                this.fatherOrdinal = -1;
                this.labelLocation = -1L;
            } else {
                raf.seek(location);
                this.fatherOrdinal = raf.readInt();
                this.labelLocation = raf.readLong();
            }
        }

        public void writeCategoryInfoEntry(RandomAccessFile raf, int index) throws IOException {
            int location = index * 12;
            raf.seek(location);
            raf.writeInt(this.fatherOrdinal);
            raf.writeLong(this.labelLocation);
        }

        public int getFatherOrdinal() {
            return this.fatherOrdinal;
        }

        public long getLabelLocation() {
            return this.labelLocation;
        }
    }
}

