/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.facet.demo;

import com.ibm.es.nuvo.facet.demo.BookRecord;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.zip.GZIPInputStream;

public class CollectionReader {
    BufferedReader in;
    LinkedList<File> fileQueue;

    public CollectionReader(File file) throws IOException {
        if (!file.isDirectory()) {
            this.in = new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(new FileInputStream(file)), "ISO-8859-1"));
            this.fileQueue = new LinkedList();
        } else {
            File[] fileList = file.listFiles();
            this.fileQueue = new LinkedList();
            for (int i = 0; i < fileList.length; ++i) {
                this.fileQueue.add(fileList[i]);
            }
            this.nextFile();
        }
    }

    public boolean nextFile() throws UnsupportedEncodingException, FileNotFoundException, IOException {
        while (!this.fileQueue.isEmpty()) {
            File nextFile = this.fileQueue.getFirst();
            this.fileQueue.removeFirst();
            System.err.println();
            if (nextFile.getName().startsWith(".")) {
                System.err.println("Ignoring hidden file " + nextFile.getPath());
                continue;
            }
            try {
                this.in = new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(new FileInputStream(nextFile)), "ISO-8859-1"));
                System.err.println("Reading from file " + nextFile.getPath());
                return true;
            }
            catch (IOException e) {
                System.err.println("Ignoring non-gzipped file " + nextFile.getPath());
            }
        }
        return false;
    }

    public BookRecord next() throws IOException {
        String line;
        while (true) {
            if ((line = this.in.readLine()) == null) {
                this.in.close();
                if (this.nextFile()) continue;
                return null;
            }
            if (line.startsWith("isbn: ")) break;
        }
        BookRecord ret = new BookRecord();
        ret.setIsbn(line.substring(6));
        while ((line = this.in.readLine()) != null) {
            if (line.equals("")) {
                ret.setReviews(this.in.readLine());
                break;
            }
            if (line.startsWith("salesrank: ")) {
                ret.setSalesrank(line.substring(11));
                continue;
            }
            if (line.startsWith("author: ")) {
                ret.addAuthor(line.substring(8));
                continue;
            }
            if (line.startsWith("price: ")) {
                ret.setPrice(line.substring(7));
                continue;
            }
            if (line.startsWith("pages: ")) {
                ret.setPages(line.substring(7));
                continue;
            }
            if (line.startsWith("grams: ")) {
                ret.setGrams(line.substring(7));
                continue;
            }
            if (line.startsWith("date: ")) {
                ret.setDate(line.substring(6));
                continue;
            }
            if (line.startsWith("binding: ")) {
                ret.setBinding(line.substring(9));
                continue;
            }
            if (line.startsWith("publisher: ")) {
                ret.setPublisher(line.substring(11));
                continue;
            }
            if (line.startsWith("rating: ")) {
                ret.setRating(line.substring(8));
                continue;
            }
            if (line.startsWith("title: ")) {
                ret.setTitle(line.substring(7));
                continue;
            }
            if (line.startsWith("category: ")) {
                ret.addCategory(line.substring(10));
                continue;
            }
            if (line.startsWith("subject: ")) {
                ret.addSubject(line.substring(9));
                continue;
            }
            System.err.println("unrecognized line: " + line);
        }
        return ret;
    }
}

