/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.facet;

import com.ibm.es.nuvo.facet.CatId;
import com.ibm.es.nuvo.facet.Constraint;
import com.ibm.es.nuvo.facet.ConstraintImpl;
import com.ibm.es.nuvo.facet.FacetSet;
import com.ibm.es.nuvo.facet.FacetSetImpl;
import com.ibm.es.nuvo.facet.OrdinalPath;
import com.ibm.es.nuvo.facet.QualifiedCategory;
import com.ibm.es.nuvo.facet.TopWithOverflow;
import com.ibm.es.nuvo.facet.WorkingFacet;
import com.ibm.es.nuvo.facet.WorkingFacetRepository;
import com.ibm.es.nuvo.facet.taxi.TaxonomyIndexReader;
import com.ibm.es.nuvo.facet.taxi.TaxonomyIndexerException;
import java.io.IOException;
import java.util.Iterator;

public class WorkingQC {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private OrdinalPath ordinalPath;
    private int indexInQualifiedCategories;
    private int depth;
    private QualifiedCategory qualifiedCategory;
    private WorkingFacetRepository _workingFacets;
    private WorkingFacet selfFacet;
    private double[] expressionValues;
    private boolean expressionValuesAreValid;
    private OrdinalPath interestingDewey;
    private int depthOfSplit;
    private static final int DEPTH_MODE_DESCENDANTS = Integer.MAX_VALUE;

    public WorkingQC(QualifiedCategory qc, TaxonomyIndexReader TaxonomyIndexReader2, int iIQCs) throws TaxonomyIndexerException {
        this.ordinalPath = TaxonomyIndexReader2.getOrdinalPath(new CatId(qc.getCategoryInfo().getID()));
        this.qualifiedCategory = qc;
        this.indexInQualifiedCategories = iIQCs;
        this.depth = qc.getDepthMode();
        if (this.depth == Integer.MAX_VALUE) {
            this.depth -= this.ordinalPath.getNumOfComponents() + 5;
        }
        this.selfFacet = new WorkingFacet(this.ordinalPath);
    }

    public void initiateWorkingFacetRepository(int initialSize, int[] categoryAssociatedCategories) {
        this._workingFacets = new WorkingFacetRepository(initialSize, categoryAssociatedCategories);
    }

    public int getDepth() {
        return this.depth;
    }

    public OrdinalPath getOrdinalPath() {
        return this.ordinalPath;
    }

    public int getIndexInQualifiedCategories() {
        return this.indexInQualifiedCategories;
    }

    public QualifiedCategory getQualifiedCategory() {
        return this.qualifiedCategory;
    }

    public WorkingFacetRepository getWorkingFacets() {
        return this._workingFacets;
    }

    public WorkingFacet getSelfFacet() {
        return this.selfFacet;
    }

    public boolean getExpressionValuesAreValid() {
        return this.expressionValuesAreValid;
    }

    public void setExpressionValuesAreValid(boolean b) {
        this.expressionValuesAreValid = b;
    }

    public void setInterestingPath(OrdinalPath d) {
        this.interestingDewey = d;
    }

    public OrdinalPath getInterestingPath() {
        return this.interestingDewey;
    }

    public void setDepthOfSplit(int d) {
        this.depthOfSplit = d;
    }

    public int getDepthOfSplit() {
        return this.depthOfSplit;
    }

    public double[] getExpressionValues() {
        return this.expressionValues;
    }

    public void fillAFacetSet(FacetSet fSet, TaxonomyIndexReader TaxonomyIndexReader2) throws IOException {
        if (this.depth != -1) {
            this.screenInTheFacets(fSet, -1, TaxonomyIndexReader2);
            ((FacetSetImpl)fSet).setCountStatus(0);
        } else if (-1 == this.depthOfSplit) {
            this.screenInTheFacets(fSet, this.ordinalPath.getNumOfComponents() + 1, TaxonomyIndexReader2);
            ((FacetSetImpl)fSet).setCountStatus(1);
        } else {
            this.screenInTheFacets(fSet, this.depthOfSplit, TaxonomyIndexReader2);
            if (this.depthOfSplit == this.ordinalPath.getNumOfComponents() + 1) {
                ((FacetSetImpl)fSet).setCountStatus(0);
            } else {
                ((FacetSetImpl)fSet).setCountStatus(-1);
            }
        }
    }

    private void screenInTheFacets(FacetSet fSet, int depthConstraint, TaxonomyIndexReader TaxonomyIndexReader2) throws IOException {
        BestFacets bestFacets;
        Constraint constraint = this.qualifiedCategory.getContraint();
        int nBest = Math.min(constraint.getMaxReturnedSubCategories(), this._workingFacets.size());
        WorkingFacet other = null;
        switch (constraint.getMode()) {
            case 0: {
                bestFacets = constraint.isSubCategoriesInAscendingOrder() ? new BestFacetsSmallestCount(nBest, other) : new BestFacetsLargestCount(nBest, other);
                WFFilter wfFilter = new WFFilterCount(constraint);
                break;
            }
            case -1: {
                bestFacets = constraint.isSubCategoriesInAscendingOrder() ? new BestFacetsSmallestRelevance(nBest, other) : new BestFacetsLargestRelevance(nBest, other);
                WFFilter wfFilter = new WFFilterRelevance(constraint);
                break;
            }
            case 1: {
                bestFacets = constraint.isSubCategoriesInAscendingOrder() ? new BestFacetsSmallestCount(nBest, other) : new BestFacetsLargestCount(nBest, other);
                int totalCount = 0;
                WorkingFacet wf = null;
                Iterator<WorkingFacet> iter = this._workingFacets.iterator();
                while (iter.hasNext()) {
                    wf = iter.next();
                    int depthOfWF = wf.getDepth();
                    if (depthOfWF == this.ordinalPath.getNumOfComponents() || depthConstraint != -1 && depthOfWF != depthConstraint) continue;
                    totalCount += wf.getCounter();
                }
                WFFilter wfFilter = new WFFilterPercent(constraint, totalCount);
                break;
            }
            default: {
                bestFacets = null;
                WFFilter wfFilter = null;
            }
        }
        WorkingFacet wf = null;
        Iterator<WorkingFacet> iter = this._workingFacets.iterator();
        while (iter.hasNext()) {
            wf = iter.next();
            int depthOfWF = wf.getDepth();
            if (depthOfWF == this.ordinalPath.getNumOfComponents()) {
                ((FacetSetImpl)fSet).setTotalCount(wf.getCounter());
                continue;
            }
            if (depthConstraint != -1 && depthOfWF != depthConstraint) continue;
            bestFacets.add(wf);
        }
        WorkingFacet[] wfs = new WorkingFacet[bestFacets.size()];
        for (int pos = wfs.length - 1; pos >= 0; --pos) {
            wfs[pos] = (WorkingFacet)bestFacets.pop();
        }
        for (int i = 0; i < wfs.length; ++i) {
            ((FacetSetImpl)fSet).addFacet(wfs[i].yieldAFacet(TaxonomyIndexReader2, true));
        }
        ((FacetSetImpl)fSet).setOtherFacet(other.yieldAFacet(TaxonomyIndexReader2, false));
        ((FacetSetImpl)fSet).setSelfFacet(this.selfFacet.yieldAFacet(TaxonomyIndexReader2, true));
    }

    private static class WFFilterRelevance
    extends WFFilter {
        ConstraintImpl c;

        public WFFilterRelevance(Constraint c) {
            this.c = (ConstraintImpl)c;
        }

        public boolean pass(WorkingFacet wf) {
            return this.c.isWithinLimits(wf.getRelevance());
        }
    }

    private static class WFFilterPercent
    extends WFFilter {
        ConstraintImpl c;
        double multiplier;

        public WFFilterPercent(Constraint c, double totalCount) {
            this.c = (ConstraintImpl)c;
            this.multiplier = 100.0 / totalCount;
        }

        public boolean pass(WorkingFacet wf) {
            return this.c.isWithinLimits((double)wf.getCounter() * this.multiplier);
        }
    }

    private static class WFFilterCount
    extends WFFilter {
        ConstraintImpl c;

        public WFFilterCount(Constraint c) {
            this.c = (ConstraintImpl)c;
        }

        public boolean pass(WorkingFacet wf) {
            return this.c.isWithinLimits(wf.getCounter());
        }
    }

    private static abstract class WFFilter {
        private WFFilter() {
        }

        public abstract boolean pass(WorkingFacet var1);
    }

    public static class BestFacetsSmallestRelevance
    extends BestFacets {
        public BestFacetsSmallestRelevance(int size, WorkingFacet other) {
            super(size, other);
        }

        protected boolean lessThan(Object a, Object b) {
            return ((WorkingFacet)a).getRelevance() > ((WorkingFacet)b).getRelevance();
        }
    }

    public static class BestFacetsLargestRelevance
    extends BestFacets {
        public BestFacetsLargestRelevance(int size, WorkingFacet other) {
            super(size, other);
        }

        protected boolean lessThan(Object a, Object b) {
            return ((WorkingFacet)a).getRelevance() < ((WorkingFacet)b).getRelevance();
        }
    }

    public static class BestFacetsSmallestCount
    extends BestFacets {
        public BestFacetsSmallestCount(int size, WorkingFacet other) {
            super(size, other);
        }

        protected boolean lessThan(Object a, Object b) {
            return ((WorkingFacet)a).getCounter() > ((WorkingFacet)b).getCounter();
        }
    }

    public static class BestFacetsLargestCount
    extends BestFacets {
        public BestFacetsLargestCount(int size, WorkingFacet other) {
            super(size, other);
        }

        protected boolean lessThan(Object a, Object b) {
            return ((WorkingFacet)a).getCounter() < ((WorkingFacet)b).getCounter();
        }
    }

    private static abstract class BestFacets
    extends TopWithOverflow {
        WorkingFacet other;

        public BestFacets(int size, WorkingFacet other) {
            this.initialize(size);
            this.other = other;
        }

        public void add(WorkingFacet wf) {
            Object removed = this.insertWithOverflow(wf);
            if (removed != null) {
                this.other.visitByOtherWorkingFacet((WorkingFacet)removed);
            }
        }
    }
}

