/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.facet;

import com.ibm.es.nuvo.facet.CountPriorityQueue;
import com.ibm.es.nuvo.facet.FacetMap;
import com.ibm.es.nuvo.facet.FacetNode;
import com.ibm.es.nuvo.facet.SonFatherMap;
import com.ibm.es.nuvo.facet.taxi.TaxonomyIndexReader;
import com.ibm.es.nuvo.facet.taxi.TaxonomyIndexerException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkingFacetCounter {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private int constraint_CatId;
    private TaxonomyIndexReader taxiReader;
    private SonFatherMap sfm;
    private int maxDepth;
    private FacetMap facetMap = new FacetMap();
    private ArrayList<FacetNode> roots;
    private int[] tempPath;
    private boolean debug;
    private int docId;
    private int matchedDepth;
    private int nodeCount;
    private String category;
    public static final int MAXIMUM_COUNT_DEPTH = 256;
    private int[] map;
    private int[] depth;
    public int dimension;

    public WorkingFacetCounter(TaxonomyIndexReader taxiReader, int catId) throws TaxonomyIndexerException {
        this.constraint_CatId = catId;
        this.taxiReader = taxiReader;
        this.sfm = this.taxiReader.getSonFatherMap();
        this.map = this.sfm._map;
        this.depth = this.sfm._depth;
        this.dimension = this.sfm.dimension[this.constraint_CatId];
        this.matchedDepth = -1;
        this.debug = this.taxiReader.debug();
    }

    ArrayList<FacetNode> getRoots() {
        return this.roots;
    }

    public int getCatId() {
        return this.constraint_CatId;
    }

    public WorkingFacetCounter(TaxonomyIndexReader taxiReader, String category) throws TaxonomyIndexerException {
        this.category = category;
        if (taxiReader != null) {
            this.constraint_CatId = taxiReader.getOrdinal(category);
            if (this.constraint_CatId == -2) {
                throw new TaxonomyIndexerException("Unknown category " + category);
            }
        } else {
            this.constraint_CatId = 0;
        }
        this.taxiReader = taxiReader;
        this.sfm = this.taxiReader.getSonFatherMap();
        this.map = this.sfm._map;
        this.depth = this.sfm._depth;
        this.dimension = this.sfm.dimension[this.constraint_CatId];
        this.matchedDepth = -1;
    }

    public boolean incrementCounters(int payloadCatId, int countDepth, int docid) {
        if (countDepth < 0) {
            countDepth = 256;
        }
        this.maxDepth = countDepth;
        this.docId = docid;
        if (this.tempPath == null) {
            this.tempPath = new int[countDepth + 1];
        }
        boolean counted = this.incrementParentsLoop2(payloadCatId);
        return counted;
    }

    private boolean incrementParentsLoop2(int myCatId) {
        int cid = myCatId;
        int tplen = this.tempPath.length;
        int[] tp = this.tempPath;
        int matchI = -1;
        int numVisited = 0;
        int i = 0;
        while (cid > 0) {
            matchI = i;
            tp[i++] = cid;
            if (i >= tplen) {
                i = 0;
            }
            ++numVisited;
            if (cid == this.constraint_CatId) break;
            cid = this.map[cid];
        }
        if (cid != this.constraint_CatId) {
            return false;
        }
        int myDepth = this.matchedDepth = this.depth[cid];
        int countedDepth = 0;
        FacetNode node = null;
        while (numVisited-- > 0 && countedDepth++ <= this.maxDepth) {
            node = this.addAndIncrement(cid, myDepth, node);
            if (--matchI < 0) {
                matchI = tplen - 1;
            }
            cid = tp[matchI];
            myDepth = this.depth[cid];
        }
        return true;
    }

    private FacetNode addAndIncrement(int cid, int countDepth, FacetNode fatherNode) {
        FacetNode node = this.facetMap.getFacet(cid);
        if (node != null) {
            node.increment(this.docId);
            return node;
        }
        node = new FacetNode(cid, countDepth, fatherNode, this.docId);
        this.facetMap.addFacet(node);
        if (fatherNode == null) {
            if (this.roots == null) {
                this.roots = new ArrayList();
            }
            this.roots.add(node);
        }
        return node;
    }

    public void postProcess(int maxCount) throws IOException {
        this.nodeCount = 0;
        CountPriorityQueue cpq = new CountPriorityQueue(maxCount);
        Iterator<FacetNode> iter = this.getCountedRoots();
        while (iter != null && iter.hasNext()) {
            cpq.insert(iter.next());
        }
        for (int i = cpq.size(); i > 0; --i) {
            FacetNode val = (FacetNode)cpq.pop();
            this.nodeCount += FacetNode.postProcess(this.taxiReader, val, maxCount);
        }
    }

    public Iterator<FacetNode> getCountedRoots() {
        if (this.roots == null) {
            return null;
        }
        return this.roots.iterator();
    }

    public String getCategory() {
        return this.category;
    }

    public void display(StringBuffer sb) {
        Iterator<FacetNode> iter = this.getCountedRoots();
        int i = 0;
        while (iter != null && iter.hasNext() && ++i <= 10) {
            FacetNode root = iter.next();
            FacetNode.display(root, "", sb);
        }
    }

    public int summarize() {
        System.out.println(this.category + " " + this.nodeCount + " count nodes");
        return this.nodeCount;
    }

    public boolean isInDimension(int payloadCatId) {
        boolean inDim;
        boolean bl = inDim = this.dimension == this.sfm.getDimension(payloadCatId);
        if (this.debug) {
            if (inDim) {
                System.out.println("count cat " + this.constraint_CatId + " dimension " + this.dimension + " IS parent to cat " + payloadCatId + "=dim " + this.sfm.getDimension(payloadCatId));
            } else {
                System.out.println("count cat " + this.constraint_CatId + " dimension " + this.dimension + " NOT parent to cat " + payloadCatId + "=dim " + this.sfm.getDimension(payloadCatId));
            }
        }
        return inDim;
    }
}

