/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.facet;

import com.ibm.es.nuvo.facet.CategoryInfo;
import com.ibm.es.nuvo.facet.CategoryInfoImpl;
import com.ibm.es.nuvo.facet.Facet;
import com.ibm.es.nuvo.facet.FacetImpl;
import com.ibm.es.nuvo.facet.OrdinalPath;
import com.ibm.es.nuvo.facet.taxi.TaxonomyIndexReader;
import java.io.IOException;

public class WorkingFacet {
    private static final CategoryInfo OTHER_CATEGORY_INFO = new CategoryInfoImpl("other ID", "other label");
    private int counter;
    private double score;
    private int _identifierCategory;
    private int _depth;

    public WorkingFacet(OrdinalPath path, int identifierCategoryIndex) {
        this.counter = 0;
        this.score = 0.0;
        this._depth = identifierCategoryIndex + 1;
        this._identifierCategory = path.get(identifierCategoryIndex);
    }

    public WorkingFacet(OrdinalPath path) {
        this(path, path.getNumOfComponents() - 1);
    }

    public WorkingFacet(int ordinal) {
        this._identifierCategory = ordinal;
    }

    public void visitByOtherWorkingFacet(WorkingFacet wf) {
        this.counter += wf.counter;
        this.score += wf.score;
    }

    public int getCounter() {
        return this.counter;
    }

    public double getScore() {
        return this.score;
    }

    public double getRelevance() {
        return this.score;
    }

    public Facet yieldAFacet(TaxonomyIndexReader taxonomyIndex, boolean createCategoryInfo) throws IOException {
        FacetImpl facet = null;
        CategoryInfo categoryInfo = null;
        if (createCategoryInfo) {
            try {
                categoryInfo = taxonomyIndex.getCategoryInfoByOrdinal(this._identifierCategory);
            }
            catch (IOException ioe) {
                System.err.println("could not get CategoryInfo for category ordinal " + this._identifierCategory + " " + ioe.toString());
                throw ioe;
            }
        } else {
            categoryInfo = OTHER_CATEGORY_INFO;
        }
        facet = new FacetImpl(categoryInfo);
        facet.setCount(this.counter);
        facet.setRelevanceScore(this.getRelevance());
        return facet;
    }

    public int getIdentifierCategory() {
        return this._identifierCategory;
    }

    public int getDepth() {
        return this._depth;
    }
}

