/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.facet;

import com.ibm.es.nuvo.facet.CountComparator;
import com.ibm.es.nuvo.facet.DecreasingDocFreqComparator;
import com.ibm.es.nuvo.facet.DocFreqComparator;
import com.ibm.es.nuvo.facet.TakmiCounter;
import com.ibm.es.nuvo.facet.TakmiCounterPriorityQueue;
import com.ibm.es.nuvo.facet.taxi.TaxonomyIndexerException;
import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;

public class TakmiCounting {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private String category;
    private IndexReader indexReader;
    private TakmiCounterPriorityQueue countPQ;

    public TakmiCounting(IndexReader indexReader, String category) throws IOException, TaxonomyIndexerException {
        this.indexReader = indexReader;
        this.category = category;
    }

    public void count(int[] docIds, int numDocs, int topKtoCount, int numResults, double lowThreasholdPercent) throws IOException {
        DocFreqComparator dfc = new DocFreqComparator();
        TakmiCounterPriorityQueue docFreqPQ = new TakmiCounterPriorityQueue(topKtoCount, dfc);
        this.discoverSubCategoriesFromRoot(docFreqPQ);
        int size = docFreqPQ.size();
        TakmiCounter[] tcArray = new TakmiCounter[size];
        for (int i = 0; i < size; ++i) {
            TakmiCounter tc;
            tcArray[i] = tc = (TakmiCounter)docFreqPQ.pop();
        }
        Arrays.sort(tcArray, new DecreasingDocFreqComparator());
        long start = System.nanoTime();
        System.out.println("docfreqpq size " + size + " numDocs " + numDocs);
        CountComparator countComparator = new CountComparator(CountComparator.SortOrder.PRIORITY_HIGH);
        this.countPQ = new TakmiCounterPriorityQueue(numResults, countComparator);
        int minCount = Integer.MAX_VALUE;
        int maxCount = 0;
        for (int res = 0; res < tcArray.length; ++res) {
            TakmiCounter tc = tcArray[res];
            Term term = new Term("_categories", tc.category);
            TermDocs docs = this.indexReader.termDocs(term);
            if (!docs.next()) break;
            int count = 0;
            for (int d = 0; d < numDocs; ++d) {
                int docId = docIds[d];
                while (docId > docs.doc() && docs.next()) {
                }
                if (docId != docs.doc()) continue;
                ++count;
            }
            tc.setCount(count);
            if (count > maxCount) {
                maxCount = count;
            }
            double corr = tc.getCorrelation();
            System.out.println("correlation " + corr + " for " + tc.category);
            if (corr < lowThreasholdPercent) {
                System.out.println("corr dropped below " + Double.toString(lowThreasholdPercent * 100.0) + "%");
                break;
            }
            this.countPQ.insert(tc);
            TakmiCounter min = (TakmiCounter)this.countPQ.top();
            if (min.count < minCount) {
                minCount = min.count;
            }
            if (!((double)minCount < (double)maxCount * lowThreasholdPercent)) continue;
            System.out.println("minCountn " + minCount + " < maxCount " + maxCount + " * " + Double.toString(lowThreasholdPercent * 100.0) + "%");
            break;
        }
        long timer = System.nanoTime() - start;
        System.out.println("time to count " + timer / 1000000L);
    }

    private void discoverSubCategoriesFromRoot(TakmiCounterPriorityQueue docFreqPQ) throws IOException {
        Term t1;
        String childPath;
        long start = System.currentTimeMillis();
        Term term = new Term("_categories", this.category);
        TermEnum termEnum = this.indexReader.terms(term);
        int fatherPathLength = this.countPathLength(this.category);
        int maxDF = 0;
        String maxCat = null;
        int i = 0;
        while (termEnum.next() && (childPath = (t1 = termEnum.term()).text()).startsWith(this.category)) {
            int myPathLength = this.countPathLength(childPath);
            if (myPathLength <= fatherPathLength + 1) {
                if (termEnum.docFreq() > maxDF) {
                    maxDF = termEnum.docFreq();
                    maxCat = childPath;
                }
                TakmiCounter tc = new TakmiCounter(childPath, termEnum.docFreq());
                docFreqPQ.insert(tc);
            }
            ++i;
        }
        long end = System.currentTimeMillis();
        System.out.println("docFreqPQ size " + docFreqPQ.size() + " maxDF " + maxDF + " maxCat " + maxCat);
        System.out.println("time to discover " + (end - start));
    }

    private final int countPathLength(String path) {
        int n = 1;
        if (path == null) {
            return n;
        }
        int index = 0;
        while ((index = path.indexOf("\uf749", index)) > 0) {
            ++n;
            ++index;
        }
        return n;
    }

    public void display(StringBuffer sb) {
        TakmiCounter tc;
        int i;
        int size = this.countPQ.size();
        TakmiCounter[] tcArray = new TakmiCounter[size];
        for (i = 0; i < size; ++i) {
            tcArray[i] = tc = (TakmiCounter)this.countPQ.pop();
        }
        Arrays.sort(tcArray, new CountComparator(CountComparator.SortOrder.PRIORITY_HIGH));
        for (i = 0; i < size; ++i) {
            tc = tcArray[i];
            sb.append(tc.category);
            sb.append("(");
            sb.append(tc.count);
            sb.append(") df=");
            sb.append(tc.docFreq);
            int corrpercent = (int)(tc.getCorrelation() * 100.0);
            sb.append(", correlation=");
            sb.append(corrpercent);
            sb.append("%\n");
        }
        System.out.println("countPQ size " + size);
    }
}

