/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.facet;

import java.io.IOException;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SonFatherMap
implements Iterator<Integer> {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public int[] _map;
    public int[] _depth;
    public int[] dimension;
    private int iterIndex;

    public SonFatherMap(int requiredCapacity) {
        this._map = new int[requiredCapacity];
        for (int i = 0; i < this._map.length; ++i) {
            this._map[i] = -1;
        }
        this._depth = new int[requiredCapacity];
        this._depth[0] = -1;
        this.dimension = new int[requiredCapacity];
        this.dimension[0] = -1;
        this.iterIndex = 1;
    }

    public void put(int sonOrdinal, int fatherOrdinal) throws IOException {
        try {
            if (sonOrdinal < 0 || fatherOrdinal < 0) {
                throw new IOException("SonFatherMap.put(): Negative son/father " + sonOrdinal + " father " + fatherOrdinal);
            }
            this._map[sonOrdinal] = fatherOrdinal;
            this._depth[sonOrdinal] = this._depth[fatherOrdinal] + 1;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
            throw new IOException("ArrayIndexOutOfBoundsException SonFatherMap.put() Negative son/father " + sonOrdinal + " father " + fatherOrdinal + " " + e.toString());
        }
    }

    public void setCategoryDimension() {
        for (int son = 1; son < this._map.length; ++son) {
            int dim;
            if (son < 0) continue;
            int father = son;
            do {
                dim = father;
            } while ((father = this.getFather(father)) > 0);
            if (dim == 0) {
                dim = son;
            }
            this.dimension[son] = dim;
        }
    }

    public final int getFather(int sonOrdinal) {
        if (sonOrdinal < 0 || sonOrdinal >= this._map.length) {
            return -2;
        }
        return this._map[sonOrdinal];
    }

    public boolean isEmpty() {
        return this._map.length == 0;
    }

    public int size() {
        return this._map.length;
    }

    public final int getDepth(int ordinal) {
        if (ordinal < 0 || ordinal >= this._depth.length) {
            return -2;
        }
        return this._depth[ordinal];
    }

    @Override
    public boolean hasNext() {
        while (this.iterIndex < this._map.length) {
            if (this._map[this.iterIndex] < 0) {
                return true;
            }
            ++this.iterIndex;
        }
        return false;
    }

    @Override
    public Integer next() {
        return new Integer(this.iterIndex++);
    }

    public final int getDimension(int payloadCatId) {
        if (payloadCatId < 0 || payloadCatId > this.dimension.length) {
            return -2;
        }
        return this.dimension[payloadCatId];
    }

    @Override
    public void remove() {
    }
}

