/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.facet;

import com.ibm.es.nuvo.facet.OrdinalPath;
import com.ibm.es.nuvo.facet.SonFatherMap;
import com.ibm.es.nuvo.facet.WorkingQC;
import com.ibm.es.nuvo.facet.taxi.TaxonomyIndexReader;
import com.ibm.es.nuvo.facet.taxi.TaxonomyIndexerException;

public final class OrdinalPathDeserializer
extends OrdinalPath {
    private static final int DEPTH_SHIFT = 23;
    private static final int DEPTH_INCREMENT = 0x800000;
    private static final int IRRELEVANT_STATUS = 0x7FFFFF;
    private byte[] bytes;
    private int bytesRead;
    private SonFatherMap _sonFatherMap;
    private int[] _ordinalStatus;
    private int[] _qualifiedCategoryAssociatedCategories;
    public int sharedPrefixLen;
    private boolean _newDoc;

    public OrdinalPathDeserializer(int size, TaxonomyIndexReader taxiReader) throws TaxonomyIndexerException {
        super(size);
        this._sonFatherMap = taxiReader.getSonFatherMap();
        this._ordinalStatus = new int[this._sonFatherMap.size()];
        this._qualifiedCategoryAssociatedCategories = new int[this._sonFatherMap.size()];
        this._ordinalStatus[0] = 0x7FFFFF;
    }

    public OrdinalPathDeserializer(WorkingQC[] qualifiedCategories, TaxonomyIndexReader taxiReader) throws TaxonomyIndexerException {
        this(255, taxiReader);
        this.preProccesing(qualifiedCategories);
    }

    private void preProccesing(WorkingQC[] qualifiedCategories) {
        int i;
        OrdinalPath qcPath = null;
        int[] relativeOrdinalGenerator = new int[qualifiedCategories.length];
        for (i = qualifiedCategories.length - 1; i >= 0; --i) {
            qcPath = qualifiedCategories[i].getOrdinalPath();
            int ordinalIndex = qcPath.components[qcPath.numOfComponents - 1];
            int ordinalDepth = qcPath.getNumOfComponents() - 1;
            if ((this._ordinalStatus[ordinalIndex] & 0x7FFFFF) != 0x7FFFFF) {
                this._ordinalStatus[ordinalIndex] = i + 1 + (ordinalDepth << 23);
                for (int j = 0; j < ordinalDepth; ++j) {
                    this._ordinalStatus[qcPath.components[j]] = 0x7FFFFF;
                }
                continue;
            }
            for (int k = qualifiedCategories.length - 1; k > i; --k) {
                OrdinalPath descendentPath = qualifiedCategories[k].getOrdinalPath();
                if (!qcPath.isAPrefixOf(descendentPath)) continue;
                for (int l = descendentPath.numOfComponents - 1; l >= ordinalDepth; --l) {
                    this._ordinalStatus[descendentPath.components[l]] = i + 1 + (l << 23);
                }
            }
        }
        for (i = 1; i < this._sonFatherMap.size(); ++i) {
            int qualifiedCategoryIndex;
            if (this._ordinalStatus[i] == 0) {
                int index = 0;
                try {
                    index = this._sonFatherMap.getFather(i);
                    this._ordinalStatus[i] = this._ordinalStatus[index] + 0x800000;
                }
                catch (ArrayIndexOutOfBoundsException aioob) {
                    System.err.println("IndexOutOfBounds index = " + index + " i=" + i);
                    throw aioob;
                }
            }
            if ((qualifiedCategoryIndex = this._ordinalStatus[i] & 0x7FFFFF) == 0x7FFFFF) continue;
            int n = qualifiedCategoryIndex - 1;
            relativeOrdinalGenerator[n] = relativeOrdinalGenerator[n] + 1;
        }
        for (i = 0; i < qualifiedCategories.length; ++i) {
            int maxRelativeOrdinal = relativeOrdinalGenerator[i] == 0 ? relativeOrdinalGenerator[(this._ordinalStatus[i] & 0x7FFFFF) - 1] : relativeOrdinalGenerator[i];
            qualifiedCategories[i].initiateWorkingFacetRepository(maxRelativeOrdinal, this._qualifiedCategoryAssociatedCategories);
        }
    }

    public void process(byte[] bytes1) {
        this.bytes = bytes1;
        this.bytesRead = 0;
        this._newDoc = true;
    }

    public void process(byte[] bytes1, int startingIndex) {
        this.bytes = bytes1;
        this.bytesRead = startingIndex;
        this._newDoc = true;
    }

    public int fillNext() {
        int ordinal;
        while ((ordinal = this.getNext()) != -1 && ordinal < this._ordinalStatus.length && (this._ordinalStatus[ordinal] & 0x7FFFFF) == 0x7FFFFF) {
        }
        if (ordinal == -1) {
            return -1;
        }
        int depth = this._ordinalStatus[ordinal] >> 23;
        int returnIndex = (this._ordinalStatus[ordinal] & 0x7FFFFF) - 1;
        this.components[depth + 1] = -1;
        this.numOfComponents = depth + 1;
        this.sharedPrefixLen = 0;
        if (this._newDoc) {
            do {
                this.components[depth] = ordinal;
                ordinal = this._sonFatherMap.getFather(ordinal);
            } while (--depth >= 0);
            this._newDoc = false;
        } else {
            do {
                this.components[depth] = ordinal;
                ordinal = this._sonFatherMap.getFather(ordinal);
            } while (--depth >= 0 && this.components[depth] != ordinal);
            this.sharedPrefixLen = depth + 1;
        }
        return returnIndex;
    }

    public int getNext() {
        int ordinal;
        if (this.bytes == null || this.bytesRead == this.bytes.length) {
            return -1;
        }
        if ((this.bytes[this.bytesRead] & 0x80) == 0) {
            ordinal = this.bytes[this.bytesRead];
            ++this.bytesRead;
        } else if ((this.bytes[this.bytesRead] & 0xC0) == 128) {
            ordinal = (this.bytes[this.bytesRead] & 0x7F) << 8 | this.bytes[this.bytesRead + 1] & 0xFF;
            this.bytesRead += 2;
        } else if ((this.bytes[this.bytesRead] & 0xE0) == 192) {
            ordinal = ((this.bytes[this.bytesRead] & 0x3F) << 8 | this.bytes[this.bytesRead + 1] & 0xFF) << 8 | this.bytes[this.bytesRead + 2] & 0xFF;
            this.bytesRead += 3;
        } else if ((this.bytes[this.bytesRead] & 0xF0) == 224) {
            ordinal = (((this.bytes[this.bytesRead] & 0x1F) << 8 | this.bytes[this.bytesRead + 1] & 0xFF) << 8 | this.bytes[this.bytesRead + 2] & 0xFF) << 8 | this.bytes[this.bytesRead + 3] & 0xFF;
            this.bytesRead += 4;
        } else {
            ordinal = (((this.bytes[this.bytesRead + 1] & 0xFF) << 8 | this.bytes[this.bytesRead + 2] & 0xFF) << 8 | this.bytes[this.bytesRead + 3] & 0xFF) << 8 | this.bytes[this.bytesRead + 4] & 0xFF;
            this.bytesRead += 5;
        }
        return ordinal;
    }
}

