/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.facet;

import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.facet.taxi.TaxonomyIndexerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrdinalPath
implements Comparable<OrdinalPath> {
    protected int[] components = null;
    protected int numOfComponents;
    public static final String delimiter = ".";

    public OrdinalPath() {
        this.components = null;
        this.numOfComponents = 0;
    }

    public OrdinalPath(int size_) {
        this.components = new int[size_];
        this.numOfComponents = 0;
    }

    public OrdinalPath(int[] components) throws TaxonomyIndexerException {
        for (int i = 0; i < components.length; ++i) {
            if (components[i] >= 0) continue;
            Message msg = new Message("I0023E.INTERNAL_TAXONOMY_INDEX_ERROR");
            StringBuffer sb = new StringBuffer("Failed at component index: ");
            sb.append(i);
            sb.append(", array contains");
            for (int j = 0; j <= i; ++j) {
                sb.append("[");
                sb.append(j);
                sb.append("]=");
                sb.append(components[i]);
                if (j >= i) continue;
                sb.append(", ");
            }
            msg.addArgument(sb.toString());
            throw new TaxonomyIndexerException(msg);
        }
        this.components = components;
        this.numOfComponents = components.length;
    }

    public int get(int index) {
        if (index >= this.numOfComponents) {
            return -1;
        }
        return this.components[index];
    }

    public int getNumOfComponents() {
        return this.numOfComponents;
    }

    public int getSize() {
        return this.components.length;
    }

    public boolean equals(OrdinalPath dew) {
        if (this.numOfComponents != dew.numOfComponents) {
            return false;
        }
        for (int i = 0; i < this.numOfComponents; ++i) {
            if (this.components[i] == dew.components[i]) continue;
            return false;
        }
        return true;
    }

    public boolean isAPrefixOf(OrdinalPath other) {
        if (this.numOfComponents > other.numOfComponents) {
            return false;
        }
        return this.components[this.numOfComponents - 1] == other.components[this.numOfComponents - 1];
    }

    public int relationCheck(OrdinalPath other, int maximalResult) {
        int j;
        if (this.numOfComponents <= other.numOfComponents) {
            if (this.components[this.numOfComponents - 1] == other.components[this.numOfComponents - 1]) {
                return 0;
            }
            for (j = 0; this.components[j] == other.components[j] && j < this.numOfComponents - 1; ++j) {
            }
            return this.components[j] < other.components[j] ? 1 : maximalResult;
        }
        while (this.components[j] == other.components[j] && j < other.numOfComponents - 1) {
            ++j;
        }
        return this.components[j] < other.components[j] ? 1 : maximalResult;
    }

    public int sharedPrefixLength(OrdinalPath other) {
        int len = this.numOfComponents < other.numOfComponents ? this.numOfComponents : other.numOfComponents;
        for (int i = 0; i < len; ++i) {
            if (this.components[i] == other.components[i]) continue;
            return i;
        }
        return len;
    }

    @Override
    public int compareTo(OrdinalPath o) {
        OrdinalPath other = o;
        int len = this.numOfComponents < other.numOfComponents ? this.numOfComponents : other.numOfComponents;
        for (int i = 0; i < len; ++i) {
            int diff = this.components[i] - other.components[i];
            if (diff == 0) continue;
            return diff;
        }
        if (this.numOfComponents < other.numOfComponents) {
            return -1;
        }
        if (this.numOfComponents > other.numOfComponents) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        if (this.components.length == 0) {
            return new String();
        }
        StringBuffer buf = new StringBuffer(Integer.toString(this.components[0]));
        for (int i = 1; i < this.numOfComponents; ++i) {
            buf.append(delimiter);
            buf.append(Integer.toString(this.components[i]));
        }
        return buf.toString();
    }

    public OrdinalPath(OrdinalPath father, int son) {
        this.numOfComponents = father.components != null ? father.numOfComponents + 1 : 1;
        this.components = new int[this.numOfComponents];
        for (int i = 0; i < this.numOfComponents - 1; ++i) {
            this.components[i] = father.components[i];
        }
        this.components[this.numOfComponents - 1] = son;
    }
}

