/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.facet;

import com.ibm.es.nuvo.facet.CountPriorityQueue;
import com.ibm.es.nuvo.facet.taxi.TaxonomyIndexReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacetNode
implements Serializable {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final long serialVersionUID = 4641052286754654593L;
    private FacetNode father;
    private ArrayList<FacetNode> children = null;
    private Integer catId;
    private String label;
    private int depth;
    private int count = 1;
    private int docId;

    public FacetNode(int catId, int depth, FacetNode father, int docId) {
        this.catId = catId;
        this.depth = depth;
        this.father = father;
        if (this.father != null) {
            this.father.addChild(this);
        }
        this.docId = docId;
    }

    public Integer getCID() {
        return this.catId;
    }

    public String getLabel() {
        return this.label;
    }

    public int getCount() {
        return this.count;
    }

    public int getDepth() {
        return this.depth;
    }

    public void increment(int docid) {
        if (docid >= 0 && this.docId == docid) {
            return;
        }
        this.docId = docid;
        ++this.count;
    }

    public void addChild(FacetNode son) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(son);
    }

    public static int postProcess(TaxonomyIndexReader taxiReader, FacetNode root, int maxCount) throws IOException {
        if (root == null) {
            return 0;
        }
        root.label = taxiReader.getLabel(root.catId);
        if (root.children == null) {
            return 1;
        }
        int nodeCount = 1;
        if (maxCount == Integer.MAX_VALUE) {
            for (FacetNode kid : root.children) {
                nodeCount += FacetNode.postProcess(taxiReader, kid, maxCount);
            }
            return nodeCount;
        }
        CountPriorityQueue cpq = new CountPriorityQueue(maxCount);
        Iterator<FacetNode> iter = FacetNode.getChildIterator(root);
        while (iter != null && iter.hasNext()) {
            cpq.insert(iter.next());
        }
        for (int i = cpq.size(); i > 0; --i) {
            FacetNode val = (FacetNode)cpq.pop();
            nodeCount += FacetNode.postProcess(taxiReader, val, maxCount);
        }
        return nodeCount;
    }

    public static Iterator<FacetNode> getChildIterator(FacetNode root) {
        if (root == null || root.children == null) {
            return null;
        }
        return root.children.iterator();
    }

    public static void display(FacetNode root, String indent, StringBuffer sb) {
        if (root == null) {
            return;
        }
        sb.append(indent);
        sb.append(root);
        sb.append("\n");
        if (root.children == null) {
            return;
        }
        for (FacetNode kid : root.children) {
            if (kid.getLabel() == null) continue;
            FacetNode.display(kid, indent + "  ", sb);
        }
    }

    public String toString() {
        if (this.label == null) {
            return "cid " + this.getCID() + " count " + this.count + " [last doc seen=" + this.docId + "]";
        }
        int index = this.label.lastIndexOf("\uf749");
        if (index > 0) {
            this.label = this.label.substring(index + 1);
        }
        return this.label + " (" + this.count + ")";
    }

    public void setCount(int count) {
        this.count = count;
    }
}

