/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.facet;

import com.ibm.es.nuvo.facet.FacetNode;
import com.ibm.es.nuvo.facet.SonFatherMap;
import com.ibm.es.nuvo.facet.TakmiCounting;
import com.ibm.es.nuvo.facet.WorkingFacetCounter;
import com.ibm.es.nuvo.facet.taxi.TaxonomyIndexReader;
import com.ibm.es.nuvo.facet.taxi.TaxonomyIndexerException;
import com.ibm.es.nuvo.util.Vint8;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermPositions;

public class CountSelectedFacets {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private WorkingFacetCounter[] wfcArray;
    ArrayList<FacetNode> facets = new ArrayList();
    private byte[] data;
    private int dataLength;
    private int maxDepth;
    private static Term fullTreeTerm = new Term("_facets", "fulltree");
    private TermPositions termPos;
    private Vint8.Position pos = new Vint8.Position();
    private int postingsSkipped;
    private int postingsCounted;
    private WorkingFacetCounter[] anCounterArray;
    private SonFatherMap sfm;
    private boolean delayCounting = false;
    private int[] docIds;
    private TakmiCounting takmiCounter;
    private boolean dontSkip = false;
    private int numDocIds;
    private boolean skipPayLoad = false;
    private boolean skipCount = false;

    public CountSelectedFacets(TaxonomyIndexReader taxiReader, IndexReader indexReader, WorkingFacetCounter[] wfcArray, int maxDepth, Properties props) throws IOException, TaxonomyIndexerException {
        this(taxiReader, indexReader, wfcArray, maxDepth);
        String delay = props.getProperty("delayCounting");
        if (delay != null && Boolean.parseBoolean(delay)) {
            this.delayCounting = true;
        }
        if (this.delayCounting) {
            this.docIds = new int[500000];
        }
        this.takmiCounter = new TakmiCounting(indexReader, wfcArray[0].getCategory());
    }

    public void takmiCount(int topKtoCount, int numResults) throws IOException {
        if (this.takmiCounter == null) {
            return;
        }
        this.takmiCounter.count(this.docIds, this.numDocIds, topKtoCount, numResults, 0.8);
    }

    public CountSelectedFacets(TaxonomyIndexReader taxiReader, IndexReader indexReader, WorkingFacetCounter[] wfcArray, int maxDepth) throws IOException, TaxonomyIndexerException {
        int userFacet;
        this.wfcArray = wfcArray;
        this.maxDepth = maxDepth;
        this.sfm = taxiReader.getSonFatherMap();
        try {
            this.termPos = indexReader.termPositions(fullTreeTerm);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        int maxDimension = 0;
        for (userFacet = 0; userFacet < this.wfcArray.length; ++userFacet) {
            int dimension;
            if (this.wfcArray[userFacet] == null || (dimension = this.wfcArray[userFacet].dimension) <= maxDimension) continue;
            maxDimension = dimension;
        }
        this.anCounterArray = new WorkingFacetCounter[maxDimension + 1];
        for (userFacet = 0; userFacet < this.wfcArray.length; ++userFacet) {
            if (this.wfcArray[userFacet] == null) continue;
            this.anCounterArray[this.wfcArray[userFacet].dimension] = this.wfcArray[userFacet];
        }
    }

    public void countFacetsThatMatch(int docId) throws IOException {
        if (this.delayCounting) {
            if (this.numDocIds < this.docIds.length) {
                this.docIds[this.numDocIds++] = docId;
            }
            return;
        }
        this.postQueryFacetCounting(docId);
    }

    public void postQueryFacetCounting(int docId) throws IOException {
        if (this.dontSkip) {
            return;
        }
        if (!this.termPos.skipTo(docId)) {
            return;
        }
        if (this.termPos.doc() != docId) {
            return;
        }
        int freq = this.termPos.freq();
        if (freq <= 0) {
            return;
        }
        int numPos = this.termPos.nextPosition();
        if (freq > 1 || numPos > 1) {
            System.out.println("We have more than one fulltree posting");
        }
        if (!this.getPayload()) {
            return;
        }
        this.processPayload(docId);
    }

    private void processPayload(int docId) {
        this.pos.pos = 0;
        if (this.skipPayLoad) {
            return;
        }
        do {
            int payloadCatId = Vint8.decode(this.data, this.pos);
            if (this.skipCount) continue;
            int dimension = this.sfm.getDimension(payloadCatId);
            if (dimension >= 0 && dimension < this.anCounterArray.length && this.anCounterArray[dimension] != null) {
                ++this.postingsCounted;
                this.anCounterArray[dimension].incrementCounters(payloadCatId, this.maxDepth, docId);
                continue;
            }
            ++this.postingsSkipped;
        } while (this.pos.pos < this.dataLength);
    }

    private boolean getPayload() throws IOException {
        this.dataLength = this.termPos.getPayloadLength();
        if (this.dataLength <= 0) {
            return false;
        }
        if (this.data == null || this.data.length < this.dataLength) {
            this.data = new byte[this.dataLength * 2];
        }
        this.termPos.getPayload(this.data, 0);
        return true;
    }

    public void postProcess(int maxCount) throws IOException {
        int userFacet;
        if (this.delayCounting) {
            for (int d = 0; d < this.numDocIds; ++d) {
                this.postQueryFacetCounting(this.docIds[d]);
            }
        }
        for (userFacet = 0; userFacet < this.wfcArray.length; ++userFacet) {
            if (this.wfcArray[userFacet] == null) continue;
            this.wfcArray[userFacet].postProcess(maxCount);
        }
        for (userFacet = 0; userFacet < this.wfcArray.length; ++userFacet) {
            if (this.wfcArray[userFacet] == null) continue;
            ArrayList<FacetNode> roots = this.wfcArray[userFacet].getRoots();
            for (FacetNode root : roots) {
                this.facets.add(root);
            }
        }
    }

    public FacetNode[] getFacets() {
        Object[] objs = this.facets.toArray();
        if (objs == null) {
            return null;
        }
        FacetNode[] ret = new FacetNode[this.facets.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (FacetNode)objs[i];
        }
        return ret;
    }

    public void display(StringBuffer sb) {
        for (int userFacet = 0; userFacet < this.wfcArray.length; ++userFacet) {
            if (this.wfcArray[userFacet] == null) continue;
            this.wfcArray[userFacet].display(sb);
        }
        if (this.takmiCounter != null) {
            sb.append("Takmi Counting\n");
            this.takmiCounter.display(sb);
        }
    }

    public void summarizeCounts() {
        int total = 0;
        for (int userFacet = 0; userFacet < this.wfcArray.length; ++userFacet) {
            if (this.wfcArray[userFacet] == null) continue;
            total += this.wfcArray[userFacet].summarize();
        }
        System.out.println("Total count nodes " + total);
    }
}

