/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.facet;

import com.ibm.es.nuvo.facet.Constraint;
import com.ibm.siapi.SiapiException;

public class ConstraintImpl
implements Constraint {
    private static int MAX_RETURN_SUB_CATEGORIES_DEFAULT_VALUE = 10;
    private int _mode = 0;
    private double _upperLimit;
    private double _lowerLimit = Double.NEGATIVE_INFINITY;
    private boolean _isUpperLimitInclusive = true;
    private boolean _isLowerLimitInclusive = true;
    private int _maxReturnedSubCategories;
    private boolean _isSubCategoriesInAscendingOrder = false;
    private String _expressionId;
    private boolean _isFilterActive;

    public ConstraintImpl() {
        this._upperLimit = Double.POSITIVE_INFINITY;
        this._maxReturnedSubCategories = MAX_RETURN_SUB_CATEGORIES_DEFAULT_VALUE;
    }

    public int getMode() {
        return this._mode;
    }

    public double getUpperLimit() {
        return this._upperLimit;
    }

    public boolean isUpperLimitInclusive() {
        return this._isUpperLimitInclusive;
    }

    public double getLowerLimit() {
        return this._lowerLimit;
    }

    public boolean isLowerLimitInclusive() {
        return this._isLowerLimitInclusive;
    }

    public int getMaxReturnedSubCategories() {
        return this._maxReturnedSubCategories;
    }

    public boolean isSubCategoriesInAscendingOrder() {
        return this._isSubCategoriesInAscendingOrder;
    }

    public String getExpression() {
        return this._expressionId;
    }

    public void set(int mode, int maxReturnedSubCategories, boolean isSubCategoriesInAscendingOrder, String expressionID) throws SiapiException {
        this.set(mode, this._lowerLimit, this._isLowerLimitInclusive, this._upperLimit, this._isUpperLimitInclusive, maxReturnedSubCategories, isSubCategoriesInAscendingOrder, expressionID, false);
    }

    public void set(int mode, double lowerLimit, boolean isLowerLimitInclusive, double upperLimit, boolean isUpperLimitInclusive, int maxReturnedSubCategories, boolean isSubCategoriesInAscendingOrder, String expressionID) throws SiapiException {
        this.set(mode, lowerLimit, isLowerLimitInclusive, upperLimit, isUpperLimitInclusive, maxReturnedSubCategories, isSubCategoriesInAscendingOrder, expressionID, true);
    }

    private void set(int mode, double lowerLimit, boolean isLowerLimitInclusive, double upperLimit, boolean isUpperLimitInclusive, int maxReturnedSubCategories, boolean isSubCategoriesInAscendingOrder, String expressionID, boolean isFilterActive) throws SiapiException {
        if (!this.isLegalMode(mode)) {
            throw new SiapiException(-1, 23, "The mode " + mode + " is not one of the valid modes.");
        }
        this._mode = mode;
        if (!(lowerLimit <= upperLimit)) {
            throw new SiapiException(-1, 23, "The lower limit " + lowerLimit + " is bigger then the upper limit " + upperLimit);
        }
        this._lowerLimit = lowerLimit;
        this._upperLimit = upperLimit;
        this._isLowerLimitInclusive = isLowerLimitInclusive;
        this._isUpperLimitInclusive = isUpperLimitInclusive;
        this._isSubCategoriesInAscendingOrder = isSubCategoriesInAscendingOrder;
        if (maxReturnedSubCategories <= 0) {
            throw new SiapiException(-1, 23, "The maximal returned categories is not positive" + maxReturnedSubCategories);
        }
        this._maxReturnedSubCategories = maxReturnedSubCategories;
        this._expressionId = expressionID;
        this._isFilterActive = isFilterActive;
    }

    public boolean isFilterActive() {
        return this._isFilterActive;
    }

    private boolean isLegalMode(int mode) {
        return mode == 0 || mode == 1 || mode == -1;
    }

    public boolean isWithinLimits(double d) {
        if (Double.isNaN(d)) {
            return false;
        }
        return !(d < this._lowerLimit || d > this._upperLimit || d == this._lowerLimit && !this._isLowerLimitInclusive) && (d != this._upperLimit || this._isUpperLimitInclusive);
    }

    public String toString() {
        return new String("Mode is " + this.getMode() + "\n" + "lowerLimit is " + this.getLowerLimit() + " and it is " + (this.isLowerLimitInclusive() ? "" : "not ") + "inclusive\n" + "upperLimit is " + this.getUpperLimit() + " and it is " + (this.isUpperLimitInclusive() ? "" : "not ") + "inclusive\n" + "MaxReturnedSubCategories is " + this.getMaxReturnedSubCategories() + "\n" + "Sub categories are " + (this.isSubCategoriesInAscendingOrder() ? "" : "not ") + "in ascending order\n" + "Expression ID is " + this._expressionId);
    }
}

