/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.facet;

import com.ibm.es.nuvo.facet.CatId;

public class CategoryAncestry {
    public static final String INVALID_ORDINAL = "-1";
    private int _curr;
    private CatId[] _ancestorsIDs;
    private int[] _ancestorsOrdinals;
    private CatId _categoryID;
    private int _ordinal;

    public CategoryAncestry(CatId[] ancestorsIDs, int[] ancestorsOrdinals, CatId categoryID, int ordinal) {
        this._ancestorsIDs = ancestorsIDs;
        this._ancestorsOrdinals = ancestorsOrdinals;
        this._categoryID = categoryID;
        this._ordinal = ordinal;
        this._curr = 0;
    }

    public CategoryAncestry(CategoryAncestry father, CatId sonID, int sonOrdinal) {
        int i;
        int numOfAncestors = father._ordinal == 0 ? 0 : father.getAllAncestors().length + 1;
        this._ancestorsIDs = new CatId[numOfAncestors];
        for (i = 1; i < numOfAncestors; ++i) {
            this._ancestorsIDs[i] = father.getAllAncestors()[i - 1];
        }
        this._ancestorsOrdinals = new int[numOfAncestors];
        for (i = 1; i < numOfAncestors; ++i) {
            this._ancestorsOrdinals[i] = father.getAllAncestorsOrds()[i - 1];
        }
        if (numOfAncestors > 0) {
            this._ancestorsIDs[0] = father.getId();
            this._ancestorsOrdinals[0] = father.getOrdinal();
        }
        this._categoryID = sonID;
        this._ordinal = sonOrdinal;
        this._curr = 0;
    }

    public CatId getNextAncestor() {
        if (this._ancestorsIDs == null || this._ancestorsIDs.length <= this._curr) {
            return null;
        }
        return this._ancestorsIDs[this._curr++];
    }

    public void reset() {
        this._curr = 0;
    }

    public CatId[] getAllAncestors() {
        return this._ancestorsIDs;
    }

    public int[] getAllAncestorsOrds() {
        return this._ancestorsOrdinals;
    }

    public CatId getId() {
        return this._categoryID;
    }

    public CatId getCategoryId() {
        return this._categoryID;
    }

    public int getOrdinal() {
        return this._ordinal;
    }
}

