/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.facet;

import com.ibm.es.nuvo.util.StringUtils;
import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;

public class CategoryAnalyzer
extends Analyzer {
    private CategoryFieldTokenStream tokenStream = new CategoryFieldTokenStream();
    private String facet_separator;

    public CategoryAnalyzer(String facet_separator) {
        this.facet_separator = facet_separator;
    }

    public CategoryAnalyzer() {
        this("\uf748");
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        String categories = null;
        try {
            categories = StringUtils.readerToString(reader);
            if (categories == null) {
                return null;
            }
        }
        catch (IOException e) {
            return null;
        }
        this.tokenStream.setCategories(categories, this.facet_separator);
        return this.tokenStream;
    }

    class CategoryFieldTokenStream
    extends TokenStream {
        private String curCategory;
        private String facet_separator1;
        private String subPath;
        private int componentIndex;

        CategoryFieldTokenStream() {
        }

        private void setCategories(String categories, String facet_sep) {
            this.curCategory = categories;
            this.subPath = null;
            this.componentIndex = -1;
            this.facet_separator1 = facet_sep;
        }

        public Token next() throws IOException {
            String temp;
            if (this.subPath != null && (temp = this.nextSubPath()) != null) {
                return new Token(temp, 0, 0);
            }
            if (this.curCategory == null || this.curCategory.length() == 0) {
                return null;
            }
            do {
                int index = this.curCategory.indexOf(this.facet_separator1);
                String tempPath = this.curCategory;
                if (index < 0) {
                    this.curCategory = null;
                    tempPath = this.startSubPath(tempPath);
                    return new Token(tempPath, 0, 0);
                }
                tempPath = this.curCategory.substring(0, index);
                this.curCategory = this.curCategory.substring(index + 1);
                if (tempPath.length() <= 0) continue;
                tempPath = this.startSubPath(tempPath);
                return new Token(tempPath, 0, 0);
            } while (this.curCategory != null);
            this.curCategory = null;
            return null;
        }

        private String startSubPath(String tempPath) {
            this.subPath = tempPath;
            this.componentIndex = this.subPath.indexOf("\uf749");
            if (this.componentIndex < 0) {
                this.subPath = null;
                return tempPath;
            }
            return this.subPath.substring(0, this.componentIndex);
        }

        private String nextSubPath() {
            if (this.subPath == null) {
                return null;
            }
            this.componentIndex = this.subPath.indexOf("\uf749", this.componentIndex + 1);
            if (this.componentIndex < 0) {
                String temp = this.subPath;
                this.subPath = null;
                return temp;
            }
            return this.subPath.substring(0, this.componentIndex);
        }
    }
}

