/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.eventmonitor;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.configuration.SettingsObject;
import com.ibm.es.nuvo.eventmonitor.Event;
import com.ibm.es.nuvo.util.XMLTagger;
import com.ibm.es.nuvo.util.parser.ParseTree;
import com.ibm.es.nuvo.util.parser.Parser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventManagerData
implements SettingsObject {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String EventsElement = "events";
    private static final String NotificationFileName = "notificationEvents.xml";
    private Vector<Event> events = new Vector();
    private Event tempEvt = null;
    private Message tempMsg = null;

    public Vector<Event> getEvents() {
        return this.events;
    }

    public void setEvents(Vector<Event> events) {
        this.events = events;
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        XMLTagger xmlTagger = new XMLTagger(true, true);
        xmlTagger.openStartElement(EventsElement);
        xmlTagger.writeAttr("version", "1.0");
        xmlTagger.closeTag();
        if (this.events != null && this.events.size() > 0) {
            for (int i = 0; i < this.events.size(); ++i) {
                Event evt = this.events.elementAt(i);
                evt.writeTo(xmlTagger);
            }
        }
        xmlTagger.endElement(EventsElement);
        String xml = xmlTagger.getXML();
        try {
            os.write(xml.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ignore) {
            // empty catch block
        }
    }

    @Override
    public void loadFrom(InputStream is) throws ExtendedException {
        Parser parser = new Parser();
        ParseTree tree = new ParseTree();
        tree.addPath("/events/event/message/key", "addMessageKey");
        tree.addPath("/events/event/message/arg", "addMessageArg");
        tree.addPath("/events/event/time", "addEventTimeStr");
        parser.parse(is, tree, this);
        this.tempMsg = null;
        this.tempEvt = null;
    }

    @Override
    public String getPersistantFileName() {
        StringBuffer sb = new StringBuffer(200);
        GlobalConfiguration gc = GlobalConfiguration.getConfiguration();
        sb.append(gc.getLogPath());
        sb.append(File.separator);
        sb.append(NotificationFileName);
        return sb.toString();
    }

    public void addEventTimeStr(String strTimeInMillis) {
        long timeInMillis = 0L;
        timeInMillis = Long.parseLong(strTimeInMillis);
        this.tempMsg = new Message();
        this.tempEvt = new Event(timeInMillis, this.tempMsg);
        this.events.addElement(this.tempEvt);
    }

    public void addMessageKey(String key) {
        this.tempMsg.setKey(key);
    }

    public void addMessageArg(String arg) {
        this.tempMsg.addArgument(arg);
    }
}

