/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.eventmonitor;

import com.ibm.es.nuvo.util.parser.ParseException;
import com.ibm.es.nuvo.util.parser.ParseTree;
import com.ibm.es.nuvo.util.parser.Parser;
import java.io.InputStream;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventManagerConfig {
    private static final String AllowDupsAttribute = "allowDups";
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private HashMap<String, Boolean> messages = new HashMap();
    private int maxNumberOfMessages = 30;

    private EventManagerConfig() {
    }

    protected static EventManagerConfig loadConfigFrom(InputStream is) throws ParseException {
        EventManagerConfig config = new EventManagerConfig();
        Parser parser = new Parser();
        ParseTree tree = new ParseTree();
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        propertyMap.put(AllowDupsAttribute, AllowDupsAttribute);
        tree.addSetSubcomponent("/config/messages/key/", "buildEventAttributes");
        tree.addAttributesRule("/config/messages/key/", propertyMap);
        tree.addCallMethod("/config/messages/key/", "setMsgKey");
        tree.addCallMethod("/config/maxNumberOfMessages/", "setMaxNumberOfMessagesStr");
        parser.parse(is, tree, config);
        return config;
    }

    protected HashMap<String, Boolean> getMessages() {
        return this.messages;
    }

    protected int getMaxNumberOfMessages() {
        return this.maxNumberOfMessages;
    }

    public void setMaxNumberOfMessagesStr(String strMaxNumberOfMessages) {
        this.maxNumberOfMessages = Integer.valueOf(strMaxNumberOfMessages);
    }

    private void addMsgKey(String key, boolean bAllowDups) {
        this.messages.put(key, new Boolean(bAllowDups));
    }

    public EventAttributes buildEventAttributes() {
        EventAttributes eventAttrs = new EventAttributes();
        return eventAttrs;
    }

    public class EventAttributes {
        private String allowDups = "true";

        public void setAllowDups(String allowDups) {
            this.allowDups = allowDups;
        }

        public boolean getAllowDups() {
            return "true".equalsIgnoreCase(this.allowDups);
        }

        public void setMsgKey(String msgKey) {
            EventManagerConfig.this.addMsgKey(msgKey, this.getAllowDups());
        }
    }
}

