/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.eventmonitor;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.ConfigurationManagerException;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.configuration.SettingsConfigurationManager;
import com.ibm.es.nuvo.eventmonitor.Event;
import com.ibm.es.nuvo.eventmonitor.EventManagerConfig;
import com.ibm.es.nuvo.eventmonitor.EventManagerData;
import com.ibm.es.nuvo.eventmonitor.LogListener;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.util.parser.ParseException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventManager {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final String EventOccured = "EventOccured";
    protected static final String ConfigFile = "monitoredEventsConfig.xml";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private int maxNumberOfEvents = 30;
    private HashMap<String, Boolean> monitoredMsgKeys = new HashMap();
    private LogListener logListener = null;
    private boolean lastUpdateWasSuccessful = true;

    public synchronized void clearEvent(Event event) throws ExtendedException {
        Vector<Event> events = this.accessEvents();
        boolean found = events.removeElement(event);
        if (found) {
            this.updateEvents(events);
        }
    }

    public synchronized void clearAllEvents() throws ExtendedException {
        Vector<Event> events = this.accessEvents();
        events.clear();
        this.updateEvents(events);
    }

    public synchronized Event getLatestEvent() {
        Vector<Event> events = this.accessEvents();
        Event evt = null;
        if (events.size() > 0) {
            evt = events.firstElement();
        }
        return evt;
    }

    public synchronized Vector<Event> getLatestUniqueEvents() {
        Vector<Event> events = this.getEvents();
        if (events != null) {
            HashMap<String, String> foundKeys = new HashMap<String, String>();
            Vector<Event> eventsToRemove = new Vector<Event>();
            for (int i = 0; i < events.size(); ++i) {
                Event evt = events.get(i);
                String key = evt.getMsg().getKey();
                String exists = foundKeys.put(key, key);
                if (exists == null) continue;
                eventsToRemove.add(evt);
            }
            events.removeAll(eventsToRemove);
        }
        return events;
    }

    public synchronized Vector<Event> getEvents() {
        Vector<Event> events = this.accessEvents();
        Vector newEvents = null;
        if (events != null) {
            newEvents = (Vector)events.clone();
        }
        return newEvents;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public int getMaxNumberOfEvents() {
        return this.maxNumberOfEvents;
    }

    public void initialize() throws FileNotFoundException, ParseException {
        GlobalConfiguration globalConfig = GlobalConfiguration.getConfiguration();
        String monitoredMsgsFile = globalConfig.getConfigPath() + File.separator + ConfigFile;
        FileInputStream is = new FileInputStream(monitoredMsgsFile);
        EventManagerConfig config = EventManagerConfig.loadConfigFrom(is);
        this.monitoredMsgKeys = config.getMessages();
        this.maxNumberOfEvents = config.getMaxNumberOfMessages();
        this.logListener = new LogListener(this);
        this.logListener.setMessageIds(this.monitoredMsgKeys);
        Loggers.logger.addHandler(this.logListener);
    }

    public void shutdown() {
        if (this.logListener != null) {
            Loggers.logger.removeHandler(this.logListener);
            this.logListener = null;
        }
    }

    public HashMap<String, Boolean> getMonitoredMsgKeys() {
        return this.monitoredMsgKeys;
    }

    protected void firePropertyChangeEvent(String event, Event evt) {
        this.propertyChangeSupport.firePropertyChange(event, null, evt);
    }

    private Vector<Event> accessEvents() {
        SettingsConfigurationManager configMgr = SettingsConfigurationManager.getConfigurationManager();
        EventManagerData savedEventMsgs = null;
        savedEventMsgs = (EventManagerData)configMgr.getSettings(SettingsConfigurationManager.SettingsType.EventManagerSettings);
        return savedEventMsgs.getEvents();
    }

    private void updateEvents(Vector<Event> newEvents) throws ExtendedException {
        SettingsConfigurationManager configMgr = SettingsConfigurationManager.getConfigurationManager();
        EventManagerData savedEventMsgs = null;
        savedEventMsgs = (EventManagerData)configMgr.getSettingsForUpdate(SettingsConfigurationManager.SettingsType.EventManagerSettings);
        savedEventMsgs.setEvents(newEvents);
        try {
            configMgr.updateStateObject(SettingsConfigurationManager.SettingsType.EventManagerSettings, savedEventMsgs);
            this.lastUpdateWasSuccessful = true;
        }
        catch (ConfigurationManagerException e) {
            Message errMsg = new Message("G0087E.ERROR_SAVING_EVENT_MANAGER_DATA");
            ExtendedException ee = new ExtendedException(errMsg, (Throwable)e);
            throw ee;
        }
    }

    protected synchronized void notifyMessage(long time, Message msg) {
        Event evt = new Event(time, msg);
        Vector<Event> events = this.accessEvents();
        events.add(0, evt);
        if (this.monitoredMsgKeys.containsKey(msg.getKey()) && !this.monitoredMsgKeys.get(msg.getKey()).booleanValue()) {
            for (int i = events.size() - 1; i >= 1; --i) {
                Event e = events.get(i);
                if (!msg.equalMsg(e.getMsg())) continue;
                events.removeElementAt(i);
            }
        }
        while (events.size() > this.maxNumberOfEvents) {
            events.removeElementAt(events.size() - 1);
        }
        try {
            this.updateEvents(events);
        }
        catch (ExtendedException e) {
            if (this.lastUpdateWasSuccessful && Loggers.logger.isLoggable(Level.SEVERE)) {
                Loggers.logger.log(Level.SEVERE, e);
            }
            this.lastUpdateWasSuccessful = false;
        }
        this.firePropertyChangeEvent(EventOccured, evt);
    }
}

