/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.documenttracking;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.crawler.URIStatus;
import com.ibm.es.nuvo.crawler.admin.CrawledDocumentStatus;
import com.ibm.es.nuvo.util.url.URLEncoderDecoder;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;

public class DocumentTrackingInformation {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String HttpCodeKey = "A1500I.crawler.http.code.";
    private static final String ParserCodeKey = "A1500I.parser.code.";
    private String documentLanguage;
    private String mimeType;
    private String encodedUri;
    private String decodedUri;
    private boolean inIndex = false;
    private ExtendedException exception;
    private int code;
    private int crawlerCode;
    private Date lastCrawled;
    private String crawlspaceId;
    private static DateFormat dateFormatter = DateFormat.getDateInstance(1, Locale.getDefault());

    public DocumentTrackingInformation(URIStatus status) {
        this.encodedUri = status.getUrl();
        this.decodedUri = URLEncoderDecoder.decode(this.encodedUri);
        this.lastCrawled = new Date(status.getLast());
        this.crawlerCode = status.getCode();
    }

    public DocumentTrackingInformation(CrawledDocumentStatus cds) {
        this.encodedUri = cds.getURI();
        this.decodedUri = URLEncoderDecoder.decode(this.encodedUri);
        this.lastCrawled = cds.getDate();
        this.crawlerCode = cds.getCode();
    }

    public DocumentTrackingInformation(String url) {
        this.encodedUri = url;
        this.decodedUri = url;
    }

    public String getUri() {
        return this.decodedUri;
    }

    public String getEncodedUri() {
        return this.encodedUri;
    }

    public ExtendedException getException() {
        return this.exception;
    }

    public void setException(ExtendedException exception) {
        this.exception = exception;
    }

    public void setCrawlspaceId(String crawlspaceId) {
        this.crawlspaceId = crawlspaceId;
    }

    public String getCrawlspaceId() {
        return this.crawlspaceId;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("url:" + this.decodedUri);
        builder.append("\n");
        Date lastCrawl = this.getLastCrawl();
        if (lastCrawl != null) {
            builder.append("last crawl:" + dateFormatter.format(this.getLastCrawl()));
        } else {
            builder.append("not crawled yet");
        }
        builder.append("\n");
        builder.append("httpcode:" + this.getHttpCode() + "\n");
        builder.append("http code explanation:" + this.getHttpCodeExplanation(Locale.getDefault()));
        builder.append("\n");
        builder.append("parsecode:" + this.code + "\n");
        builder.append("parse code explanation:" + this.getCodeExplanation(Locale.getDefault()));
        builder.append("\n");
        if (this.documentLanguage != null) {
            builder.append("language:" + this.documentLanguage);
        } else {
            builder.append("language: not set");
        }
        builder.append("\n");
        if (this.mimeType != null) {
            builder.append("doctype:" + this.mimeType);
        } else {
            builder.append("doctype: not set");
        }
        builder.append("\n");
        if (this.exception != null) {
            builder.append(this.exception.getFormattedText());
        }
        builder.append("\n");
        return builder.toString();
    }

    public void setIsInIndex(boolean inIndex) {
        this.inIndex = inIndex;
    }

    public boolean isInIndex() {
        return this.inIndex;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getCodeExplanation(Locale locale) {
        String msg = new Message(ParserCodeKey + this.code).getText(locale);
        if (msg == null) {
            return new Message("A1500I.not.found", this.code).getText(locale);
        }
        return msg;
    }

    public int getCode() {
        return this.code;
    }

    public int getHttpCode() {
        return this.crawlerCode;
    }

    public String getHttpCodeExplanation(Locale locale) {
        String msg = new Message(HttpCodeKey + this.getHttpCode()).getText(locale);
        if (msg == null) {
            return new Message("A1500I.not.found", this.getHttpCode()).getText(locale);
        }
        return msg;
    }

    public Date getLastCrawl() {
        return this.lastCrawled;
    }

    public void setDocumentLanguage(String documentLanguage) {
        this.documentLanguage = documentLanguage;
    }

    public String getDocumentLanguage() {
        return this.documentLanguage;
    }

    public void setMimeType(String mimetype) {
        this.mimeType = mimetype;
    }

    public String getMimeType() {
        return this.mimeType;
    }
}

