/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.documenttracking;

import com.ibm.es.nuvo.GlobalSystem;
import com.ibm.es.nuvo.api.CrawlService;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.ConfigurationManager;
import com.ibm.es.nuvo.configuration.CrawlServiceFactory;
import com.ibm.es.nuvo.configuration.WebCrawlServiceImpl;
import com.ibm.es.nuvo.crawler.URIStatus;
import com.ibm.es.nuvo.crawler.admin.CrawledDocumentStatus;
import com.ibm.es.nuvo.crawler.admin.CrawlerManager;
import com.ibm.es.nuvo.documenttracking.DocumentTrackingInformation;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.search.QueryImpl;
import com.ibm.es.nuvo.search.ResultImpl;
import com.ibm.es.nuvo.search.SearchServiceImpl;
import com.ibm.es.nuvo.search.SearchableImpl;
import com.ibm.es.nuvo.util.Constants;
import com.ibm.es.nuvo.util.uri.BaseURIUtil;
import com.ibm.es.nuvo.util.uri.FSURIUtil;
import com.ibm.siapi.SiapiException;
import com.ibm.siapi.search.Query;
import com.ibm.siapi.search.Result;
import com.ibm.siapi.search.ResultSet;
import com.ibm.siapi.search.Searchable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentTracker {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final int MaxNumberOfHits = 10;

    public boolean getDocumentInformation(String collectionId, String uriPattern, Vector<DocumentTrackingInformation> allInformation) throws ExtendedException {
        return this.getDocumentInformation(collectionId, uriPattern, 0, 10, allInformation);
    }

    public boolean getDocumentInformation(String collectionId, String uriPattern, int maxNumberOfHits, Vector<DocumentTrackingInformation> allInformation2) throws ExtendedException {
        return this.getDocumentInformation(collectionId, uriPattern, 0, maxNumberOfHits, allInformation2);
    }

    public boolean getDocumentInformation(String collectionId, String uriPattern, int offset, int maxNumberOfHits, Vector<DocumentTrackingInformation> allInformation2) throws ExtendedException {
        DocumentTrackingInformation info;
        String localPattern;
        LinkedHashMap<String, DocumentTrackingInformation> keyedAllInformation = new LinkedHashMap<String, DocumentTrackingInformation>();
        boolean truncated = false;
        int resultOffset = 0;
        uriPattern = uriPattern.trim();
        CollectionConfiguration config = ConfigurationManager.getConfigurationManager().getCollection(collectionId);
        List<Object> status = new ArrayList();
        CrawlService cs = CrawlServiceFactory.getInstance().getServiceFor(Constants.CrawlerType.Web);
        if (this.isWebUrl(uriPattern) && cs.crawlspaceExistsForCollection(collectionId)) {
            localPattern = null;
            try {
                localPattern = BaseURIUtil.encode(uriPattern);
            }
            catch (Exception e) {
                localPattern = uriPattern.trim();
            }
            localPattern = this.escapeWildcard(localPattern);
            String crawlSpaceId = config.getCrawlspaceId(Constants.CrawlerType.Web);
            int totalToFetch = offset + maxNumberOfHits;
            status = WebCrawlServiceImpl.getCrawlService().getURLStatusReport(crawlSpaceId, localPattern, totalToFetch + 1);
            if (status != null && status.size() > 0 && status.size() >= totalToFetch) {
                truncated = true;
            }
            Iterator<Object> iterator = status.iterator();
            while (iterator.hasNext() && keyedAllInformation.size() < maxNumberOfHits) {
                if (resultOffset >= offset) {
                    info = new DocumentTrackingInformation((URIStatus)iterator.next());
                    this.augmentFromIndex(collectionId, info);
                    keyedAllInformation.put(info.getEncodedUri(), info);
                }
                ++resultOffset;
            }
        }
        if (!truncated && maxNumberOfHits > keyedAllInformation.size()) {
            localPattern = null;
            if (this.isFileUrl(uriPattern)) {
                try {
                    localPattern = FSURIUtil.encode(uriPattern.trim());
                }
                catch (Exception e) {
                    localPattern = uriPattern.trim();
                }
            } else {
                localPattern = uriPattern;
            }
            int totalToFetch = offset + maxNumberOfHits - status.size();
            CrawlerManager manager = GlobalSystem.getSingleInstance().getGlobalCrawlerManager().getCrawlerManager(collectionId);
            CrawledDocumentStatus cds = manager.getCrawledDocumentStatus(localPattern, totalToFetch + 1);
            while (keyedAllInformation.size() < maxNumberOfHits && cds.next()) {
                if (resultOffset >= offset) {
                    info = new DocumentTrackingInformation(cds);
                    this.augmentFromIndex(collectionId, info);
                    keyedAllInformation.put(info.getEncodedUri(), info);
                }
                ++resultOffset;
            }
            if (cds.next()) {
                truncated = true;
            }
        }
        if (keyedAllInformation.size() < maxNumberOfHits) {
            truncated = this.fillInfoFromIndex(collectionId, keyedAllInformation, uriPattern, offset, resultOffset, maxNumberOfHits);
        }
        allInformation2.clear();
        allInformation2.addAll(keyedAllInformation.values());
        return truncated;
    }

    private boolean fillInfoFromIndex(String collectionId, LinkedHashMap<String, DocumentTrackingInformation> keyedAllInformation, String uriPattern, int offset, int resultOffset, int maxNumberOfHits) throws ExtendedException {
        boolean truncated;
        block13: {
            SearchServiceImpl searchService = SearchServiceImpl.getInstance();
            Searchable searchable = null;
            truncated = false;
            try {
                searchable = searchService.getSearchable(null, collectionId);
                QueryImpl query = new QueryImpl();
                query.setRequestedResultRange(0, maxNumberOfHits * 2);
                ResultSet resultSet = this.searchIndex(searchable, query, uriPattern);
                Result[] results = resultSet.getResults();
                if (results == null) break block13;
                int i = 0;
                while (i < results.length) {
                    Result result = results[i++];
                    if (resultOffset < offset) {
                        ++resultOffset;
                        continue;
                    }
                    String url = result.getDocumentID();
                    if (!keyedAllInformation.containsKey(url)) {
                        DocumentTrackingInformation info = new DocumentTrackingInformation(url);
                        this.fill(info, result);
                        keyedAllInformation.put(url, info);
                    }
                    if (keyedAllInformation.size() < maxNumberOfHits || i >= results.length) continue;
                    truncated = true;
                    break;
                }
            }
            catch (SiapiException e) {
                Throwable t = e.getCause();
                if (t instanceof ExtendedException && ((ExtendedException)t).isACause("S0074E.INDEX_DISABLED_FOR_SEARCH")) {
                    throw new ExtendedException("A2200E.documenttracking.search.disabled");
                }
                throw new ExtendedException("A2201E.documenttracking.search.error", (Throwable)e);
            }
            finally {
                block14: {
                    try {
                        searchService.putSearchable((SearchableImpl)searchable);
                    }
                    catch (Exception e) {
                        if (!Loggers.logger.isLoggable(Level.SEVERE)) break block14;
                        ExtendedException exc = new ExtendedException("A2202E.documenttracking.unable.to.free.resource", (Throwable)e);
                        Loggers.logger.log(Level.SEVERE, exc);
                    }
                }
            }
        }
        return truncated;
    }

    private boolean isWebUrl(String pattern) {
        return pattern.startsWith("http://") || pattern.startsWith("https://") || pattern.startsWith("*");
    }

    private boolean isFileUrl(String pattern) {
        return pattern.startsWith("file://") || pattern.startsWith("*");
    }

    private ResultSet searchIndex(Searchable searchable, Query query, String uri) throws SiapiException {
        query.setReturnedAttribute(-3, true);
        query.setText("uri:\"" + uri + "\"");
        query.setReturnedAttribute(-1, false);
        query.getProperties().setProperty("disableSummarizer", "true");
        query.getProperties().setProperty("synonymExpansion", "false");
        query.getProperties().setProperty("proximityScoring", "false");
        query.getProperties().setProperty("staticScoring", "false");
        return searchable.search(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fill(DocumentTrackingInformation info, Result result) {
        String[] mimeType;
        String[] language;
        InputStream is;
        info.setIsInIndex(true);
        String[] codeArray = result.getFields("_code");
        if (codeArray.length > 0) {
            try {
                info.setCode(Integer.parseInt(codeArray[0]));
            }
            catch (NumberFormatException e) {
                if (Loggers.logger.isLoggable(Level.SEVERE)) {
                    ExtendedException exc = new ExtendedException("A2203E.documenttracking.invalid.code", (Throwable)e);
                    Loggers.logger.log(Level.SEVERE, exc);
                }
            }
        } else if (Loggers.logger.isLoggable(Level.SEVERE)) {
            ExtendedException exc = new ExtendedException("A2203E.documenttracking.invalid.code");
            Loggers.logger.log(Level.SEVERE, exc);
        }
        if ((is = ((ResultImpl)result).getBinaryField("_cause")) != null) {
            ExtendedException exc;
            try {
                ObjectInputStream ois = new ObjectInputStream(new InflaterInputStream(is, new Inflater()));
                ExtendedException e = (ExtendedException)ois.readObject();
                info.setException(e);
                ois.close();
            }
            catch (IOException e) {
                if (Loggers.logger.isLoggable(Level.SEVERE)) {
                    exc = new ExtendedException("A2204E.documenttracking.cannot.load.error", (Throwable)e);
                    Loggers.logger.log(Level.SEVERE, exc);
                }
            }
            catch (ClassNotFoundException e) {
                if (Loggers.logger.isLoggable(Level.SEVERE)) {
                    exc = new ExtendedException("A2204E.documenttracking.cannot.load.error", (Throwable)e);
                    Loggers.logger.log(Level.SEVERE, exc);
                }
            }
            finally {
                block27: {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        if (!Loggers.logger.isLoggable(Level.SEVERE)) break block27;
                        exc = new ExtendedException("A2202E.documenttracking.unable.to.free.resource", (Throwable)e);
                        Loggers.logger.log(Level.SEVERE, exc);
                    }
                }
            }
        }
        if ((language = result.getFields("language")) != null && language.length > 0) {
            info.setDocumentLanguage(language[0]);
        }
        if ((mimeType = result.getFields("doctype")) != null && mimeType.length > 0) {
            info.setMimeType(mimeType[0]);
        }
        info.setCrawlspaceId(((ResultImpl)result).getSpaceId());
    }

    private void augmentFromIndex(String collectionId, DocumentTrackingInformation info) throws ExtendedException {
        SearchServiceImpl searchService = SearchServiceImpl.getInstance();
        String uri = info.getEncodedUri();
        Searchable searchable = null;
        try {
            searchable = searchService.getSearchable(null, collectionId);
            QueryImpl query = new QueryImpl();
            query.setRequestedResultRange(0, 5);
            ResultSet resultSet = this.searchIndex(searchable, query, uri);
            Result[] results = resultSet.getResults();
            if (results != null && results.length > 0) {
                this.fill(info, results[0]);
            }
        }
        catch (SiapiException e) {
            Throwable t = e.getCause();
            if (t instanceof ExtendedException && ((ExtendedException)t).isACause("S0074E.INDEX_DISABLED_FOR_SEARCH")) {
                throw new ExtendedException("A2200E.documenttracking.search.disabled");
            }
            throw new ExtendedException("A2201E.documenttracking.search.error", (Throwable)e);
        }
        finally {
            block12: {
                try {
                    searchService.putSearchable((SearchableImpl)searchable);
                }
                catch (Exception e) {
                    if (!Loggers.logger.isLoggable(Level.SEVERE)) break block12;
                    ExtendedException exc = new ExtendedException("A2202E.documenttracking.unable.to.free.resource", (Throwable)e);
                    Loggers.logger.log(Level.SEVERE, exc);
                }
            }
        }
    }

    private String escapeWildcard(String query) {
        char[] cs;
        if (query == null || query.length() == 0 || query.indexOf("%") < 0 && query.indexOf("*") < 0 && query.indexOf("_") < 0) {
            return query;
        }
        StringBuilder builder = new StringBuilder();
        block4: for (char c : cs = query.toCharArray()) {
            switch (c) {
                case '*': {
                    builder.append("%");
                    continue block4;
                }
                case '%': 
                case '_': {
                    builder.append("\\");
                }
                default: {
                    builder.append(c);
                }
            }
        }
        return builder.toString();
    }
}

