/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.documentqueue;

import com.ibm.es.nuvo.common.Metadata;
import com.ibm.es.nuvo.documentqueue.StreamedDocument;
import com.ibm.es.nuvo.util.TeeInputStream;
import com.ibm.es.nuvo.util.XMLTagger;
import com.ibm.es.nuvo.util.databuffer.DataBufferException;
import com.ibm.es.nuvo.util.databuffer.DataBufferOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class TeeStreamDocument
implements StreamedDocument {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static int MaxMemoryDocSize = 0x100000;
    private String uri;
    private InputStream inputStream;
    private DataBufferOutputStream cacheStream;
    private TeeInputStream teeStream;
    private boolean cachingOn;
    private Metadata metadata;

    public TeeStreamDocument(String uri, InputStream inputStream) {
        this.uri = uri;
        this.inputStream = inputStream;
        this.cachingOn = true;
    }

    public InputStream getInputStream() {
        if (!this.cachingOn) {
            return this.inputStream;
        }
        if (this.teeStream == null) {
            this.cacheStream = new DataBufferOutputStream(MaxMemoryDocSize);
            this.teeStream = new TeeInputStream(this.inputStream, this.cacheStream);
        }
        return this.teeStream;
    }

    public String getUri() {
        return this.uri;
    }

    public InputStream getCacheStream() {
        if (!this.cachingOn) {
            return null;
        }
        try {
            return this.cacheStream.getInputStream();
        }
        catch (DataBufferException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void dispose() {
        try {
            this.inputStream.close();
            if (this.cacheStream != null) {
                this.cacheStream.dispose();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setCaching(boolean on) {
        this.cachingOn = on;
    }

    public Metadata getMetadata() {
        if (this.metadata == null) {
            this.metadata = new Metadata();
        }
        return this.metadata;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public void writeTo(XMLTagger tagger) {
        System.out.println("Warning, persistance in writeTo() for " + this.getClass() + " not done");
    }
}

