/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.documentqueue;

import com.ibm.es.nuvo.documentqueue.BaseDocument;
import com.ibm.es.nuvo.documentqueue.DocumentQueueInterface;
import com.ibm.es.nuvo.documentqueue.SerializableDocument;
import com.ibm.es.nuvo.network.Node;
import com.ibm.es.nuvo.network.NodeManager;
import com.ibm.es.nuvo.network.p2p.P2PDispatcher;
import com.ibm.es.nuvo.network.p2p.P2PException;
import com.ibm.es.nuvo.network.p2p.P2PServiceInterface;
import com.ibm.es.nuvo.util.databuffer.DataBufferException;
import com.ibm.es.nuvo.util.databuffer.DataBufferOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentQueueXmitServices {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String CollectionIdKey = "CollectionId";
    public static final int RC_DocsInsertedOk = 200;
    public static final int RC_DocsNotInserted = 201;
    public static final int RC_NoRemoteNodes = 202;
    private static final String ServicePrefix = "DocQueue_";
    private static Hashtable<String, DocumentQueueXmitServices> services = new Hashtable();
    private P2PServiceInterface msgReceiver = null;
    private String docQueueName = null;
    private String serviceName = null;
    private DocumentQueueInterface docQueue = null;
    private long numRemoteDocsReceived = 0L;

    public static DocumentQueueXmitServices getServiceFor(String queueName) {
        return services.get(queueName);
    }

    public static void createServiceForQueue(String queueName, DocumentQueueInterface docQueue) {
        services.put(queueName, new DocumentQueueXmitServices(queueName, docQueue));
    }

    public static void shutdownServices() {
        Set<String> set = services.keySet();
        for (String key : set) {
            DocumentQueueXmitServices service = services.get(key);
            service.shutdown();
        }
        services.clear();
    }

    public static int send(String collectionId, List<SerializableDocument> docs) throws IOException, P2PException, DataBufferException {
        int rc = 0;
        if (services.size() != 1) {
            if (services.size() > 1) {
                throw new RuntimeException("There is more than one doc queue registered, must specify doc queue name");
            }
            throw new RuntimeException("There are no registered DocumentQueueXmitServices.  Insure that <NodeReplicationSupported> is set to true in ReleaseInfo");
        }
        Set<String> set = services.keySet();
        Iterator<String> iter = set.iterator();
        String queueName = iter.next();
        rc = DocumentQueueXmitServices.send(queueName, collectionId, docs);
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int send(String docQueueName, String collectionId, List<SerializableDocument> docs) throws IOException, P2PException, DataBufferException {
        int rc = 200;
        if (docQueueName != null) {
            NodeManager nodeManager = NodeManager.getInstance();
            Vector<Node> remoteNodes = nodeManager.getNodeList(true);
            if (remoteNodes != null && remoteNodes.size() > 0) {
                Properties properties = new Properties();
                properties.put(CollectionIdKey, collectionId);
                InputStream dataInputStream = null;
                DataBufferOutputStream dataBufferStream = new DataBufferOutputStream(100);
                try {
                    ObjectOutputStream oos = new ObjectOutputStream(dataBufferStream);
                    oos.writeObject(docs);
                    oos.close();
                    dataBufferStream.close();
                    for (int i = 0; i < remoteNodes.size(); ++i) {
                        String serviceName;
                        Node node = remoteNodes.get(i);
                        P2PDispatcher p2pDispatcher = P2PDispatcher.getInstance();
                        int replyCode = p2pDispatcher.sendMsg(node, serviceName = DocumentQueueXmitServices.makeServiceNameFrom(docQueueName), null, properties, dataInputStream = dataBufferStream.getInputStream(), null);
                        if (replyCode != 200) {
                            rc = replyCode;
                        }
                        dataInputStream.close();
                        dataInputStream = null;
                    }
                }
                finally {
                    if (dataInputStream != null) {
                        dataInputStream.close();
                    }
                    dataBufferStream.dispose();
                }
            } else {
                rc = 202;
            }
        } else {
            throw new RuntimeException("You must specify a docQueueName when calling DocumentQueueXmitServices.send()");
        }
        return rc;
    }

    private static String makeServiceNameFrom(String docQueueName) {
        StringBuilder sb = new StringBuilder(100);
        sb.append(ServicePrefix);
        sb.append(docQueueName);
        return sb.toString();
    }

    private DocumentQueueXmitServices(String _docQueueName, DocumentQueueInterface _docQueue) {
        this.docQueue = _docQueue;
        this.docQueueName = _docQueueName;
        this.serviceName = DocumentQueueXmitServices.makeServiceNameFrom(this.docQueueName);
        P2PDispatcher p2pDispatcher = P2PDispatcher.getInstance();
        this.msgReceiver = new MsgReciever();
        p2pDispatcher.addService(this.serviceName, this.msgReceiver);
    }

    public long getNumRemoteDocsReceived() {
        return this.numRemoteDocsReceived;
    }

    public void shutdown() {
        if (this.docQueueName != null) {
            P2PDispatcher p2pDispatcher = P2PDispatcher.getInstance();
            p2pDispatcher.removeService(this.serviceName);
            this.docQueue = null;
            this.docQueueName = null;
            this.serviceName = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MsgReciever
    implements P2PServiceInterface {
        @Override
        public int msgRecieved(Hashtable<String, String> params, Node sender, HttpServletRequest request, HttpServletResponse response) {
            int rc = 201;
            String collectionId = params.get(DocumentQueueXmitServices.CollectionIdKey);
            if (collectionId != null) {
                try {
                    ObjectInputStream ois = new ObjectInputStream((InputStream)request.getInputStream());
                    List documents = (List)ois.readObject();
                    for (int i = 0; i < documents.size(); ++i) {
                        DocumentQueueXmitServices.this.docQueue.addDocument(collectionId, (BaseDocument)documents.get(i));
                        DocumentQueueXmitServices.this.numRemoteDocsReceived++;
                    }
                    rc = 200;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return rc;
        }
    }
}

