/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.documentqueue;

import com.ibm.es.nuvo.common.Metadata;
import com.ibm.es.nuvo.documentqueue.BaseDocument;
import com.ibm.es.nuvo.documentqueue.DataBufferStreamDocument;
import com.ibm.es.nuvo.documentqueue.DeleteDocument;
import com.ibm.es.nuvo.documentqueue.DocumentQueue;
import com.ibm.es.nuvo.documentqueue.DocumentQueueInsertException;
import com.ibm.es.nuvo.documentqueue.DocumentQueueInterface;
import com.ibm.es.nuvo.documentqueue.QueuedDocument;
import com.ibm.es.nuvo.documentqueue.StreamedDocument;
import com.ibm.es.nuvo.util.Base64;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentQueueRestApi
implements DocumentQueueInterface {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private volatile boolean stop = false;
    private int emptyWait = 0;
    private Vector<String> candidateCollections;
    private LinkedList<QueuedDocument> list = new LinkedList();
    private DocumentQueue documentQueue = null;
    String remoteMachineName = "localhost";
    int remoteMachinePort = 8888;
    String messageToServer = "/api/document";
    String password = "W4Bryrs=";
    Thread sendData = null;

    private static String getEncodedCredentials(String pwd) {
        return Base64.encode(new String(":" + pwd).getBytes());
    }

    public DocumentQueueRestApi(int emptyWait, DocumentQueue queue) {
        this.emptyWait = emptyWait;
        this.documentQueue = queue;
        this.candidateCollections = new Vector();
        this.sendData = new Thread(new RestApiDataSend());
        this.sendData.start();
    }

    public DocumentQueueRestApi(int queuesize, int emptyWait, DocumentQueue queue, String name, int port) {
        this.emptyWait = emptyWait;
        this.remoteMachineName = name;
        this.remoteMachinePort = port;
        this.documentQueue = queue != null ? queue : new DocumentQueue(queuesize);
        this.candidateCollections = new Vector();
        this.sendData = new Thread(new RestApiDataSend());
        this.sendData.start();
    }

    @Override
    public void addDocument(String collectionId, BaseDocument document) throws DocumentQueueInsertException {
        this.documentQueue.addDocument(collectionId, document);
    }

    @Override
    public void addDocumentStream(String collectionId, BaseDocument document) throws DocumentQueueInsertException {
        this.documentQueue.addDocumentStream(collectionId, document);
    }

    @Override
    public void drainTo(Hashtable<String, LinkedList<QueuedDocument>> collection) {
        System.err.println("Your are Not support to be here");
    }

    @Override
    public void getDocuments(String collectionId, LinkedList<QueuedDocument> documentList) {
        while (true) {
            try {
                while (true) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    @Override
    public void getStatus(Vector<String> collectionIds, Vector<Boolean> docInBatchList, Vector<String> documentURIs, Vector<String> documentTypes, Vector<String> dataFiles) {
        this.documentQueue.getStatus(collectionIds, docInBatchList, documentURIs, documentTypes, dataFiles);
    }

    @Override
    public long getTotalDocsProcessed() {
        return this.documentQueue.getTotalDocsProcessed();
    }

    @Override
    public void removeDocuments(String collectionId, LinkedList<QueuedDocument> queuedDocuments) {
        System.err.println("Your are Not support to be here");
    }

    @Override
    public void getAllCollections(Vector<String> allCollections) {
    }

    @Override
    public int getCounter() {
        return this.documentQueue.getCounter();
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public void renameCollection(String oldCollectionId, String newCollectionId) {
        this.documentQueue.renameCollection(oldCollectionId, newCollectionId);
    }

    public class RestApiDataSend
    implements Runnable {
        public void run() {
            DocumentQueueRestApi.this.candidateCollections.removeAllElements();
            while (!DocumentQueueRestApi.this.stop) {
                try {
                    DocumentQueueRestApi.this.documentQueue.getAllCollections(DocumentQueueRestApi.this.candidateCollections);
                    for (int i = 0; i < DocumentQueueRestApi.this.candidateCollections.size(); ++i) {
                        try {
                            DocumentQueueRestApi.this.documentQueue.getDocuments((String)DocumentQueueRestApi.this.candidateCollections.get(i), DocumentQueueRestApi.this.list);
                            ListIterator iterator = DocumentQueueRestApi.this.list.listIterator();
                            while (iterator.hasNext()) {
                                QueuedDocument queuedDocument = (QueuedDocument)iterator.next();
                                if (this.sendDocument(queuedDocument, (String)DocumentQueueRestApi.this.candidateCollections.get(i))) continue;
                                System.err.println("Failed to send the document: " + queuedDocument.getDocument().getUri());
                            }
                            DocumentQueueRestApi.this.documentQueue.removeDocuments((String)DocumentQueueRestApi.this.candidateCollections.get(i), DocumentQueueRestApi.this.list);
                            DocumentQueueRestApi.this.list.clear();
                            continue;
                        }
                        catch (Throwable e) {
                            System.err.println(e.getMessage());
                        }
                    }
                    Thread.sleep(DocumentQueueRestApi.this.emptyWait);
                }
                catch (InterruptedException exception) {
                    System.err.println(exception.getMessage());
                }
            }
        }

        boolean sendDocument(QueuedDocument doc, String collectionId) {
            try {
                URL url = new URL("http", DocumentQueueRestApi.this.remoteMachineName, DocumentQueueRestApi.this.remoteMachinePort, DocumentQueueRestApi.this.messageToServer);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setDoInput(true);
                connection.setDoOutput(true);
                connection.setRequestMethod("POST");
                BaseDocument queued_document = doc.getDocument();
                if (queued_document instanceof DeleteDocument) {
                    System.out.println("Deleteing the document: " + queued_document.getUri());
                    connection.setRequestMethod("DELETE");
                    connection.addRequestProperty("index", collectionId);
                    connection.addRequestProperty("docId", queued_document.getUri());
                    connection.addRequestProperty("action", "deleteDocument");
                    connection.addRequestProperty("Authorization", "Basic " + DocumentQueueRestApi.getEncodedCredentials(DocumentQueueRestApi.this.password));
                    OutputStream out = connection.getOutputStream();
                    out.flush();
                    out.close();
                } else {
                    if (queued_document instanceof DataBufferStreamDocument) {
                        int br;
                        DataBufferStreamDocument crawlerDocument = (DataBufferStreamDocument)doc.getDocument();
                        Metadata metadata = crawlerDocument.getMetadata();
                        connection.addRequestProperty("collection", collectionId);
                        connection.addRequestProperty("docid", doc.getDocument().getUri());
                        connection.addRequestProperty("action", "addDocument");
                        if (metadata.get("ContentType") != null) {
                            connection.addRequestProperty("doctype", metadata.get("ContentType"));
                        }
                        if (metadata.get("ModifiedDate") != null) {
                            connection.addRequestProperty("lastmodified", metadata.get("ModifiedDate"));
                        }
                        connection.addRequestProperty("Authorization", "Basic " + DocumentQueueRestApi.getEncodedCredentials(DocumentQueueRestApi.this.password));
                        OutputStream out = connection.getOutputStream();
                        InputStream fin = ((StreamedDocument)doc.getDocument()).getInputStream();
                        byte[] buffer = new byte[2048];
                        while ((br = fin.read(buffer)) >= 0) {
                            out.write(buffer, 0, br);
                        }
                        out.flush();
                        fin.close();
                        out.close();
                        return connection != null && connection.getResponseCode() == 200;
                    }
                    if (queued_document instanceof StreamedDocument) {
                        int br;
                        connection.addRequestProperty("collection", collectionId);
                        connection.addRequestProperty("docid", doc.getDocument().getUri());
                        connection.addRequestProperty("action", "addDocument");
                        connection.addRequestProperty("doctype", "text/html");
                        connection.addRequestProperty("Authorization", "Basic " + DocumentQueueRestApi.getEncodedCredentials(DocumentQueueRestApi.this.password));
                        OutputStream out = connection.getOutputStream();
                        InputStream fin = ((StreamedDocument)doc.getDocument()).getInputStream();
                        byte[] buffer = new byte[2048];
                        while ((br = fin.read(buffer)) >= 0) {
                            out.write(buffer, 0, br);
                        }
                        out.flush();
                        fin.close();
                        out.close();
                        return connection != null && connection.getResponseCode() == 200;
                    }
                    System.err.println("Invalid document type: " + doc.toString() + " " + queued_document.toString());
                }
            }
            catch (Exception e) {
                System.out.println("Exception = " + e);
                e.printStackTrace();
                return false;
            }
            return true;
        }

        public void stopProcessing() {
            DocumentQueueRestApi.this.stop = true;
        }
    }
}

