/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.documentqueue;

import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.documentqueue.BaseDocument;
import com.ibm.es.nuvo.documentqueue.DocumentQueueInsertException;
import com.ibm.es.nuvo.documentqueue.DocumentQueueInterface;
import com.ibm.es.nuvo.documentqueue.DocumentQueueRestApi;
import com.ibm.es.nuvo.documentqueue.QueuedDocument;
import com.ibm.es.nuvo.network.NodeManager;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentQueueContainer
implements DocumentQueueInterface {
    String queueName;
    DocumentQueueInterface documentQueue;

    public void initialize(String QueueName) {
        this.queueName = QueueName;
        NodeManager nodeMgr = NodeManager.getInstance();
        if (nodeMgr.isMultiNode()) {
            // empty if block
        }
    }

    public void initialize(String QueueName, String machineName, int port) {
        this.queueName = QueueName;
        GlobalConfiguration gc = GlobalConfiguration.getConfiguration();
        this.documentQueue = new DocumentQueueRestApi(gc.getDocumentQueueSize(), 30, null, machineName, port);
    }

    @Override
    public void addDocument(String collectionId, BaseDocument document) throws DocumentQueueInsertException {
        this.documentQueue.addDocument(collectionId, document);
    }

    @Override
    public void addDocumentStream(String collectionId, BaseDocument document) throws DocumentQueueInsertException {
        this.documentQueue.addDocumentStream(collectionId, document);
    }

    @Override
    public void drainTo(Hashtable<String, LinkedList<QueuedDocument>> collection) {
        this.documentQueue.drainTo(collection);
    }

    @Override
    public void getAllCollections(Vector<String> allCollections) {
        this.documentQueue.getAllCollections(allCollections);
    }

    @Override
    public int getCounter() {
        return this.documentQueue.getCounter();
    }

    @Override
    public void getDocuments(String collectionId, LinkedList<QueuedDocument> documentList) {
        this.documentQueue.getDocuments(collectionId, documentList);
    }

    @Override
    public void getStatus(Vector<String> collectionIds, Vector<Boolean> docInBatchList, Vector<String> documentURIs, Vector<String> documentTypes, Vector<String> dataFiles) {
        this.documentQueue.getStatus(collectionIds, docInBatchList, documentURIs, documentTypes, dataFiles);
    }

    @Override
    public long getTotalDocsProcessed() {
        return this.documentQueue.getTotalDocsProcessed();
    }

    @Override
    public void removeDocuments(String collectionId, LinkedList<QueuedDocument> queuedDocuments) {
        this.documentQueue.removeDocuments(collectionId, queuedDocuments);
    }

    @Override
    public void renameCollection(String oldCollectionId, String newCollectionId) {
        this.documentQueue.renameCollection(oldCollectionId, newCollectionId);
    }
}

