/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.documentqueue;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.common.Metadata;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.crawler.runtime.AFPHandler;
import com.ibm.es.nuvo.documentqueue.BaseDocument;
import com.ibm.es.nuvo.documentqueue.DataBufferStreamDocument;
import com.ibm.es.nuvo.documentqueue.DeleteCrawlerDocument;
import com.ibm.es.nuvo.documentqueue.DeleteDocument;
import com.ibm.es.nuvo.documentqueue.DocumentQueueInsertException;
import com.ibm.es.nuvo.documentqueue.DocumentQueueInterface;
import com.ibm.es.nuvo.documentqueue.OptimizeIndexDocument;
import com.ibm.es.nuvo.documentqueue.QueuedDocument;
import com.ibm.es.nuvo.documentqueue.UpdateIndexDocument;
import com.ibm.es.nuvo.util.XMLTagger;
import com.ibm.es.nuvo.util.databuffer.DataBufferOutputStream;
import com.ibm.es.nuvo.util.parser.ParseException;
import com.ibm.es.nuvo.util.parser.ParseTree;
import com.ibm.es.nuvo.util.parser.Parser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentQueue
implements DocumentQueueInterface {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String DocQueueElement = "doc_queue";
    private static final String BatchElement = "batch";
    private static final String CollectionIdElement = "collection";
    private Hashtable<String, QueuedDocument> documentsInBatch;
    protected Hashtable<String, long[]> docsProcessedByCollection = null;
    int maxSize;
    Hashtable<String, LinkedList<QueuedDocument>> documents;
    Object waitToReceive = new Object();
    volatile int counter;
    private String tempCollectionId = null;
    final Lock lock = new ReentrantLock(true);
    Condition notFull = null;

    public DocumentQueue(int size) {
        this.documents = new Hashtable();
        this.maxSize = size;
        this.counter = 0;
        this.notFull = this.lock.newCondition();
        this.documentsInBatch = new Hashtable();
        this.docsProcessedByCollection = new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getAllCollections(Vector<String> allCollections) {
        Hashtable<String, LinkedList<QueuedDocument>> hashtable = this.documents;
        synchronized (hashtable) {
            Enumeration<String> keys = this.documents.keys();
            while (keys.hasMoreElements()) {
                String collectionId = keys.nextElement();
                allCollections.add(collectionId);
            }
        }
    }

    @Override
    public void addDocument(String collectionId, BaseDocument document) throws DocumentQueueInsertException {
        try {
            this.waitOnQueue();
        }
        catch (InterruptedException e) {
            throw new DocumentQueueInsertException(new Message("I0008E.CANNOT_INSERT_DOCUMENT", collectionId, document), (Throwable)e);
        }
        this.placeDocOnQueue(collectionId, document);
    }

    @Override
    public void addDocumentStream(String collectionId, BaseDocument document) throws DocumentQueueInsertException {
        String uri;
        if (document instanceof DataBufferStreamDocument && AFPHandler.isAFP(uri = ((DataBufferStreamDocument)document).getUri())) {
            document = this.convertISForAFPDocument(document, uri);
        }
        this.addDocument(collectionId, document);
    }

    private BaseDocument convertISForAFPDocument(BaseDocument document, String uri) {
        if (!(document instanceof DataBufferStreamDocument)) {
            return document;
        }
        try {
            int lastSlash = uri.lastIndexOf("/");
            int lastDot = uri.lastIndexOf(".");
            String afpFileName = uri.substring(lastSlash + 1, lastDot);
            AFPHandler afpHandler = AFPHandler.getAFPHandler();
            if (afpHandler != null) {
                DataBufferOutputStream dataBuffer = new DataBufferOutputStream();
                InputStream afpIS = ((DataBufferStreamDocument)document).getDataBuffer().getInputStream();
                String tempDir = GlobalConfiguration.getConfiguration().getTempDirectory();
                String pdfDirPath = tempDir + File.separator + "supa" + File.separator + "afp_pdf_conv";
                afpHandler.converAFPISToPDF(afpIS, afpFileName, pdfDirPath, true);
                InputStream pdfIS = afpHandler.getConvertedPDFIS();
                new File(pdfDirPath).delete();
                byte[] buf = new byte[pdfIS.available()];
                pdfIS.read(buf);
                dataBuffer.write(buf);
                dataBuffer.close();
                Metadata oldMD = ((DataBufferStreamDocument)document).getMetadata();
                DataBufferStreamDocument convDocument = new DataBufferStreamDocument(uri, dataBuffer);
                oldMD.getMetadataPart(Metadata.Type.CrawlerFields).set("title", uri);
                convDocument.setMetadata(oldMD);
                return convDocument;
            }
        }
        catch (Exception e) {
            return document;
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTotalDocsProcessed() {
        long totalDocs = 0L;
        Hashtable<String, long[]> hashtable = this.docsProcessedByCollection;
        synchronized (hashtable) {
            Collection<long[]> values = this.docsProcessedByCollection.values();
            for (long[] docsProcessed : values) {
                totalDocs += docsProcessed[0];
            }
        }
        return totalDocs;
    }

    public Hashtable<String, long[]> getTotalDocsProcessedByCollection() {
        return (Hashtable)this.docsProcessedByCollection.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getDocuments(String collectionId, LinkedList<QueuedDocument> documentList) {
        LinkedList<QueuedDocument> list = this.documents.get(collectionId);
        if (list != null) {
            Hashtable<String, LinkedList<QueuedDocument>> hashtable = this.documents;
            synchronized (hashtable) {
                int maxDocsInBatch = GlobalConfiguration.getConfiguration().getDocumentBatchSize();
                boolean batchFull = false;
                ListIterator iterator = list.listIterator();
                while (iterator.hasNext() && !batchFull) {
                    QueuedDocument queuedDocument = (QueuedDocument)iterator.next();
                    String url = queuedDocument.getDocument().getUri();
                    if (url == null) {
                        System.err.println("url is null");
                    }
                    if (queuedDocument.isRetrievePending() || url == null || this.documentsInBatch.containsKey(url)) continue;
                    queuedDocument.setRetrievePending();
                    documentList.add(queuedDocument);
                    boolean bl = batchFull = maxDocsInBatch > 0 && documentList.size() >= maxDocsInBatch;
                    if (url == null) continue;
                    this.documentsInBatch.put(url, queuedDocument);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drainTo(Hashtable<String, LinkedList<QueuedDocument>> collection) {
        Hashtable<String, LinkedList<QueuedDocument>> hashtable = this.documents;
        synchronized (hashtable) {
            Enumeration<String> keys = this.documents.keys();
            while (keys.hasMoreElements()) {
                String collectionId = keys.nextElement();
                LinkedList<QueuedDocument> documentList = new LinkedList<QueuedDocument>();
                this.getDocuments(collectionId, documentList);
                collection.put(collectionId, documentList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDocuments(String collectionId, LinkedList<QueuedDocument> queuedDocuments) {
        Cloneable sourceList;
        Object object = this.documents;
        synchronized (object) {
            ListIterator iterator = queuedDocuments.listIterator();
            sourceList = this.documents.get(collectionId);
            while (iterator.hasNext()) {
                QueuedDocument queuedDocument = (QueuedDocument)iterator.next();
                String url = queuedDocument.getDocument().getUri();
                if (url != null) {
                    this.documentsInBatch.remove(url);
                }
                queuedDocument.dispose();
                sourceList.remove(queuedDocument);
                if (sourceList.size() != 0) continue;
                this.documents.remove(collectionId);
            }
        }
        this.lock.lock();
        try {
            object = this.waitToReceive;
            synchronized (object) {
                this.counter -= queuedDocuments.size();
                long[] docsProcessedForCollection = this.docsProcessedByCollection.get(collectionId);
                if (docsProcessedForCollection == null) {
                    sourceList = this.docsProcessedByCollection;
                    synchronized (sourceList) {
                        docsProcessedForCollection = new long[]{0L};
                        this.docsProcessedByCollection.put(collectionId, docsProcessedForCollection);
                    }
                }
                if (docsProcessedForCollection != null) {
                    docsProcessedForCollection[0] = docsProcessedForCollection[0] + (long)queuedDocuments.size();
                }
                if (this.counter <= this.maxSize) {
                    for (int i = 0; i < queuedDocuments.size(); ++i) {
                        this.notFull.signal();
                    }
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int getCounter() {
        return this.counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getStatus(Vector<String> collectionIds, Vector<Boolean> docInBatchList, Vector<String> documentURIs, Vector<String> documentTypes, Vector<String> dataFiles) {
        Hashtable<String, LinkedList<QueuedDocument>> hashtable = this.documents;
        synchronized (hashtable) {
            Enumeration<String> keys = this.documents.keys();
            while (keys.hasMoreElements()) {
                String collectionId = keys.nextElement();
                LinkedList<QueuedDocument> sourceList = this.documents.get(collectionId);
                if (sourceList != null) {
                    ListIterator iterator = sourceList.listIterator();
                    while (iterator.hasNext()) {
                        QueuedDocument queuedDocument = (QueuedDocument)iterator.next();
                        collectionIds.add(collectionId);
                        docInBatchList.add(queuedDocument.isRetrievePending());
                        documentTypes.add(queuedDocument.getDocument().getClass().getName());
                        documentURIs.add(queuedDocument.getDocument().getUri());
                        if (dataFiles == null) continue;
                        String dataFileName = null;
                        BaseDocument bDoc = queuedDocument.getDocument();
                        if (bDoc != null && bDoc instanceof DataBufferStreamDocument) {
                            dataFileName = ((DataBufferStreamDocument)bDoc).getDataFileName();
                        }
                        dataFiles.add(dataFileName);
                    }
                    continue;
                }
                collectionIds.add(collectionId);
                docInBatchList.add(false);
                documentTypes.add(" - ");
                documentURIs.add("No doucment, just an empty vector for colleciton");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void placeDocOnQueue(String collectionId, BaseDocument document) {
        Hashtable<String, LinkedList<QueuedDocument>> hashtable = this.documents;
        synchronized (hashtable) {
            LinkedList<QueuedDocument> list = this.documents.get(collectionId);
            if (list == null) {
                list = new LinkedList();
                this.documents.put(collectionId, list);
            }
            LinkedList<QueuedDocument> linkedList = list;
            synchronized (linkedList) {
                list.add(new QueuedDocument(document));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitOnQueue() throws InterruptedException {
        this.lock.lock();
        try {
            while (this.counter >= this.maxSize) {
                this.notFull.await();
            }
            Object object = this.waitToReceive;
            synchronized (object) {
                ++this.counter;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateQueueAfterRestore(List<ExtendedException> errors) {
        Hashtable<String, LinkedList<QueuedDocument>> hashtable = this.documents;
        synchronized (hashtable) {
            Enumeration<String> keys = this.documents.keys();
            while (keys.hasMoreElements()) {
                String collectionId = keys.nextElement();
                LinkedList<QueuedDocument> sourceList = this.documents.get(collectionId);
                if (sourceList == null || sourceList.size() <= 0) continue;
                for (int i = sourceList.size() - 1; i >= 0; --i) {
                    QueuedDocument queuedDocument = sourceList.get(i);
                    BaseDocument doc = queuedDocument.getDocument();
                    if (doc == null || !(doc instanceof DataBufferStreamDocument)) continue;
                    DataBufferStreamDocument dbDoc = (DataBufferStreamDocument)doc;
                    try {
                        dbDoc.validateAfterRestore();
                        continue;
                    }
                    catch (Exception e) {
                        sourceList.remove(i);
                        --this.counter;
                        if (errors == null) continue;
                        Message msg = new Message("G0153E.DOC_IGNORED_AT_RESTART", doc.getUri());
                        ExtendedException ee = new ExtendedException(msg, (Throwable)e);
                        errors.add(ee);
                    }
                }
                if (sourceList.size() != 0) continue;
                this.documents.remove(collectionId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream os) throws IOException {
        XMLTagger xmlTagger = new XMLTagger(true, true);
        xmlTagger.openStartElement(DocQueueElement);
        xmlTagger.writeAttr("version", "1.0");
        xmlTagger.closeTag();
        Hashtable<String, LinkedList<QueuedDocument>> hashtable = this.documents;
        synchronized (hashtable) {
            Enumeration<String> keys = this.documents.keys();
            while (keys.hasMoreElements()) {
                String collectionId = keys.nextElement();
                LinkedList<QueuedDocument> sourceList = this.documents.get(collectionId);
                if (sourceList == null || sourceList.size() <= 0) continue;
                xmlTagger.startElement(BatchElement);
                xmlTagger.startElement(CollectionIdElement);
                xmlTagger.writeText(collectionId);
                xmlTagger.endElement(CollectionIdElement);
                ListIterator iterator = sourceList.listIterator();
                while (iterator.hasNext()) {
                    QueuedDocument queuedDocument = (QueuedDocument)iterator.next();
                    BaseDocument doc = queuedDocument.getDocument();
                    doc.writeTo(xmlTagger);
                }
                xmlTagger.endElement(BatchElement);
            }
        }
        xmlTagger.endElement(DocQueueElement);
        String xml = xmlTagger.getXML();
        try {
            os.write(xml.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ignore) {
            // empty catch block
        }
    }

    public static DocumentQueue loadFrom(int queueSize, List<ExtendedException> errors, InputStream is) throws ParseException {
        DocumentQueue docQueue = new DocumentQueue(queueSize);
        Parser parser = new Parser();
        ParseTree tree = new ParseTree();
        String parentPath = "/doc_queue/batch/";
        tree.addCallMethod(parentPath + CollectionIdElement, "setCollectionIdForBatch");
        tree.addSetSubcomponent(parentPath + "deleteDoc", "buildDeleteDocument");
        DeleteDocument.prepareParseTree(parentPath, tree);
        tree.addSetSubcomponent(parentPath + "deleteCrawlerDoc", "buildDeleteCrawlerDocument");
        DeleteCrawlerDocument.prepareParseTree(parentPath, tree);
        tree.addSetSubcomponent(parentPath + "updateIndexDoc", "buildUpdateIndexDocument");
        UpdateIndexDocument.prepareParseTree(parentPath, tree);
        tree.addSetSubcomponent(parentPath + "optimizeIndexDoc", "buildOptimizeIndexDocument");
        OptimizeIndexDocument.prepareParseTree(parentPath, tree);
        tree.addSetSubcomponent(parentPath + "DataBufferStreamDocument", "buildDataBufferStreamDocument");
        DataBufferStreamDocument.prepareParseTree(parentPath, tree);
        parser.parse(is, tree, docQueue);
        docQueue.validateQueueAfterRestore(errors);
        return docQueue;
    }

    public void setCollectionIdForBatch(String id) {
        this.tempCollectionId = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateIndexDocument buildUpdateIndexDocument() {
        UpdateIndexDocument doc = new UpdateIndexDocument();
        this.placeDocOnQueue(this.tempCollectionId, doc);
        Object object = this.waitToReceive;
        synchronized (object) {
            ++this.counter;
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OptimizeIndexDocument buildOptimizeIndexDocument() {
        OptimizeIndexDocument doc = new OptimizeIndexDocument();
        this.placeDocOnQueue(this.tempCollectionId, doc);
        Object object = this.waitToReceive;
        synchronized (object) {
            ++this.counter;
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeleteDocument buildDeleteDocument() {
        DeleteDocument doc = new DeleteDocument(null);
        this.placeDocOnQueue(this.tempCollectionId, doc);
        Object object = this.waitToReceive;
        synchronized (object) {
            ++this.counter;
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeleteCrawlerDocument buildDeleteCrawlerDocument() {
        DeleteCrawlerDocument doc = new DeleteCrawlerDocument(null);
        this.placeDocOnQueue(this.tempCollectionId, doc);
        Object object = this.waitToReceive;
        synchronized (object) {
            ++this.counter;
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataBufferStreamDocument buildDataBufferStreamDocument() {
        DataBufferStreamDocument doc = new DataBufferStreamDocument();
        this.placeDocOnQueue(this.tempCollectionId, doc);
        Object object = this.waitToReceive;
        synchronized (object) {
            ++this.counter;
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameCollection(String oldCollectionId, String newCollectionId) {
        Hashtable<String, LinkedList<QueuedDocument>> hashtable = this.documents;
        synchronized (hashtable) {
            LinkedList<QueuedDocument> list = this.documents.get(oldCollectionId);
            if (list != null) {
                this.documents.remove(oldCollectionId);
                this.documents.put(newCollectionId, list);
            }
        }
    }
}

