/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.documentqueue;

import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.common.Metadata;
import com.ibm.es.nuvo.documentqueue.CompoundDocument;
import com.ibm.es.nuvo.documentqueue.DocumentStreamCreateException;
import com.ibm.es.nuvo.documentqueue.StreamedDocument;
import com.ibm.es.nuvo.util.XMLTagger;
import com.ibm.es.nuvo.util.databuffer.DataBufferException;
import com.ibm.es.nuvo.util.databuffer.DataBufferOutputStream;
import com.ibm.es.nuvo.util.parser.ParseException;
import com.ibm.es.nuvo.util.parser.ParseTree;
import com.ibm.es.nuvo.util.parser.Parser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataBufferStreamDocument
implements CompoundDocument {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final long serialVersionUID = 6772034790033013643L;
    public static final String DataBufferStreamDocumentElement = "DataBufferStreamDocument";
    private static final String UriElement = "uri";
    public static final String PartsElement = "Parts";
    String uri;
    transient InputStream inputStream;
    DataBufferOutputStream dataBuffer;
    Metadata metadata;
    List<StreamedDocument> parts;

    public DataBufferStreamDocument(String uri, DataBufferOutputStream dataBuffer) throws DocumentStreamCreateException {
        this.uri = uri;
        this.dataBuffer = dataBuffer;
        this.setupInputStreamFromBuffer();
    }

    public DataBufferStreamDocument() {
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void resetInputStream() throws IOException, DataBufferException {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.dataBuffer != null) {
            this.inputStream = this.dataBuffer.getInputStream();
        }
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    public String getDataFileName() {
        String name = null;
        if (this.dataBuffer != null) {
            name = this.dataBuffer.getDataFileName();
        }
        return name;
    }

    @Override
    public InputStream getCacheStream() throws DocumentStreamCreateException {
        if (this.dataBuffer == null) {
            return null;
        }
        try {
            return this.dataBuffer.getInputStream();
        }
        catch (DataBufferException e) {
            throw new DocumentStreamCreateException(new Message("I0010E.CANNOT_CREATE_DOCUMENT", this.uri), (Throwable)e);
        }
    }

    @Override
    public void dispose() {
        if (this.dataBuffer != null) {
            this.dataBuffer.dispose();
        }
        if (this.parts != null) {
            for (StreamedDocument part : this.parts) {
                part.dispose();
            }
        }
    }

    @Override
    public Metadata getMetadata() {
        if (this.metadata == null) {
            this.metadata = new Metadata();
        }
        return this.metadata;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public void writeTo(OutputStream os, boolean writeDataBuffer) throws IOException {
        XMLTagger tagger = new XMLTagger(true, true);
        this.writeTo(tagger, writeDataBuffer);
        os.write(tagger.getXML().getBytes("UTF-8"));
    }

    @Override
    public void writeTo(XMLTagger tagger) throws IOException {
        this.writeTo(tagger, true);
    }

    public void writeTo(XMLTagger tagger, boolean writeDataBuffer) throws IOException {
        tagger.startElement(DataBufferStreamDocumentElement);
        tagger.startElement(UriElement);
        tagger.writeText(this.uri);
        tagger.endElement(UriElement);
        if (this.metadata != null) {
            this.metadata.writeTo(tagger);
        }
        if (this.dataBuffer != null && writeDataBuffer) {
            this.dataBuffer.writeTo(tagger);
        }
        if (this.parts != null) {
            tagger.startElement(PartsElement);
            for (StreamedDocument part : this.parts) {
                if (part instanceof DataBufferStreamDocument) {
                    ((DataBufferStreamDocument)part).writeTo(tagger, writeDataBuffer);
                    continue;
                }
                throw new UnsupportedOperationException("Not implemented for " + part.getClass().getName());
            }
            tagger.endElement(PartsElement);
        }
        tagger.endElement(DataBufferStreamDocumentElement);
    }

    public static DataBufferStreamDocument loadFrom(InputStream is) throws ParseException {
        DataBufferStreamDocument doc = new DataBufferStreamDocument();
        Parser parser = new Parser();
        ParseTree tree = new ParseTree();
        DataBufferStreamDocument.prepareParseTree("", tree);
        parser.parse(is, tree, doc);
        return doc;
    }

    protected static void prepareParseTree(String parentPath, ParseTree tree) {
        DataBufferStreamDocument.prepareParseTree(parentPath, tree, true);
    }

    protected static void prepareParseTree(String parentPath, ParseTree tree, boolean addKeysForParts) {
        if (!parentPath.endsWith("/")) {
            parentPath = parentPath + "/";
        }
        parentPath = parentPath + DataBufferStreamDocumentElement + "/";
        tree.addCallMethod(parentPath + UriElement, "setUri");
        tree.addSetSubcomponent(parentPath + "metadata", "createMetadata");
        Metadata.prepareParseTree(parentPath, tree);
        tree.addSetSubcomponent(parentPath + "DataBuffer", "createDataBufferOutputStream");
        DataBufferOutputStream.prepareParseTree(parentPath, tree);
        if (addKeysForParts) {
            tree.addCallMethod(parentPath + PartsElement, "createParts", null, null);
            tree.addSetSubcomponent(parentPath + PartsElement + "/" + DataBufferStreamDocumentElement, "createPart");
            DataBufferStreamDocument.prepareParseTree(parentPath + PartsElement + "/", tree, false);
        }
    }

    public void setUri(String _uri) {
        this.uri = _uri;
    }

    public Metadata createMetadata() {
        this.metadata = new Metadata();
        return this.metadata;
    }

    public DataBufferOutputStream createDataBufferOutputStream() {
        this.dataBuffer = new DataBufferOutputStream();
        return this.dataBuffer;
    }

    public void createParts() {
        this.parts = new LinkedList<StreamedDocument>();
    }

    public DataBufferStreamDocument createPart() {
        DataBufferStreamDocument doc = new DataBufferStreamDocument();
        this.addPart(doc);
        return doc;
    }

    public void validateAfterRestore() throws DocumentStreamCreateException, DataBufferException {
        if (this.dataBuffer != null) {
            this.dataBuffer.validateAfterRestore();
            this.setupInputStreamFromBuffer();
        }
        if (this.parts != null) {
            for (StreamedDocument docPart : this.parts) {
                if (!(docPart instanceof DataBufferStreamDocument)) continue;
                DataBufferStreamDocument dbDocPart = (DataBufferStreamDocument)docPart;
                dbDocPart.validateAfterRestore();
            }
        }
    }

    private void setupInputStreamFromBuffer() throws DocumentStreamCreateException {
        if (this.dataBuffer != null) {
            try {
                this.inputStream = this.dataBuffer.getInputStream();
            }
            catch (DataBufferException e) {
                throw new DocumentStreamCreateException(new Message("I0010E.CANNOT_CREATE_DOCUMENT", this.uri), (Throwable)e);
            }
        }
    }

    @Override
    public Iterable<StreamedDocument> getParts() {
        return this.parts != null ? this.parts : null;
    }

    public void addPart(StreamedDocument doc) {
        if (this.parts == null) {
            this.parts = new LinkedList<StreamedDocument>();
        }
        this.parts.add(doc);
    }

    public DataBufferOutputStream getDataBuffer() {
        return this.dataBuffer;
    }

    public void setDataBuffer(DataBufferOutputStream dataBuffer) {
        this.dataBuffer = dataBuffer;
    }
}

