/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.dataio.util.fenced.msg;

import com.ibm.es.nuvo.common.InvalidArgumentException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.dataio.DataIOType;
import com.ibm.es.nuvo.dataio.export.ExportException;
import com.ibm.es.nuvo.dataio.ingest.IngestException;
import com.ibm.es.nuvo.dataio.util.fenced.AbstractFencedProcess;
import com.ibm.es.nuvo.dataio.util.fenced.FencedProcessException;
import com.ibm.es.nuvo.dataio.util.fenced.MessageContent;
import com.ibm.es.nuvo.dataio.util.fenced.MessageHandler;
import com.ibm.es.nuvo.dataio.util.fenced.ProcessConstants;
import com.ibm.es.nuvo.util.uri.FSURIUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Date;
import java.util.Map;
import java.util.Properties;

public class MessageFencedTask
extends AbstractFencedProcess
implements ProcessConstants {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private final ProcessBuilder builder;
    protected InputStream dis;
    protected OutputStream dos;
    MessageHandler messageHandler;
    boolean isPipe;
    Thread handleThread;

    public MessageFencedTask(DataIOType.ExtType dataType) throws FencedProcessException {
        block8: {
            this.messageHandler = new MessageHandler();
            String executableFileNameForLog = "";
            try {
                GlobalConfiguration config = GlobalConfiguration.getConfiguration();
                File executableFile = null;
                if (dataType == DataIOType.ExtType.PST) {
                    this.isPipe = true;
                    String executablePath = config.getInstallPath() + File.separator + "bin";
                    File executablePathFile = new File(executablePath);
                    executableFile = new File(executablePathFile, "pstdataio.exe");
                    this.builder = new ProcessBuilder(executableFile.getCanonicalPath());
                    executableFileNameForLog = executableFile.getCanonicalPath();
                    break block8;
                }
                if (dataType == DataIOType.ExtType.NSF) {
                    String notesPath;
                    String notesLibPath;
                    this.isPipe = false;
                    int portNumber = this.messageHandler.startServer(0);
                    Properties prop = System.getProperties();
                    String java_home = prop.getProperty("java.home");
                    String java_classpath = prop.getProperty("java.class.path");
                    String java_libpath = prop.getProperty("java.library.path");
                    String javaMainClass = "com.ibm.es.nuvo.dataio.server.NotesDataIOMain";
                    File installPathFile = new File(config.getInstallPath());
                    String installPath = installPathFile.getCanonicalPath();
                    if (config.isWindows()) {
                        notesPath = notesLibPath = installPath + "\\notes.windows";
                    } else {
                        notesLibPath = installPath + "/domino.aix/notes/70030/ibmpow";
                        notesPath = notesLibPath + File.pathSeparator + installPath + "/domino.aix/notesdata";
                    }
                    java_libpath = java_libpath.length() > 0 ? java_libpath + File.pathSeparator + notesLibPath : notesLibPath;
                    executableFile = config.isWindows() ? new File(java_home + File.separator + "bin" + File.separator + "java.exe") : new File(java_home + File.separator + "bin" + File.separator + "java");
                    java_classpath = java_classpath.replaceAll("\"", "");
                    java_libpath = java_libpath.replaceAll("\"", "");
                    String[] processArgs = new String[]{executableFile.getCanonicalPath(), "-cp", java_classpath, "-Djava.library.path=" + java_libpath, javaMainClass, String.valueOf(portNumber)};
                    this.builder = new ProcessBuilder(processArgs);
                    executableFileNameForLog = executableFile.getCanonicalPath();
                    Map<String, String> envMap = this.builder.environment();
                    String pathVar = "PATH";
                    String envPath = envMap.get(pathVar);
                    if (envPath == null && (envPath = envMap.get(pathVar = "Path")) == null) {
                        pathVar = "PATH";
                    }
                    envPath = envPath != null && envPath.length() > 0 ? notesPath + File.pathSeparator + envPath : notesPath;
                    this.builder.environment().put(pathVar, envPath);
                    if (config.isAIX()) {
                        this.builder.environment().put("LIBPATH", java_libpath);
                    }
                    break block8;
                }
                this.builder = null;
                throw new RuntimeException("dataType:" + (Object)((Object)dataType) + " is not supported.");
            }
            catch (IOException ioe) {
                Message m = new Message("C8100E.CANNOT_START_INGESTPROCESS");
                m.addArgument(executableFileNameForLog);
                throw new FencedProcessException(m, (Throwable)ioe);
            }
        }
    }

    protected void init(Properties properties) throws FencedProcessException {
    }

    protected Object performCommand(Object[] args) throws FencedProcessException {
        if (args == null) {
            throw new FencedProcessException(new InvalidArgumentException("args0", "null"));
        }
        if (args.length == 0) {
            throw new FencedProcessException(new InvalidArgumentException("args0", "empty"));
        }
        Object retval = null;
        int command = (Integer)args[0];
        switch (command) {
            case 0: {
                break;
            }
            case 1: {
                String inputFilename = (String)args[1];
                Date baseDate = (Date)args[2];
                String userIdPath = (String)args[3];
                String userPass = (String)args[4];
                retval = this.doIngesting(inputFilename, baseDate, userIdPath, userPass);
                break;
            }
            case 2: {
                String[] uris = (String[])args[1];
                String outputFliename = (String)args[2];
                Boolean append = (Boolean)args[3];
                retval = this.doExporting(uris, outputFliename, append);
                break;
            }
            default: {
                throw new FencedProcessException(new InvalidArgumentException("command", String.valueOf(command)));
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startProcess() throws FencedProcessException {
        BufferedReader br = null;
        InputStream errStream = null;
        try {
            this.process = this.builder.start();
            errStream = this.process.getErrorStream();
            try {
                int exitValue = this.process.exitValue();
                br = new BufferedReader(new InputStreamReader(errStream));
                StringBuilder sb = new StringBuilder();
                String line = null;
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
                Message errMessage = null;
                if (sb.length() == 0) {
                    errMessage = new Message("C8101E.INGESTPROCESS_HAS_BEEN_DIED");
                    errMessage.addArgument(exitValue);
                } else {
                    errMessage = new Message("C8105E.INGESTPROCESS_HAS_BEEN_DIED_WITHERR");
                    errMessage.addArgument(exitValue);
                    errMessage.addArgument(sb.toString());
                }
                throw new FencedProcessException(errMessage);
            }
            catch (IllegalThreadStateException itse) {
                if (this.isPipe) {
                    this.dis = new BufferedInputStream(this.process.getInputStream());
                    this.dos = new BufferedOutputStream(this.process.getOutputStream());
                    this.messageHandler.setStreams(this.dis, this.dos);
                } else {
                    this.messageHandler.setServerSocketStream();
                }
                this.messageHandler.init();
                this.handleThread = new Thread(this.messageHandler);
                this.handleThread.setName("FencedProcessTask");
                this.handleThread.start();
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                    }
                    finally {
                        br = null;
                        errStream = null;
                    }
                }
                try {
                    if (errStream != null) {
                        errStream.close();
                    }
                }
                catch (IOException ioe) {}
            }
        }
        catch (IOException ioe) {
            try {
                int exitValue = this.process.exitValue();
                br = new BufferedReader(new InputStreamReader(errStream));
                StringBuilder sb = new StringBuilder();
                String line = null;
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
                Message errMessage = null;
                if (sb.length() == 0) {
                    errMessage = new Message("C8101E.INGESTPROCESS_HAS_BEEN_DIED");
                    errMessage.addArgument(exitValue);
                } else {
                    errMessage = new Message("C8105E.INGESTPROCESS_HAS_BEEN_DIED_WITHERR");
                    errMessage.addArgument(exitValue);
                    errMessage.addArgument(sb.toString());
                }
                throw new FencedProcessException(errMessage);
            }
            catch (IOException iioe) {
            }
            catch (IllegalThreadStateException itse) {
                throw new FencedProcessException(itse);
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                }
                finally {
                    br = null;
                    errStream = null;
                }
            }
            try {
                if (errStream != null) {
                    errStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    protected void term() throws FencedProcessException {
        int waitTime;
        if (this.messageHandler != null) {
            this.messageHandler.sendRequestTermination();
        }
        if ((waitTime = 0) < 10) {
            try {
                if (this.process != null) {
                    this.process.exitValue();
                }
            }
            catch (IllegalThreadStateException itse) {
                // empty catch block
            }
        }
        this.handleThread.interrupt();
        try {
            this.handleThread.join(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.messageHandler != null && !this.isPipe) {
            this.messageHandler.term();
        }
        this.messageHandler = null;
    }

    public Object ingestFile(String uri, Date baseDate, String userIdPath, String userPass) throws FencedProcessException {
        try {
            File file = FSURIUtil.getFileObject(uri);
            String filename = file.getCanonicalPath();
            Object[] cmdArgs = new Object[]{1, filename, baseDate, userIdPath, userPass};
            return this.process(cmdArgs);
        }
        catch (IOException ioe) {
            throw new FencedProcessException(ioe);
        }
    }

    public Object exportFile(String[] uris, String filename, Boolean append) throws FencedProcessException {
        Object[] cmdArgs = new Object[]{2, uris, filename, append};
        return this.process(cmdArgs);
    }

    public MessageContent getIngestResult(String uri) throws IngestException {
        try {
            return this.messageHandler.getResult(uri, MessageHandler.TaskType.INGEST);
        }
        catch (IngestException ie) {
            throw ie;
        }
        catch (Throwable t) {
            throw IngestException.handleUnknownException("", t);
        }
    }

    public Object getExportResult() throws ExportException {
        MessageContent result = null;
        while (true) {
            try {
                MessageContent obj = this.messageHandler.getResult(null, MessageHandler.TaskType.EXPORT);
                if (obj == null) break;
                result = obj;
            }
            catch (ExportException ee) {
                throw ee;
            }
            catch (Throwable t) {
                throw new ExportException(t);
            }
        }
        return result;
    }

    private Object doIngesting(String inputFilename, Date baseDate, String userIdPath, String userPass) throws FencedProcessException {
        this.messageHandler.sendRequestIngesting(inputFilename, baseDate, userIdPath, userPass);
        return null;
    }

    private Object doExporting(String[] uris, String outFile, Boolean append) throws FencedProcessException {
        this.messageHandler.sendRequestExporting(uris, outFile, append);
        return null;
    }
}

