/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.dataio.util.fenced;

import com.ibm.es.nuvo.dataio.util.fenced.AbstractFencedProcess;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessStack {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + ProcessStack.class.getName());
    private static final long serialVersionUID = 1L;
    private Semaphore semaphore;
    private final int timeout;
    private final int keepAlive;
    private Stack<AbstractFencedProcess> stack;
    private List<AbstractFencedProcess> using;
    private Object stackLock;

    public ProcessStack(int max, int tout, int kalive) {
        this.timeout = tout;
        this.keepAlive = kalive;
        this.semaphore = new Semaphore(max);
        this.stack = new Stack();
        this.using = new ArrayList<AbstractFencedProcess>();
        this.stackLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractFencedProcess loadProcess() {
        Object object = this.stackLock;
        synchronized (object) {
            AbstractFencedProcess p = this.stack.pop();
            this.using.add(p);
            return p;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseProcess(AbstractFencedProcess process) {
        Object object = this.stackLock;
        synchronized (object) {
            this.stack.push(process);
            this.using.remove(process);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeProcess(AbstractFencedProcess process) {
        Object object = this.stackLock;
        synchronized (object) {
            this.using.remove(process);
            this.semaphore.release(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.stackLock;
        synchronized (object) {
            return this.stack.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<AbstractFencedProcess> purge() {
        ArrayList<AbstractFencedProcess> badProcForKeepAlive = new ArrayList<AbstractFencedProcess>();
        ArrayList<AbstractFencedProcess> badProcForTimeout = new ArrayList<AbstractFencedProcess>();
        Object object = this.stackLock;
        synchronized (object) {
            AbstractFencedProcess p;
            ListIterator<Object> li;
            if (this.keepAlive > 0) {
                li = this.stack.listIterator();
                while (li.hasNext()) {
                    p = (AbstractFencedProcess)li.next();
                    if (System.currentTimeMillis() - p.getLastUsed() <= (long)this.keepAlive * 1000L) continue;
                    badProcForKeepAlive.add(p);
                    if (!tracer.isLoggable(Level.FINE)) continue;
                    tracer.fine("Killed keepAlive " + p);
                }
            }
            if (this.timeout > 0) {
                li = this.using.listIterator();
                while (li.hasNext()) {
                    p = (AbstractFencedProcess)li.next();
                    if (System.currentTimeMillis() - p.getStarted() <= (long)this.timeout * 1000L) continue;
                    badProcForTimeout.add(p);
                    if (!tracer.isLoggable(Level.FINE)) continue;
                    tracer.fine("Killed timeout " + p);
                }
            }
            for (AbstractFencedProcess pe : badProcForKeepAlive) {
                this.stack.remove(pe);
            }
            for (AbstractFencedProcess pe : badProcForTimeout) {
                this.using.remove(pe);
            }
        }
        int numOfBadProcesses = badProcForKeepAlive.size() + badProcForTimeout.size();
        if (numOfBadProcesses > 0) {
            this.semaphore.release(numOfBadProcesses);
        }
        badProcForKeepAlive.addAll(badProcForTimeout);
        return badProcForKeepAlive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AbstractFencedProcess> getAll() {
        ArrayList<AbstractFencedProcess> list = new ArrayList<AbstractFencedProcess>();
        Object object = this.stackLock;
        synchronized (object) {
            list.addAll(this.stack);
            list.addAll(this.using);
        }
        return list;
    }

    public boolean isAvailable() {
        boolean rc = this.semaphore.tryAcquire(1);
        return rc;
    }
}

