/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.dataio.util.fenced;

import com.ibm.es.nuvo.dataio.util.fenced.AbstractFencedProcess;
import com.ibm.es.nuvo.dataio.util.fenced.FencedProcessException;
import com.ibm.es.nuvo.dataio.util.fenced.ProcessStack;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessManager {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + ProcessManager.class.getName());
    private static final ProcessManager instance = new ProcessManager();
    private Timer timer;
    private List<WeakReference<AbstractFencedProcess>> killed = new ArrayList<WeakReference<AbstractFencedProcess>>();
    private HashMap<Class<? extends AbstractFencedProcess>, ProcessStack> processMap = new HashMap();

    public static ProcessManager getInstance() {
        return instance;
    }

    private ProcessManager() {
        this.timer = new Timer("ProcessManager_Timer", true);
        this.timer.schedule((TimerTask)new MonitorProcessTask(), 1000L, 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        if (tracer.isLoggable(Level.FINE)) {
            tracer.fine("terminating");
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
        HashMap<Class<? extends AbstractFencedProcess>, ProcessStack> hashMap = this.processMap;
        synchronized (hashMap) {
            for (ProcessStack ps : this.processMap.values()) {
                for (AbstractFencedProcess p : ps.getAll()) {
                    this.kill(p);
                }
            }
        }
        if (tracer.isLoggable(Level.FINER)) {
            tracer.finer("waiting for termination");
        }
        this.waitForKilled(600);
        if (tracer.isLoggable(Level.FINER)) {
            tracer.finer("terminated");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseProcess(AbstractFencedProcess process) {
        ProcessStack st;
        if (tracer.isLoggable(Level.FINER)) {
            tracer.finer("released " + process);
        }
        ProcessStack processStack = st = this.getStack(process.getClass());
        synchronized (processStack) {
            st.releaseProcess(process);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeProcess(AbstractFencedProcess process) {
        ProcessStack st;
        if (tracer.isLoggable(Level.FINER)) {
            tracer.finer("dispose " + process);
        }
        ProcessStack processStack = st = this.getStack(process.getClass());
        synchronized (processStack) {
            st.disposeProcess(process);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractFencedProcess getProcesses(Class<? extends AbstractFencedProcess> cls, Class<?>[] argCls, Object[] args) throws FencedProcessException {
        ProcessStack st = this.getStack(cls);
        AbstractFencedProcess proc = null;
        while (!Thread.currentThread().isInterrupted()) {
            ProcessStack processStack = st;
            synchronized (processStack) {
                if (st.size() > 0) {
                    proc = st.loadProcess();
                    break;
                }
            }
            if (st.isAvailable()) {
                proc = this.createProcess(cls, argCls, args);
                st.releaseProcess(proc);
                continue;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ignored) {}
        }
        if (tracer.isLoggable(Level.FINER)) {
            tracer.finer("got " + proc);
        }
        return proc;
    }

    private AbstractFencedProcess createProcess(Class<? extends AbstractFencedProcess> cls, Class<?>[] argCls, Object[] args) throws FencedProcessException {
        AbstractFencedProcess process = null;
        try {
            process = args == null ? cls.newInstance() : cls.getConstructor(argCls).newInstance(args);
            if (tracer.isLoggable(Level.FINER)) {
                tracer.finer("created " + (args == null ? "null" : Arrays.asList(args)));
            }
            process.initialize(null);
        }
        catch (Throwable t) {
            if (t instanceof FencedProcessException) {
                throw (FencedProcessException)t;
            }
            throw new FencedProcessException(t);
        }
        return process;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void kill(AbstractFencedProcess process) {
        KillerThread thread = new KillerThread(process);
        thread.start();
        if (tracer.isLoggable(Level.FINER)) {
            tracer.finer("kill " + process);
        }
        List<WeakReference<AbstractFencedProcess>> list = this.killed;
        synchronized (list) {
            this.killed.add(new WeakReference<AbstractFencedProcess>(process));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForKilled(int maxWait) {
        long max = System.currentTimeMillis() + (long)maxWait * 1000L;
        while (max < System.currentTimeMillis() && this.killed.size() > 0) {
            List<WeakReference<AbstractFencedProcess>> list = this.killed;
            synchronized (list) {
                ListIterator<WeakReference<AbstractFencedProcess>> li = this.killed.listIterator();
                ArrayList<AbstractFencedProcess> removedList = new ArrayList<AbstractFencedProcess>();
                while (li.hasNext()) {
                    WeakReference<AbstractFencedProcess> wr = li.next();
                    AbstractFencedProcess p = (AbstractFencedProcess)wr.get();
                    if (p != null && p.isAlive()) continue;
                    removedList.add(p);
                }
                for (AbstractFencedProcess entry : removedList) {
                    this.killed.remove(entry);
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ignored) {
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcessStack getStack(Class<? extends AbstractFencedProcess> cls) {
        ProcessStack st = this.processMap.get(cls);
        if (st == null) {
            HashMap<Class<? extends AbstractFencedProcess>, ProcessStack> hashMap = this.processMap;
            synchronized (hashMap) {
                st = this.processMap.get(cls);
                if (st == null) {
                    st = this.createStack(cls);
                    this.processMap.put(cls, st);
                }
            }
        }
        return st;
    }

    private ProcessStack createStack(Class<? extends AbstractFencedProcess> cls) {
        int max = 20;
        int alive = -1;
        int timeout = -1;
        max = this.getSys(cls, ".max", max);
        alive = this.getSys(cls, ".keepalive", alive);
        timeout = this.getSys(cls, ".timeout", timeout);
        if (tracer.isLoggable(Level.FINER)) {
            tracer.finer("create stack " + max + ", " + alive + ", " + timeout);
        }
        return new ProcessStack(max, alive, timeout);
    }

    private int getSys(Class<? extends AbstractFencedProcess> cls, String suffix, int def) {
        String p = System.getProperties().getProperty(cls.getName() + suffix);
        if (p != null) {
            return Integer.parseInt(p);
        }
        return def;
    }

    private class MonitorProcessTask
    extends TimerTask {
        private MonitorProcessTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                HashMap hashMap = ProcessManager.this.processMap;
                synchronized (hashMap) {
                    for (ProcessStack ps : ProcessManager.this.processMap.values()) {
                        ArrayList<AbstractFencedProcess> list = ps.purge();
                        for (AbstractFencedProcess p : list) {
                            ProcessManager.this.kill(p);
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static class KillerThread
    extends Thread {
        private final AbstractFencedProcess process;

        public KillerThread(AbstractFencedProcess proc) {
            this.process = proc;
        }

        public void run() {
            try {
                this.process.terminate();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

